/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.providers;

import java.util.Iterator;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;

public class DiagramPropertyTester
extends PropertyTester {
    public static final String IS_DIAGRAM = "isDiagram";
    public static final String DIAGRAM_HAS_REQUIRED_EDIT_POLICY = "hasRequiredEditPolicy";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_DIAGRAM.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.isDiagram((IStructuredSelection)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        if (DIAGRAM_HAS_REQUIRED_EDIT_POLICY.equals(property) && receiver instanceof IStructuredSelection && args.length == 1 && args[0] instanceof String) {
            boolean answer = this.hasRequiredEditPolicy((IStructuredSelection)receiver, (String)args[0]);
            return new Boolean(answer).equals(expectedValue);
        }
        return false;
    }

    protected boolean hasRequiredEditPolicy(IStructuredSelection selection, String wantedEditPolicy) {
        EditPart parent;
        DiagramEditPart diagramEP;
        Object first;
        boolean answer = false;
        if (selection.size() != 0 && (first = selection.getFirstElement()) instanceof EditPart && (diagramEP = DiagramEditPartsUtil.getDiagramEditPart((EditPart)(parent = (EditPart)first))) != null) {
            answer = diagramEP.getEditPolicy((Object)wantedEditPolicy) != null;
        }
        return answer;
    }

    private boolean isDiagram(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                if (iter.next() instanceof Diagram) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

