/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.appearance.helper.AppearanceHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationLabelEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AppliedStereotypeCommentCreationEditPolicyEx;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.CustomConnectionHandleEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.ElementIconUtil;
import org.eclipse.swt.graphics.Image;

public class CustomTimeObservationLabelEditPart
extends TimeObservationLabelEditPart
implements INodeEditPart,
IPapyrusEditPart {
    public CustomTimeObservationLabelEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new CustomConnectionHandleEditPolicy());
        this.installEditPolicy("Applied_Stereotype_Comment", (EditPolicy)new AppliedStereotypeCommentCreationEditPolicyEx());
    }

    @Override
    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof NodeFigure && this.getWrappingLabel(figure) != null) {
            return this.getWrappingLabel(figure).getText();
        }
        return super.getLabelTextHelper(figure);
    }

    @Override
    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof NodeFigure && this.getWrappingLabel(figure) != null) {
            this.getWrappingLabel(figure).setText(text);
        } else {
            super.setLabelTextHelper(figure, text);
        }
    }

    @Override
    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof NodeFigure && this.getWrappingLabel(figure) != null) {
            return this.getWrappingLabel(figure).getIcon();
        }
        return super.getLabelIconHelper(figure);
    }

    @Override
    protected void setLabelIconHelper(IFigure figure, Image icon) {
        if (figure instanceof NodeFigure && this.getWrappingLabel(figure) != null) {
            this.getWrappingLabel(figure).setIcon(icon);
        } else {
            super.setLabelIconHelper(figure, icon);
        }
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getView_SourceEdges().equals(feature)) {
            this.refreshSourceConnections();
        } else if (NotationPackage.eINSTANCE.getView_TargetEdges().equals(feature)) {
            this.refreshTargetConnections();
        }
        if (ElementIconUtil.isIconNotification(event)) {
            this.refreshLabel();
        }
        super.handleNotificationEvent(event);
    }

    protected NodeFigure createFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        return figure;
    }

    protected NodeFigure createNodePlate() {
        NodeFigure result = new NodeFigure();
        return result;
    }

    protected IFigure createNodeShape() {
        IFigure label = this.createFigurePrim();
        return label;
    }

    protected WrappingLabel getWrappingLabel(IFigure nodeFigure) {
        if (nodeFigure instanceof NodeFigure) {
            return (WrappingLabel)nodeFigure.getChildren().get(0);
        }
        return null;
    }

    protected List getModelSourceConnections() {
        return ViewUtil.getSourceConnectionsConnectingVisibleViews((View)((View)this.getModel()));
    }

    protected List getModelTargetConnections() {
        List list = ViewUtil.getTargetConnectionsConnectingVisibleViews((View)((View)this.getModel()));
        return list;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof ReconnectRequest) {
            if (((DropRequest)request).getLocation() == null) {
                return ((NodeFigure)this.getFigure()).getSourceConnectionAnchorAt(null);
            }
            Point pt = ((DropRequest)request).getLocation().getCopy();
            return ((NodeFigure)this.getFigure()).getSourceConnectionAnchorAt(pt);
        }
        if (request instanceof DropRequest) {
            return ((NodeFigure)this.getFigure()).getSourceConnectionAnchorAt(((DropRequest)request).getLocation());
        }
        return ((NodeFigure)this.getFigure()).getSourceConnectionAnchorAt(null);
    }

    public ConnectionAnchor getSourceConnectionAnchor(org.eclipse.gef.ConnectionEditPart connEditPart) {
        final ConnectionEditPart connection = (ConnectionEditPart)connEditPart;
        String t = "";
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = ((Edge)connection.getModel()).getSourceAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getSourceConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getSourceConnectionAnchor", (Throwable)e);
        }
        return ((NodeFigure)this.getFigure()).getConnectionAnchor(t);
    }

    public ConnectionAnchor getTargetConnectionAnchor(org.eclipse.gef.ConnectionEditPart connEditPart) {
        final ConnectionEditPart connection = (ConnectionEditPart)connEditPart;
        String t = "";
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = ((Edge)connection.getModel()).getTargetAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getTargetConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getTargetConnectionAnchor", (Throwable)e);
        }
        return ((NodeFigure)this.getFigure()).getConnectionAnchor(t);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof ReconnectRequest) {
            if (((DropRequest)request).getLocation() == null) {
                return ((NodeFigure)this.getFigure()).getTargetConnectionAnchorAt(null);
            }
            Point pt = ((DropRequest)request).getLocation().getCopy();
            return ((NodeFigure)this.getFigure()).getTargetConnectionAnchorAt(pt);
        }
        if (request instanceof DropRequest) {
            return ((NodeFigure)this.getFigure()).getTargetConnectionAnchorAt(((DropRequest)request).getLocation());
        }
        return ((NodeFigure)this.getFigure()).getTargetConnectionAnchorAt(null);
    }

    public String mapConnectionAnchorToTerminal(ConnectionAnchor c) {
        return ((NodeFigure)this.getFigure()).getConnectionAnchorTerminal(c);
    }

    public ConnectionAnchor mapTerminalToConnectionAnchor(String terminal) {
        return ((NodeFigure)this.getFigure()).getConnectionAnchor(terminal);
    }

    public boolean canAttachNote() {
        return true;
    }

    @Override
    protected Image getLabelIcon() {
        if (AppearanceHelper.showElementIcon((EModelElement)this.getNotationView())) {
            return UMLElementTypes.getImage((ENamedElement)this.resolveSemanticElement().eClass());
        }
        return null;
    }

    @Override
    public void refreshBounds() {
        super.refreshBounds();
        IBorderItemLocator locator = this.getBorderItemLocator();
        if (locator != null) {
            locator.relocate(this.getFigure());
        }
    }

    public IFigure getPrimaryShape() {
        return this.getFigure();
    }
}

