/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.PromptCreateElementAndNodeCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ActionExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.BehaviorExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomLifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineChildGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;

public class ElementCreationWithMessageEditPolicy
extends LifelineChildGraphicalNodeEditPolicy {
    @Override
    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        Command command = super.getConnectionCompleteCommand(request);
        if (command != null && command.canExecute() && request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionViewAndElementRequest viewRequest = (CreateConnectionViewAndElementRequest)request;
            EditPart targetEP = this.getTargetEditPart((Request)viewRequest);
            EObject target = ViewUtil.resolveSemanticElement((View)((View)targetEP.getModel()));
            EditPart sourceEP = viewRequest.getSourceEditPart();
            EObject source = ViewUtil.resolveSemanticElement((View)((View)sourceEP.getModel()));
            if ((ElementCreationWithMessageEditPolicy.getSyncMessageHint().equals(viewRequest.getConnectionViewDescriptor().getSemanticHint()) || ElementCreationWithMessageEditPolicy.getReplyMessageHint().equals(viewRequest.getConnectionViewDescriptor().getSemanticHint())) && (target instanceof Lifeline || target instanceof ExecutionSpecification && target.equals(source))) {
                EditPart sourceEditPart;
                InteractionFragment ift = SequenceUtil.findInteractionFragmentContainerAt(viewRequest.getLocation(), this.getHost());
                if (target instanceof ExecutionSpecification) {
                    targetEP = targetEP.getParent();
                    target = ViewUtil.resolveSemanticElement((View)((View)targetEP.getModel()));
                }
                if ((sourceEditPart = request.getSourceEditPart()) instanceof ActionExecutionSpecificationEditPart || sourceEditPart instanceof BehaviorExecutionSpecificationEditPart) {
                    return new ICommandProxy((ICommand)new PromptCreateElementAndNodeCommand(command, this.getEditingDomain(), viewRequest.getConnectionViewDescriptor(), (ShapeNodeEditPart)targetEP, target, sourceEP, request, ift));
                }
            }
        }
        return command;
    }

    private static String getSyncMessageHint() {
        IHintedType message = (IHintedType)UMLElementTypes.Message_4003;
        return message.getSemanticHint();
    }

    private static String getReplyMessageHint() {
        IHintedType message = (IHintedType)UMLElementTypes.Message_4005;
        return message.getSemanticHint();
    }

    private TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        CustomLifelineEditPart lifeline;
        boolean inlineMode;
        EditPart host = this.getHost();
        if (host instanceof CustomLifelineEditPart && (inlineMode = (lifeline = (CustomLifelineEditPart)host).isInlineMode())) {
            Object type = request.getType();
            if ("connection end".equals(type)) {
                Point location = ((CreateConnectionRequest)request).getLocation().getCopy();
                if (this.isCreateConnectionRequest(request, UMLElementTypes.Message_4006) && this.isLocatedOnLifelineHeader(lifeline, location)) {
                    return host;
                }
                return this.getTargetEditPart(request, lifeline, location);
            }
            if ("connection start".equals(type)) {
                Point location = ((CreateConnectionRequest)request).getLocation().getCopy();
                return this.getTargetEditPart(request, lifeline, location);
            }
            if ("Reconnection source".equals(type)) {
                Point location = ((ReconnectRequest)request).getLocation().getCopy();
                return this.getTargetEditPart(request, lifeline, location);
            }
            if ("Reconnection target".equals(type)) {
                Point location = ((ReconnectRequest)request).getLocation().getCopy();
                ConnectionEditPart conn = ((ReconnectRequest)request).getConnectionEditPart();
                View model = (View)conn.getModel();
                if (4006 == UMLVisualIDRegistry.getVisualID(model) && this.isLocatedOnLifelineHeader(lifeline, location)) {
                    return host;
                }
                return this.getTargetEditPart(request, lifeline, location);
            }
        }
        return super.getTargetEditPart(request);
    }

    private EditPart getTargetEditPart(Request request, CustomLifelineEditPart lifeline, Point location) {
        EditPart childEditPart = this.getChildEditPart(lifeline, location);
        if (childEditPart instanceof CustomLifelineEditPart) {
            CustomLifelineEditPart childLifeline = (CustomLifelineEditPart)childEditPart;
            if (this.isCreateConnectionRequest(request, UMLElementTypes.Message_4006) && this.isLocatedOnLifelineHeader(childLifeline, location)) {
                return childEditPart;
            }
            if (request instanceof ReconnectRequest && 4006 == UMLVisualIDRegistry.getVisualID((View)((ReconnectRequest)request).getConnectionEditPart().getModel()) && this.isLocatedOnLifelineHeader(childLifeline, location)) {
                return childEditPart;
            }
            if (this.isLocatedOnLifelineDotLine(childLifeline, location)) {
                return childEditPart;
            }
            return null;
        }
        return childEditPart;
    }

    private EditPart getChildEditPart(CustomLifelineEditPart lifeline, Point location) {
        List children = lifeline.getChildren();
        for (Object object : children) {
            if (!(object instanceof GraphicalEditPart)) continue;
            GraphicalEditPart child = (GraphicalEditPart)object;
            IFigure figure = child.getFigure();
            Point pt = location.getCopy();
            figure.translateToRelative((Translatable)pt);
            if (!figure.containsPoint(pt)) continue;
            return child;
        }
        return null;
    }

    private boolean isLocatedOnLifelineDotLine(CustomLifelineEditPart host, Point location) {
        CustomLifelineEditPart.CustomLifelineFigure primaryShape = host.getPrimaryShape();
        LifelineDotLineCustomFigure figureLifelineDotLineFigure = primaryShape.getFigureLifelineDotLineFigure();
        Point pt = location.getCopy();
        NodeFigure dashLineRectangle = figureLifelineDotLineFigure.getDashLineRectangle();
        Rectangle rect = dashLineRectangle.getBounds().getExpanded(new Insets(0, 2, 0, 2));
        figureLifelineDotLineFigure.translateToAbsolute((Translatable)rect);
        return rect.contains(pt);
    }

    private boolean isLocatedOnLifelineHeader(CustomLifelineEditPart host, Point location) {
        RectangleFigure figureLifelineNameContainerFigure = host.getPrimaryShape().getFigureLifelineNameContainerFigure();
        Point pt = location.getCopy();
        figureLifelineNameContainerFigure.translateToRelative((Translatable)pt);
        return figureLifelineNameContainerFigure.containsPoint(pt);
    }
}

