/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.viewpoints.policy.ModelAddData;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.commands.ConstraintCreateCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.ElementInitializers;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

public class CustomConstraintCreateCommand
extends ConstraintCreateCommand {
    private Diagram diagram = null;

    public CustomConstraintCreateCommand(CreateElementRequest req, Diagram diagram) {
        super(req, diagram);
        this.diagram = diagram;
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Constraint newElement = UMLFactory.eINSTANCE.createConstraint();
        EObject target = this.getElementToEdit();
        ModelAddData data = PolicyChecker.getCurrent().getChildAddData(this.diagram, target, (EObject)newElement);
        if (data.isPermitted()) {
            if (data.isPathDefined()) {
                if (!data.execute(target, (EObject)newElement)) {
                    return CommandResult.newErrorCommandResult((String)"Failed to follow the policy-specified for the insertion of the new element");
                }
            } else {
                Package qualifiedTarget = ((Element)target).getNearestPackage();
                qualifiedTarget.getPackagedElements().add((Object)newElement);
            }
        } else {
            return CommandResult.newErrorCommandResult((String)"The active policy restricts the addition of this element");
        }
        ElementInitializers.getInstance().init_Constraint_668(newElement);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }
}

