/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.providers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;
import org.eclipse.papyrus.infra.extendedtypes.util.ElementTypeUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramVersioningUtils;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class UMLViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        String modelID = UMLVisualIDRegistry.getModelID(op.getContainerView());
        if (!this.getDiagramProvidedId().equals(modelID)) {
            return false;
        }
        int visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
        if (Node.class.isAssignableFrom(op.getViewKind())) {
            return UMLVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
        }
        return true;
    }

    protected String getDiagramProvidedId() {
        return "PapyrusUMLStateMachineDiagram";
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "PapyrusUMLStateMachineDiagram".equals(op.getSemanticHint()) && UMLVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != -1;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        int visualID;
        if (op.getContainerView() == null) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        if (op.getSemanticHint() == null) {
            if (elementType != null || domainElement == null) {
                return false;
            }
            visualID = UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
        } else {
            visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
            if (elementType != null) {
                if (elementType instanceof IExtendedHintedElementType ? domainElement != null && !UMLVisualIDRegistry.checkNodeVisualID(op.getContainerView(), domainElement, visualID) : !UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
                if (domainElement != null && visualID != UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) {
                    return false;
                }
            } else {
                if (!"PapyrusUMLStateMachineDiagram".equals(UMLVisualIDRegistry.getModelID(op.getContainerView()))) {
                    return false;
                }
                switch (visualID) {
                    case 666: 
                    case 668: 
                    case 680: 
                    case 690: 
                    case 691: 
                    case 692: 
                    case 2000: 
                    case 3000: 
                    case 5000: 
                    case 6000: 
                    case 8000: 
                    case 9000: 
                    case 10000: 
                    case 11000: 
                    case 12000: 
                    case 13000: 
                    case 14000: 
                    case 15000: 
                    case 16000: 
                    case 17000: 
                    case 18000: {
                        if (domainElement != null && visualID == UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return 2000 == visualID || 3000 == visualID || 5000 == visualID || 6000 == visualID || 8000 == visualID || 9000 == visualID || 10000 == visualID || 11000 == visualID || 12000 == visualID || 13000 == visualID || 14000 == visualID || 15000 == visualID || 16000 == visualID || 17000 == visualID || 18000 == visualID || 666 == visualID || 668 == visualID || 680 == visualID || 690 == visualID || 691 == visualID || 692 == visualID;
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType closestNonExtendedType;
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (elementType instanceof IExtendedHintedElementType ? !UMLElementTypes.isKnownElementType(closestNonExtendedType = ElementTypeUtils.getClosestDiagramType((IElementType)elementType)) || !(closestNonExtendedType instanceof IHintedType) : !UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        if (elementTypeHint == null || op.getSemanticHint() != null && !elementTypeHint.equals(op.getSemanticHint())) {
            return false;
        }
        int visualID = UMLVisualIDRegistry.getVisualID(elementTypeHint);
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        return domainElement == null || visualID == UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        DiagramVersioningUtils.stampCurrentVersion((Diagram)diagram);
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("PapyrusUMLStateMachineDiagram");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        int visualID = semanticHint == null ? UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement) : UMLVisualIDRegistry.getVisualID(semanticHint);
        switch (visualID) {
            case 2000: {
                return this.createStateMachine_2000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3000: {
                return this.createRegion_3000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 5000: {
                return this.createFinalState_5000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 6000: {
                return this.createState_6000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 8000: {
                return this.createPseudostate_8000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 9000: {
                return this.createPseudostate_9000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 10000: {
                return this.createPseudostate_10000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 11000: {
                return this.createPseudostate_11000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 12000: {
                return this.createPseudostate_12000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 13000: {
                return this.createPseudostate_13000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 14000: {
                return this.createPseudostate_14000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 15000: {
                return this.createPseudostate_15000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 16000: {
                return this.createPseudostate_16000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 17000: {
                return this.createPseudostate_17000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 18000: {
                return this.createConnectionPointReference_18000(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 666: {
                return this.createComment_666(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 668: {
                return this.createConstraint_668(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 680: {
                return this.createTransition_680(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 690: {
                return this.createBehavior_690(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 691: {
                return this.createBehavior_691(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 692: {
                return this.createBehavior_692(domainElement, containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        switch (UMLVisualIDRegistry.getVisualID(elementTypeHint)) {
            case 7000: {
                return this.createTransition_7000(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 19000: {
                return this.createGeneralization_19000(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 667: {
                return this.createCommentAnnotatedElement_667(containerView, index, persisted, preferencesHint);
            }
            case 670: {
                return this.createConstraintConstrainedElement_670(containerView, index, persisted, preferencesHint);
            }
            case 8500: {
                return this.createConstraintContext_8500(containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Node createStateMachine_2000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateMachine");
        Node label2001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(2001));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(2002), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateMachine");
        return node;
    }

    public Node createRegion_3000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Region");
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(3002), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Region");
        return node;
    }

    public Node createFinalState_5000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(5000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FinalState");
        Node label5001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5001));
        label5001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5001 = (Location)label5001.getLayoutConstraint();
        location5001.setX(25);
        location5001.setY(3);
        Node label5002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5002));
        label5002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5002 = (Location)label5002.getLayoutConstraint();
        location5002.setX(25);
        location5002.setY(-10);
        return node;
    }

    public Node createState_6000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(6000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"State");
        Node label6001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6001));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(6002), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"State");
        return node;
    }

    public Node createPseudostate_8000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(8000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node label8001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(8001));
        label8001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location8001 = (Location)label8001.getLayoutConstraint();
        location8001.setX(25);
        location8001.setY(3);
        Node label8002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(8002));
        label8002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location8002 = (Location)label8002.getLayoutConstraint();
        location8002.setX(25);
        location8002.setY(-10);
        return node;
    }

    public Node createPseudostate_9000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(9000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node label9001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(9001));
        label9001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location9001 = (Location)label9001.getLayoutConstraint();
        location9001.setX(25);
        location9001.setY(3);
        Node label9002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(9002));
        label9002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location9002 = (Location)label9002.getLayoutConstraint();
        location9002.setX(25);
        location9002.setY(-10);
        return node;
    }

    public Node createPseudostate_10000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(10000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node label10001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(10001));
        label10001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location10001 = (Location)label10001.getLayoutConstraint();
        location10001.setX(25);
        location10001.setY(3);
        Node label10002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(10002));
        label10002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location10002 = (Location)label10002.getLayoutConstraint();
        location10002.setX(25);
        location10002.setY(-10);
        return node;
    }

    public Node createPseudostate_11000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(11000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node label11001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(11001));
        label11001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location11001 = (Location)label11001.getLayoutConstraint();
        location11001.setX(25);
        location11001.setY(3);
        Node label11002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(11002));
        label11002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location11002 = (Location)label11002.getLayoutConstraint();
        location11002.setX(25);
        location11002.setY(-10);
        return node;
    }

    public Node createPseudostate_12000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(12000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node label12001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(12001));
        label12001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location12001 = (Location)label12001.getLayoutConstraint();
        location12001.setX(25);
        location12001.setY(3);
        Node label12002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(12002));
        label12002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location12002 = (Location)label12002.getLayoutConstraint();
        location12002.setX(25);
        location12002.setY(-10);
        return node;
    }

    public Node createPseudostate_13000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(13000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node label13001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(13001));
        label13001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location13001 = (Location)label13001.getLayoutConstraint();
        location13001.setX(25);
        location13001.setY(3);
        Node label13002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(13002));
        label13002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location13002 = (Location)label13002.getLayoutConstraint();
        location13002.setX(25);
        location13002.setY(-10);
        return node;
    }

    public Node createPseudostate_14000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(14000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node label14001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(14001));
        label14001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location14001 = (Location)label14001.getLayoutConstraint();
        location14001.setX(25);
        location14001.setY(3);
        Node label14002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(14002));
        label14002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location14002 = (Location)label14002.getLayoutConstraint();
        location14002.setX(25);
        location14002.setY(-10);
        return node;
    }

    public Node createPseudostate_15000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(15000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node label15001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(15001));
        label15001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location15001 = (Location)label15001.getLayoutConstraint();
        location15001.setX(25);
        location15001.setY(3);
        Node label15002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(15002));
        label15002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location15002 = (Location)label15002.getLayoutConstraint();
        location15002.setX(25);
        location15002.setY(-10);
        return node;
    }

    public Node createPseudostate_16000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(16000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node label16001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(16001));
        label16001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location16001 = (Location)label16001.getLayoutConstraint();
        location16001.setX(25);
        location16001.setY(3);
        Node label16002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(16002));
        label16002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location16002 = (Location)label16002.getLayoutConstraint();
        location16002.setX(25);
        location16002.setY(-10);
        return node;
    }

    public Node createPseudostate_17000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(17000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node label17001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(17001));
        label17001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location17001 = (Location)label17001.getLayoutConstraint();
        location17001.setX(25);
        location17001.setY(3);
        Node label17002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(17002));
        label17002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location17002 = (Location)label17002.getLayoutConstraint();
        location17002.setX(25);
        location17002.setY(-10);
        return node;
    }

    public Node createConnectionPointReference_18000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(18000));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ConnectionPointReference");
        Node label18001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(18001));
        label18001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location18001 = (Location)label18001.getLayoutConstraint();
        location18001.setX(25);
        location18001.setY(3);
        Node label18002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(18002));
        label18002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location18002 = (Location)label18002.getLayoutConstraint();
        location18002.setX(25);
        location18002.setY(-10);
        return node;
    }

    public Node createComment_666(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createHintedDiagramLinkStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(666));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Comment");
        Node label6666 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6666));
        return node;
    }

    public Node createConstraint_668(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(668));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Constraint");
        Node label6668 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6668));
        Node label6669 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6669));
        return node;
    }

    public Node createTransition_680(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType(680));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InternalTransition");
        return node;
    }

    public Node createBehavior_690(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType(690));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"EntryStateBehavior");
        return node;
    }

    public Node createBehavior_691(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType(691));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DoActivityStateBehavior");
        return node;
    }

    public Node createBehavior_692(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType(692));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ExitStateBehavior");
        return node;
    }

    public Edge createTransition_7000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(7000));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Transition");
        Node label7001 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(7001));
        label7001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Node label7002 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(7002));
        label7002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Node label7003 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(7003));
        label7003.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location7003 = (Location)label7003.getLayoutConstraint();
        location7003.setX(0);
        location7003.setY(60);
        return edge;
    }

    public Edge createGeneralization_19000(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(19000));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Generalization");
        Node label19002 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(19002));
        label19002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location19002 = (Location)label19002.getLayoutConstraint();
        location19002.setX(0);
        location19002.setY(40);
        return edge;
    }

    public Edge createCommentAnnotatedElement_667(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(667));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return edge;
    }

    public Edge createConstraintConstrainedElement_670(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(670));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return edge;
    }

    public Edge createConstraintContext_8500(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(8500));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        Node label8501 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(8501));
        label8501.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        return edge;
    }

    protected void stampShortcut(View containerView, Node target) {
        if (!"PapyrusUMLStateMachineDiagram".equals(UMLVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"PapyrusUMLStateMachineDiagram");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    protected Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected Node createCompartment(View owner, String hint, boolean canCollapse, boolean hasTitle, boolean canSort, boolean canFilter) {
        Object rv = canCollapse ? NotationFactory.eINSTANCE.createBasicCompartment() : NotationFactory.eINSTANCE.createDecorationNode();
        rv.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        if (hasTitle) {
            TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
            rv.getStyles().add((Object)ts);
        }
        if (canSort) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createSortingStyle());
        }
        if (canFilter) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createFilteringStyle());
        }
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    protected IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }

    private void initFontStyleFromPrefs(View view, IPreferenceStore store, String elementName) {
        String fontConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)1);
        String fontColorConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)2);
        FontStyle viewFontStyle = (FontStyle)view.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (viewFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)store, (String)fontConstant);
            viewFontStyle.setFontName(fontData.getName());
            viewFontStyle.setFontHeight(fontData.getHeight());
            viewFontStyle.setBold((fontData.getStyle() & 1) != 0);
            viewFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fontColorConstant);
            viewFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
    }

    private void initForegroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        String lineColorConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)3);
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)lineColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
    }

    private void initBackgroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        String fillColorConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)0);
        String gradientColorConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)4);
        String gradientPolicyConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)5);
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fillColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        FillStyle fillStyle = (FillStyle)view.getStyle(NotationPackage.Literals.FILL_STYLE);
        fillStyle.setFillColor(FigureUtilities.RGBToInteger((RGB)fillRGB).intValue());
        if (store.getBoolean(gradientPolicyConstant)) {
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(store.getString(gradientColorConstant));
            fillStyle.setGradient(gradientPreferenceConverter.getGradientData());
            fillStyle.setTransparency(gradientPreferenceConverter.getTransparency());
        }
    }
}

