/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.diagram.timing.navigator.UMLAbstractNavigatorItem;
import org.eclipse.papyrus.uml.diagram.timing.navigator.UMLNavigatorGroup;
import org.eclipse.papyrus.uml.diagram.timing.navigator.UMLNavigatorItem;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class UMLNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public UMLNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        HashMap<Resource, Boolean> map = new HashMap<Resource, Boolean>(){

            @Override
            public Boolean get(Object key) {
                if (!this.containsKey(key) && key instanceof Resource) {
                    this.put((Resource)key, Boolean.TRUE);
                }
                return (Boolean)super.get(key);
            }
        };
        this.myEditingDomain.setResourceToReadOnlyMap((Map)map);
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    void unloadAllResources() {
        for (Resource nextResource : this.myEditingDomain.getResourceSet().getResources()) {
            nextResource.unload();
        }
    }

    void asyncRefresh() {
        if (this.myViewer != null && !this.myViewer.getControl().isDisposed()) {
            this.myViewer.getControl().getDisplay().asyncExec(this.myViewerRefreshRunnable);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            ArrayList<View> topViews = new ArrayList<View>(resource.getContents().size());
            for (EObject o : resource.getContents()) {
                if (!(o instanceof View)) continue;
                topViews.add((View)o);
            }
            return result.toArray();
        }
        if (parentElement instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        UMLVisualIDRegistry.getVisualID(view);
        return EMPTY_ARRAY;
    }

    private boolean isOwnView(View view) {
        return "PapyrusUMLTimingDiagram".equals(UMLVisualIDRegistry.getModelID(view));
    }

    public Object getParent(Object element) {
        if (element instanceof UMLAbstractNavigatorItem) {
            UMLAbstractNavigatorItem abstractNavigatorItem = (UMLAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

