/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.stereotypes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.tools.util.UIUtil;
import org.eclipse.papyrus.uml.modelrepair.service.IStereotypeRepairService;
import org.eclipse.swt.widgets.Display;

public class StereotypeRepairService
implements IStereotypeRepairService,
IService {
    private static final Lock lock = new ReentrantLock();
    private static final Condition finishedRepairCond = lock.newCondition();
    private static final Map<ModelSet, Set<Resource>> modelSetsInRepair = Maps.newIdentityHashMap();
    private static final Set<PostRepairExecutor> pending = Sets.newLinkedHashSet();
    private static ExecutorService pendingExecutor;
    private ServicesRegistry registry;
    private ModelSet modelSet;
    private ExecutorService executor;

    public boolean isRepairing() {
        return StereotypeRepairService.isInRepair(this.modelSet);
    }

    public ExecutorService getPostRepairExecutor() {
        return this.executor;
    }

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
        this.modelSet = (ModelSet)this.registry.getService(ModelSet.class);
        this.executor = new PostRepairExecutor(UIUtil.createUIExecutor((Display)Display.getDefault()));
    }

    public void disposeService() throws ServiceException {
        this.modelSet = null;
        this.registry = null;
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    static boolean isInRepair(ModelSet modelSet) {
        lock.lock();
        try {
            boolean bl = modelSetsInRepair.containsKey(modelSet);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    static void startedRepairing(ModelSet modelSet, Resource resource) {
        lock.lock();
        try {
            Set resources = modelSetsInRepair.get(modelSet);
            if (resources == null) {
                resources = Sets.newIdentityHashSet();
                modelSetsInRepair.put(modelSet, resources);
            }
            resources.add(resource);
        }
        finally {
            lock.unlock();
        }
    }

    static void finishedRepairing(ModelSet modelSet, Resource resource) {
        lock.lock();
        try {
            Set<Resource> resources = modelSetsInRepair.get(modelSet);
            if (resources != null) {
                resources.remove(resource);
                if (resources.isEmpty()) {
                    modelSetsInRepair.remove(modelSet);
                    finishedRepairCond.signalAll();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void pending(PostRepairExecutor executor) {
        lock.lock();
        try {
            pending.add(executor);
            if (pendingExecutor == null) {
                pendingExecutor = Executors.newSingleThreadExecutor();
                StereotypeRepairService.start(pendingExecutor);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void start(final ExecutorService executor) {
        lock.lock();
        try {
            executor.execute(new Runnable(){

                public void run() {
                    lock.lock();
                    try {
                        try {
                            finishedRepairCond.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Iterator iter = pending.iterator();
                        while (iter.hasNext()) {
                            if (!((PostRepairExecutor)iter.next()).processPending()) continue;
                            iter.remove();
                        }
                        executor.execute(this);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            });
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PostRepairExecutor
    extends AbstractExecutorService {
        private final ExecutorService delegate;
        private volatile boolean shutdown;
        private final Lock lock = new ReentrantLock();
        private List<Runnable> pending = Lists.newLinkedList();

        protected PostRepairExecutor(ExecutorService delegate) {
            this.delegate = delegate;
        }

        @Override
        public void execute(Runnable command) {
            if (this.shutdown) {
                throw new RejectedExecutionException("Executor is shut down");
            }
            if (!StereotypeRepairService.isInRepair(StereotypeRepairService.this.modelSet)) {
                try {
                    this.delegate.execute(command);
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            } else {
                this.lock.lock();
                try {
                    this.pending.add(command);
                    StereotypeRepairService.pending(this);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        @Override
        public void shutdown() {
            this.shutdown = true;
            this.delegate.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.shutdown = true;
            ArrayList result = Lists.newArrayList();
            this.lock.lock();
            try {
                result.addAll(this.pending);
                this.pending.clear();
            }
            finally {
                this.lock.unlock();
            }
            result.addAll(this.delegate.shutdownNow());
            return result;
        }

        @Override
        public boolean isShutdown() {
            return this.shutdown;
        }

        @Override
        public boolean isTerminated() {
            return this.shutdown && this.delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        boolean processPending() {
            boolean result;
            boolean bl = result = !StereotypeRepairService.isInRepair(StereotypeRepairService.this.modelSet);
            if (result) {
                this.lock.lock();
                try {
                    try {
                        for (Runnable next : this.pending) {
                            this.delegate.execute(next);
                        }
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                    this.pending.clear();
                }
                finally {
                    this.lock.unlock();
                }
            }
            return result;
        }
    }
}

