/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.menu.util;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.INattableModelManagerUtils;
import org.eclipse.papyrus.uml.nattable.menu.messages.Messages;
import org.eclipse.papyrus.uml.service.types.utils.CommandContext;
import org.eclipse.papyrus.uml.service.types.utils.ICommandContext;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class TableMenuUtils {
    public static ICommandContext getTableCommandContext(INattableModelManager tableManager) {
        INattableModelManager manager = tableManager;
        if (manager != null) {
            EObject container = manager.getTable().getContext();
            CommandContext context = null;
            if (container != null) {
                context = new CommandContext(container);
            }
            return context;
        }
        return null;
    }

    public static Command buildNattableCreationCommand(Command createCmd, final CreateElementRequest createElementRequest) {
        final INattableModelManager nattableModelManager = INattableModelManagerUtils.getTableManagerFromWorkbenchPart((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
        if (nattableModelManager != null) {
            CompositeCommand cmd = new CompositeCommand("");
            cmd.add((IUndoableOperation)new EMFtoGMFCommandWrapper(createCmd));
            cmd.add((IUndoableOperation)new AbstractTransactionalCommand(createElementRequest.getEditingDomain(), Messages.AbstractNattableCreateCommandHandler_AddElementCommand, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    EObject newElement = createElementRequest.getNewElement();
                    ArrayList<EObject> toAdd = new ArrayList<EObject>();
                    toAdd.add(newElement);
                    Command tmp = nattableModelManager.getAddRowElementCommand(toAdd);
                    if (tmp != null) {
                        tmp.execute();
                    }
                    return CommandResult.newOKCommandResult();
                }
            });
            return new GMFtoEMFCommandWrapper((ICommand)cmd);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

