/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.config;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.DataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.gui.AbstractDialogCellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.papyrus.infra.emf.nattable.celleditor.config.EStructuralFeatureEditorConfig;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.uml.nattable.dataprovider.UMLStereotypeSingleEnumerationComboBoxDataProvider;
import org.eclipse.papyrus.uml.nattable.editor.MultiBooleanCellEditor;
import org.eclipse.papyrus.uml.nattable.editor.MultiEnumCellEditor;
import org.eclipse.papyrus.uml.nattable.editor.MultiIntegerCellEditor;
import org.eclipse.papyrus.uml.nattable.editor.MultiRealCellEditor;
import org.eclipse.papyrus.uml.nattable.editor.MultiReferenceCellEditor;
import org.eclipse.papyrus.uml.nattable.editor.MultiStringCellEditor;
import org.eclipse.papyrus.uml.nattable.editor.MultiUnlimitedNaturalCellEditor;
import org.eclipse.papyrus.uml.nattable.editor.SingleReferenceValueCellEditor;
import org.eclipse.papyrus.uml.nattable.editor.StereotypeApplierDialogCellEditorWrapper;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrus.uml.nattable.validator.RealDataValidator;
import org.eclipse.papyrus.uml.nattable.validator.UnlimitedNaturalDataValidator;
import org.eclipse.uml2.types.TypesPackage;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLFeatureCellEditorConfig
extends EStructuralFeatureEditorConfig {
    public static final String EDITOR_CONFIG_ID = "UML_EDITOR_CONFIG";
    public static final int SINGLE_REAL = 100;
    public static final int MULTI_REAL = 101;
    public static final int SINGLE_UNLIMITED_NATURAL = 102;
    public static final int MULTI_UNLIMITED_NATURAL = 103;
    public static final int SINGLE_UML_ENUMERATION = 104;
    public static final int MULTI_UML_ENUMERATION = 105;
    public static final int SINGLE_UML_REFERENCE = 106;
    public static final int MULTI_UML_REFERENCE = 107;

    public boolean handles(Table table, Object axisElement) {
        boolean result = false;
        String id = AxisUtils.getPropertyId((Object)axisElement);
        if (id != null) {
            result = id.startsWith("property_of_stereotype:/");
        }
        if (!result && (result = super.handles(table, axisElement))) {
            EStructuralFeature feature = (EStructuralFeature)axisElement;
            EObject featureContainer = feature.eContainer();
            result = UMLPackage.eINSTANCE.eContents().contains((Object)featureContainer);
        }
        return result;
    }

    public ICellEditor getICellEditor(Table table, Object axisElement, ITableAxisElementProvider elementProvider) {
        int editorKind = this.getFeatureIdentifier(table, axisElement);
        Object editor = null;
        switch (editorKind) {
            case 100: 
            case 102: {
                editor = new TextCellEditor();
                break;
            }
            case 106: {
                editor = new SingleReferenceValueCellEditor(axisElement, elementProvider);
                break;
            }
            case 104: {
                editor = new ComboBoxCellEditor(this.getComboDataProvider(table, axisElement, elementProvider));
                break;
            }
            case 2: {
                editor = new MultiBooleanCellEditor(axisElement, elementProvider);
                break;
            }
            case 103: {
                editor = new MultiUnlimitedNaturalCellEditor(axisElement, elementProvider);
                break;
            }
            case 6: {
                editor = new MultiIntegerCellEditor(axisElement, elementProvider);
                break;
            }
            case 101: {
                editor = new MultiRealCellEditor(axisElement, elementProvider);
                break;
            }
            case 4: {
                editor = new MultiStringCellEditor(axisElement, elementProvider);
                break;
            }
            case 107: {
                editor = new MultiReferenceCellEditor(axisElement, elementProvider);
                break;
            }
            case 8: {
                editor = new MultiEnumCellEditor(axisElement, elementProvider);
                break;
            }
            case 105: {
                editor = new MultiEnumCellEditor(axisElement, elementProvider);
                break;
            }
            default: {
                editor = super.getICellEditor(table, axisElement, elementProvider);
            }
        }
        if (editor instanceof AbstractDialogCellEditor) {
            editor = new StereotypeApplierDialogCellEditorWrapper((AbstractDialogCellEditor)editor, axisElement, elementProvider);
        }
        return editor;
    }

    protected IComboBoxDataProvider getComboDataProvider(Table table, Object axisElement, ITableAxisElementProvider elementProvider) {
        UMLStereotypeSingleEnumerationComboBoxDataProvider comboDataProvider = null;
        String id = axisElement instanceof IdAxis ? ((IdAxis)axisElement).getElement() : (axisElement instanceof String ? (String)axisElement : null);
        if (id != null) {
            comboDataProvider = new UMLStereotypeSingleEnumerationComboBoxDataProvider(axisElement, elementProvider);
        }
        if (comboDataProvider == null) {
            comboDataProvider = super.getComboDataProvider(table, axisElement, elementProvider);
        }
        return comboDataProvider;
    }

    protected int getFeatureIdentifier(Table table, Object axisElement) {
        int editorKind = -1;
        if (axisElement instanceof IAxis) {
            editorKind = this.getIAxisFeatureIdentifier(table, (IAxis)axisElement);
        } else if (axisElement instanceof String) {
            String id = (String)axisElement;
            if (id.startsWith("property_of_stereotype:/")) {
                editorKind = this.getStereotypeAxisFeatureIdentifier(table, id);
            }
        } else if (axisElement instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)axisElement;
            EClassifier etype = feature.getEType();
            boolean isMany = feature.isMany();
            if (etype == TypesPackage.eINSTANCE.getString()) {
                editorKind = isMany ? 4 : 3;
            } else if (etype == TypesPackage.eINSTANCE.getBoolean()) {
                editorKind = isMany ? 2 : 1;
            } else if (etype == TypesPackage.eINSTANCE.getReal()) {
                editorKind = isMany ? 101 : 100;
            } else if (etype == TypesPackage.eINSTANCE.getUnlimitedNatural()) {
                editorKind = isMany ? 103 : 102;
            } else if (etype == TypesPackage.eINSTANCE.getInteger()) {
                editorKind = isMany ? 6 : 5;
            } else if (EMFHelper.isSuperType((EClassifier)UMLPackage.eINSTANCE.getElement(), (EClassifier)etype)) {
                editorKind = isMany ? 107 : 106;
            }
            if (editorKind == -1) {
                editorKind = super.getFeatureIdentifier(table, axisElement);
            }
        }
        return editorKind;
    }

    protected int getIAxisFeatureIdentifier(Table table, IAxis axis) {
        String id;
        int editorKind = -1;
        if (axis instanceof IdAxis && (id = ((IdAxis)axis).getElement()).startsWith("property_of_stereotype:/")) {
            editorKind = this.getStereotypeAxisFeatureIdentifier(table, id);
        }
        return editorKind;
    }

    protected int getStereotypeAxisFeatureIdentifier(Table table, String id) {
        Property prop;
        int editorKind = -1;
        if (id.startsWith("property_of_stereotype:/") && (prop = UMLTableUtils.getRealStereotypeProperty(table.getContext(), id)) != null && prop.getType() != null) {
            boolean isMany = prop.isMultivalued();
            Type type = prop.getType();
            if (type instanceof DataType) {
                if (type instanceof PrimitiveType) {
                    String name = type.getName();
                    editorKind = "Boolean".equals(name) ? (isMany ? 2 : 1) : ("Integer".equals(name) ? (isMany ? 6 : 5) : ("Real".equals(name) ? (isMany ? 101 : 100) : ("String".equals(name) ? (isMany ? 4 : 3) : ("UnlimitedNatural".equals(name) ? (isMany ? 103 : 102) : (isMany ? 4 : 3)))));
                } else if (type instanceof Enumeration) {
                    editorKind = isMany ? 105 : 104;
                }
            } else if (type instanceof Element) {
                editorKind = isMany ? 107 : 106;
            }
        }
        return editorKind;
    }

    public ICellPainter getCellPainter(Table table, Object axisElement) {
        int editorKind = this.getFeatureIdentifier(table, axisElement);
        TextPainter painter = null;
        switch (editorKind) {
            case 100: 
            case 102: {
                painter = new TextPainter();
                break;
            }
            default: {
                painter = super.getCellPainter(table, axisElement);
            }
        }
        return painter;
    }

    public IDisplayConverter getDisplayConvert(Table table, Object axisElement, final ILabelProvider provider) {
        int editorKind = this.getFeatureIdentifier(table, axisElement);
        Object converter = null;
        switch (editorKind) {
            case 100: {
                converter = new DefaultDoubleDisplayConverter();
                break;
            }
            case 106: {
                converter = new DisplayConverter(){

                    public Object displayToCanonicalValue(Object displayValue) {
                        return null;
                    }

                    public Object canonicalToDisplayValue(Object canonicalValue) {
                        if (canonicalValue instanceof DynamicEObjectImpl) {
                            EStructuralFeature feature = ((DynamicEObjectImpl)canonicalValue).eClass().getEStructuralFeature("base_Class");
                            return provider.getText(((DynamicEObjectImpl)canonicalValue).eGet(feature));
                        }
                        return provider.getText(canonicalValue);
                    }
                };
                break;
            }
            case 107: {
                converter = new DefaultDisplayConverter(){

                    public Object displayToCanonicalValue(ILayerCell cell, IConfigRegistry configRegistry, Object displayValue) {
                        return displayValue;
                    }
                };
                break;
            }
            case 102: {
                converter = new DefaultDisplayConverter(){

                    public Object canonicalToDisplayValue(Object sourceValue) {
                        if (sourceValue.equals(new Integer(-1))) {
                            return "*";
                        }
                        return sourceValue;
                    }

                    public Object displayToCanonicalValue(Object destinationValue) {
                        if (destinationValue.equals("*")) {
                            return new Integer(-1);
                        }
                        return new Integer((String)destinationValue);
                    }
                };
                break;
            }
            default: {
                converter = super.getDisplayConvert(table, axisElement, provider);
            }
        }
        return converter;
    }

    public IDataValidator getDataValidator(Table table, Object axisElement) {
        int editorKind = this.getFeatureIdentifier(table, axisElement);
        DataValidator converter = null;
        switch (editorKind) {
            case 100: {
                converter = new RealDataValidator();
                break;
            }
            case 102: {
                converter = new UnlimitedNaturalDataValidator();
                break;
            }
            default: {
                converter = super.getDataValidator(table, axisElement);
            }
        }
        return converter;
    }

    public String getEditorConfigId() {
        return EDITOR_CONFIG_ID;
    }
}

