/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.creation;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.properties.creation.EcorePropertyEditorFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageValueSpecificationFactory
extends EcorePropertyEditorFactory {
    protected Message parent;
    protected boolean restrictedInstantiation = false;
    protected Set<ParameterDirectionKind> directions;

    public MessageValueSpecificationFactory(EReference reference, Message parent, Set<ParameterDirectionKind> directions) {
        super(reference);
        this.parent = parent;
        this.directions = directions;
    }

    protected List<EClass> getAvailableEClasses() {
        List allClasses = EMFHelper.getSubclassesOf((EClass)this.type, (boolean)true);
        LinkedList<EClass> result = new LinkedList<EClass>();
        for (EClass eClass : allClasses) {
            if (!this.isValid(eClass)) continue;
            result.add(eClass);
        }
        return result;
    }

    protected Object doCreateObject(Control widget, Object context) {
        Parameter parameter;
        EClass eClass = this.chooseEClass(widget);
        if (eClass == null) {
            return null;
        }
        EObject instance = eClass.getEPackage().getEFactoryInstance().create(eClass);
        if (instance != null && instance instanceof NamedElement && (parameter = this.getParameter()) != null) {
            ((NamedElement)instance).setName(parameter.getName());
            if (instance instanceof InstanceValue) {
                ((InstanceValue)instance).setType(parameter.getType());
            }
        }
        return this.createObject(widget, context, instance);
    }

    protected boolean isValid(EClass eClass) {
        Parameter parameter = this.getParameter();
        if (parameter == null) {
            return !this.restrictedInstantiation;
        }
        Type parameterType = parameter.getType();
        if (parameterType instanceof PrimitiveType) {
            return this.isValidType(eClass, (PrimitiveType)parameterType);
        }
        if (parameterType instanceof Classifier) {
            return eClass == UMLPackage.eINSTANCE.getInstanceValue();
        }
        return !this.restrictedInstantiation;
    }

    protected Operation getOperation() {
        NamedElement namedElement = this.parent.getSignature();
        if (namedElement instanceof Operation) {
            return (Operation)namedElement;
        }
        return null;
    }

    protected Parameter getParameter() {
        Operation operation = this.getOperation();
        if (operation == null) {
            return null;
        }
        int index = this.parent.getArguments().size();
        int i = 0;
        for (Parameter parameter : operation.getOwnedParameters()) {
            ParameterDirectionKind direction = parameter.getDirection();
            if (!this.directions.contains(direction) || i++ != index) continue;
            return parameter;
        }
        return null;
    }

    protected boolean isValidType(EClass eClass, PrimitiveType parameterType) {
        String typeName = parameterType.getName();
        if (eClass == UMLPackage.eINSTANCE.getLiteralInteger() || eClass == UMLPackage.eINSTANCE.getLiteralUnlimitedNatural()) {
            return typeName.equals("Integer") || typeName.equals("int");
        }
        if (eClass == UMLPackage.eINSTANCE.getLiteralString()) {
            return !typeName.equals("Integer") && !typeName.equals("int") && !typeName.equals("Boolean") && !typeName.equals("boolean");
        }
        if (eClass == UMLPackage.eINSTANCE.getInstanceValue()) {
            return !typeName.equals("Integer") && !typeName.equals("int") && !typeName.equals("Boolean") && !typeName.equals("boolean") && !typeName.equals("String");
        }
        if (eClass == UMLPackage.eINSTANCE.getLiteralBoolean()) {
            return typeName.equals("Boolean") || typeName.equals("boolean");
        }
        return false;
    }
}

