/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.pages;

import com.google.inject.Injector;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.context.EObjectContext;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerListener;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.console.xtfo.EmbeddedXtextEditor;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.internal.EssentialOCLActivator;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.model.BaseDocument;
import org.eclipse.ocl.examples.xtext.essentialocl.utilities.EssentialOCLCSResource;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.CheckBoxFilteredTree;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.actions.ReplaceAction;
import org.eclipse.papyrus.uml.search.ui.pages.PapyrusSearchResultPage;
import org.eclipse.papyrus.uml.search.ui.providers.OCLContextContentProvider;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeAttribute;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeContentProvider;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeElement;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeLabelProvider;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.query.CompositePapyrusQueryProvider;
import org.eclipse.papyrus.uml.search.ui.query.PapyrusOCLQuery;
import org.eclipse.papyrus.uml.search.ui.query.QueryInfo;
import org.eclipse.papyrus.uml.search.ui.query.WorkspaceQueryProvider;
import org.eclipse.papyrus.uml.stereotypecollector.StereotypeCollector;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.views.search.regex.PatternHelper;
import org.eclipse.papyrus.views.search.scope.ScopeCollector;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.EStructuralFeatureNode;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusSearchPage
extends DialogPage
implements ISearchPage,
IReplacePage,
MetaModelManagerListener {
    private HashMap<ParticipantTypeElement, List<ParticipantTypeAttribute>> participantsList = new HashMap();
    private Collection<Stereotype> availableStereotypes;
    private static final String REGULAR_EXPRESSION_ILLFORMED = Messages.PapyrusSearchPage_0;
    private static final String OCL_QUERY_ILLFORMED = Messages.PapyrusSearchPage_0;
    private static final String SEARCH_ISSUE = Messages.PapyrusSearchPage_1;
    private Text searchQueryText;
    private Text oclContext;
    private ISearchPageContainer container;
    private CheckBoxFilteredTree participantTypesTree;
    private CheckboxTreeViewer participantTypesTreeViewer;
    private Label searchQueryExplanatoryLabel;
    private Button btnRegularExpression;
    private Button btnCaseSensitive;
    private Button btnSearchAllStringAttributes;
    private Button btnSearchInName;
    private Combo queryKind;
    private Combo searchKind;
    private EmbeddedXtextEditor oclEditor;
    private Composite queryComposite;
    private EObject contextObject;
    private static final int TEXT_QUERY_KIND = 0;
    private static final int SIMPLE_SEARCH = 0;
    private static final int ADVANCED_SEARCH = 1;
    private ParserContext parserContext;
    private MetaModelManager nullMetaModelManager = null;
    private DomainModelManager modelManager = null;
    protected Composite textQueryComposite;
    private Composite advancedSearchComposite;
    private Composite textQueryFieldsComposite;
    private Button fBtnSearchForAllSelected;

    protected void createSimpleSearchQueryField() {
        this.textQueryComposite = new Composite(this.queryComposite, 0);
        this.textQueryComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.textQueryComposite.setLayout((Layout)new GridLayout(2, false));
        this.textQueryFieldsComposite = new Composite(this.textQueryComposite, 0);
        this.textQueryFieldsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textQueryFieldsComposite.setLayout((Layout)new GridLayout(1, false));
        this.searchQueryText = new Text(this.textQueryFieldsComposite, 2048);
        this.searchQueryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.searchQueryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PapyrusSearchPage.this.validateRegex();
            }
        });
        this.searchQueryText.setFocus();
        this.searchQueryExplanatoryLabel = new Label(this.textQueryFieldsComposite, 0);
        this.searchQueryExplanatoryLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Composite compositeParameters = new Composite(this.textQueryComposite, 0);
        compositeParameters.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        compositeParameters.setLayout((Layout)new GridLayout(1, false));
        this.btnCaseSensitive = new Button(compositeParameters, 32);
        this.btnCaseSensitive.setText(Messages.PapyrusSearchPage_5);
        this.btnRegularExpression = new Button(compositeParameters, 32);
        this.btnRegularExpression.setText(Messages.PapyrusSearchPage_6);
        this.btnRegularExpression.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PapyrusSearchPage.this.btnCaseSensitive.setEnabled(!PapyrusSearchPage.this.btnRegularExpression.getSelection());
                PapyrusSearchPage.this.validateRegex();
                PapyrusSearchPage.this.searchQueryText.forceFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group grpSearchFor = new Group(this.textQueryComposite, 0);
        grpSearchFor.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        grpSearchFor.setLayout((Layout)new GridLayout(1, false));
        grpSearchFor.setText(Messages.PapyrusSearchPage_8);
        Composite groupComposite = new Composite((Composite)grpSearchFor, 0);
        groupComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        groupComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblSearchKind = new Label(groupComposite, 0);
        lblSearchKind.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        lblSearchKind.setText(Messages.PapyrusSearchPage_7);
        this.searchKind = new Combo(groupComposite, 2572);
        this.searchKind.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.searchKind.add(Messages.PapyrusSearchPage_11);
        this.searchKind.add(Messages.PapyrusSearchPage_12);
        this.searchKind.select(0);
        this.searchKind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control[] controlArray = PapyrusSearchPage.this.advancedSearchComposite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control childControl = controlArray[n2];
                    childControl.dispose();
                    ++n2;
                }
                if (PapyrusSearchPage.this.searchKind.getSelectionIndex() == 1) {
                    PapyrusSearchPage.this.participantsList.clear();
                    PapyrusSearchPage.this.createResultList();
                    PapyrusSearchPage.this.createAdvancedSearch();
                } else {
                    PapyrusSearchPage.this.simpleSearch();
                }
                PapyrusSearchPage.this.advancedSearchComposite.layout();
            }
        });
        this.advancedSearchComposite = new Composite(groupComposite, 0);
        this.advancedSearchComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.advancedSearchComposite.setLayout((Layout)new GridLayout(2, false));
        this.simpleSearch();
    }

    protected void createResultList() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress computeAvailableTypes = new IRunnableWithProgress(){

            public void run(IProgressMonitor thePM) throws InterruptedException {
                ParticipantTypeAttribute attribute;
                ArrayList<ParticipantTypeAttribute> attributeList;
                ParticipantTypeElement parentElement;
                for (EClassifier eClassifier : UMLPackage.eINSTANCE.getEClassifiers()) {
                    if (!(eClassifier instanceof EClass) || !((parentElement = new ParticipantTypeElement((EObject)eClassifier)).getElement() instanceof EClass)) continue;
                    attributeList = new ArrayList<ParticipantTypeAttribute>();
                    for (EObject eAttribute : ((EClass)parentElement.getElement()).getEAllAttributes()) {
                        attribute = new ParticipantTypeAttribute(eAttribute, parentElement);
                        attributeList.add(attribute);
                    }
                    PapyrusSearchPage.this.participantsList.put(parentElement, attributeList);
                }
                PapyrusSearchPage.this.availableStereotypes = StereotypeCollector.getInstance().computeAvailableStereotypes(PapyrusSearchPage.this.container);
                for (Stereotype stereotype : PapyrusSearchPage.this.availableStereotypes) {
                    parentElement = new ParticipantTypeElement((EObject)stereotype);
                    attributeList = new ArrayList();
                    for (Property property : ((Stereotype)parentElement.getElement()).getAllAttributes()) {
                        if (property.getName().startsWith("base_") || !(property.getType() instanceof Element) || !UMLUtil.isBoolean((Type)property.getType()) && !UMLUtil.isString((Type)property.getType()) && !UMLUtil.isInteger((Type)property.getType()) && !UMLUtil.isReal((Type)property.getType()) && !UMLUtil.isUnlimitedNatural((Type)property.getType()) && !(property.getType() instanceof Enumeration)) continue;
                        attribute = new ParticipantTypeAttribute((EObject)property, parentElement);
                        attributeList.add(attribute);
                    }
                    PapyrusSearchPage.this.participantsList.put(parentElement, attributeList);
                }
            }
        };
        try {
            dialog.run(true, true, computeAvailableTypes);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    protected void createAdvancedSearch() {
        this.participantTypesTree = new CheckBoxFilteredTree(this.advancedSearchComposite, 2820, new PatternFilter(), true);
        this.participantTypesTree.setLayout((Layout)new GridLayout());
        GridData chechboxTreeViewerGridData = new GridData(4, 4, true, true, 1, 1);
        chechboxTreeViewerGridData.heightHint = 150;
        this.participantTypesTree.setLayoutData(chechboxTreeViewerGridData);
        this.participantTypesTreeViewer = (CheckboxTreeViewer)this.participantTypesTree.getViewer();
        this.participantTypesTreeViewer.setContentProvider((IContentProvider)new ParticipantTypeContentProvider());
        this.participantTypesTreeViewer.setLabelProvider((IBaseLabelProvider)new ParticipantTypeLabelProvider());
        this.participantTypesTreeViewer.setSorter(new ViewerSorter());
        this.participantTypesTreeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof ParticipantTypeElement) {
                    return ((ParticipantTypeElement)element).isChecked();
                }
                return false;
            }
        });
        Composite participantManipualtionComposite = new Composite(this.advancedSearchComposite, 0);
        participantManipualtionComposite.setLayout((Layout)new GridLayout(1, false));
        participantManipualtionComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 1, 1));
        Button btnSelectSub = new Button(participantManipualtionComposite, 8);
        btnSelectSub.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnSelectSub.setText(Messages.PapyrusSearchPage_14);
        btnSelectSub.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object selectedElement;
                ISelection selection = PapyrusSearchPage.this.participantTypesTreeViewer.getSelection();
                if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof ParticipantTypeElement) {
                    ArrayList<ParticipantTypeAttribute> attributeParentList = new ArrayList<ParticipantTypeAttribute>();
                    for (Object attribute : (List)PapyrusSearchPage.this.participantsList.get(selectedElement)) {
                        if (!(attribute instanceof ParticipantTypeAttribute) || !((ParticipantTypeAttribute)attribute).isChecked()) continue;
                        attributeParentList.add((ParticipantTypeAttribute)attribute);
                    }
                    if (((ParticipantTypeElement)selectedElement).getElement() instanceof EClass) {
                        PapyrusSearchPage.this.selectAllSubUML((ParticipantTypeElement)selectedElement, attributeParentList);
                    } else if (((ParticipantTypeElement)selectedElement).getElement() instanceof Stereotype) {
                        PapyrusSearchPage.this.selectAllSubSter((ParticipantTypeElement)selectedElement, attributeParentList);
                    }
                }
                PapyrusSearchPage.this.participantTypesTreeViewer.refresh();
            }
        });
        Button btnSelectAll = new Button(participantManipualtionComposite, 8);
        btnSelectAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnSelectAll.setText(Messages.PapyrusSearchPage_9);
        btnSelectAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                for (ParticipantTypeElement element : PapyrusSearchPage.this.participantsList.keySet()) {
                    if (element.isChecked()) continue;
                    element.setChecked(true);
                    for (ParticipantTypeAttribute attribute : (List)PapyrusSearchPage.this.participantsList.get(element)) {
                        attribute.setChecked(true);
                    }
                }
                PapyrusSearchPage.this.participantTypesTreeViewer.refresh();
            }
        });
        Button btnDeselectAll = new Button(participantManipualtionComposite, 8);
        btnDeselectAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnDeselectAll.setText(Messages.PapyrusSearchPage_10);
        btnDeselectAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                for (ParticipantTypeElement element : PapyrusSearchPage.this.participantsList.keySet()) {
                    if (!element.isChecked()) continue;
                    element.setChecked(false);
                    for (ParticipantTypeAttribute attribute : (List)PapyrusSearchPage.this.participantsList.get(element)) {
                        attribute.setChecked(false);
                    }
                }
                PapyrusSearchPage.this.participantTypesTreeViewer.refresh();
            }
        });
        Button btnRefreshTypes = new Button(participantManipualtionComposite, 8);
        btnRefreshTypes.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnRefreshTypes.setText(Messages.PapyrusSearchPage_15);
        btnRefreshTypes.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PapyrusSearchPage.this.participantsList.clear();
                PapyrusSearchPage.this.createResultList();
                PapyrusSearchPage.this.createAdvancedSearch();
            }
        });
        this.participantTypesTreeViewer.setInput(this.participantsList);
        this.participantTypesTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof ParticipantTypeElement) {
                    if (event.getChecked()) {
                        ParticipantTypeElement parent;
                        Object selectedElement = event.getElement();
                        ((ParticipantTypeElement)selectedElement).setChecked(true);
                        PapyrusSearchPage.this.participantTypesTreeViewer.refresh(selectedElement);
                        if (selectedElement instanceof ParticipantTypeAttribute && (parent = ((ParticipantTypeAttribute)selectedElement).getParent()) != null) {
                            parent.setChecked(true);
                            PapyrusSearchPage.this.participantTypesTreeViewer.refresh((Object)parent);
                        }
                    } else {
                        Object selectedElement = event.getElement();
                        ((ParticipantTypeElement)selectedElement).setChecked(false);
                        PapyrusSearchPage.this.participantTypesTreeViewer.refresh(selectedElement);
                        if (((ParticipantTypeElement)selectedElement).getElement() instanceof Stereotype || ((ParticipantTypeElement)selectedElement).getElement() instanceof EClassImpl) {
                            Object[] objectArray = PapyrusSearchPage.this.participantTypesTreeViewer.getCheckedElements();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object attribute = objectArray[n2];
                                if (attribute instanceof ParticipantTypeAttribute && ((ParticipantTypeAttribute)attribute).getParent().equals(selectedElement)) {
                                    ((ParticipantTypeElement)attribute).setChecked(false);
                                    PapyrusSearchPage.this.participantTypesTreeViewer.refresh(attribute);
                                }
                                ++n2;
                            }
                        }
                    }
                }
            }
        });
        this.fBtnSearchForAllSelected = new Button(this.advancedSearchComposite, 32);
        this.fBtnSearchForAllSelected.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fBtnSearchForAllSelected.setText(Messages.PapyrusSearchPage_13);
    }

    protected void selectAllSubSter(final ParticipantTypeElement elementParent, final List<ParticipantTypeAttribute> attributeParentList) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress computeAvailableTypes = new IRunnableWithProgress(){

            public void run(IProgressMonitor thePM) throws InterruptedException {
                for (Object element : PapyrusSearchPage.this.participantsList.keySet()) {
                    if (!(element instanceof ParticipantTypeElement)) continue;
                    PapyrusSearchPage.this.checkAllSubSter((ParticipantTypeElement)element, elementParent, attributeParentList);
                }
            }
        };
        try {
            dialog.run(true, true, computeAvailableTypes);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void checkAllSubSter(ParticipantTypeElement element, ParticipantTypeElement elementParent, List<ParticipantTypeAttribute> attributeParentList) {
        EList superTypes;
        if (element.getElement() instanceof Stereotype && (superTypes = ((Class)element.getElement()).getSuperClasses()).contains(elementParent.getElement())) {
            element.setChecked(true);
            for (ParticipantTypeAttribute attributeParent : attributeParentList) {
                for (ParticipantTypeAttribute attributeToEvaluate : this.participantsList.get(element)) {
                    if (attributeParent.getElement() != attributeToEvaluate.getElement()) continue;
                    attributeToEvaluate.setChecked(true);
                }
            }
        }
    }

    protected void selectAllSubUML(final ParticipantTypeElement elementParent, final List<ParticipantTypeAttribute> attributeParentList) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress computeAvailableTypes = new IRunnableWithProgress(){

            public void run(IProgressMonitor thePM) throws InterruptedException {
                for (Object element : PapyrusSearchPage.this.participantsList.keySet()) {
                    if (!(element instanceof ParticipantTypeElement)) continue;
                    PapyrusSearchPage.this.checkAllSubUML((ParticipantTypeElement)element, elementParent, attributeParentList);
                }
            }
        };
        try {
            dialog.run(true, true, computeAvailableTypes);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    protected void checkAllSubUML(ParticipantTypeElement element, ParticipantTypeElement elementParent, List<ParticipantTypeAttribute> attributeParentList) {
        EList superTypes;
        if (element.getElement() instanceof EClass && (superTypes = ((EClass)element.getElement()).getEAllSuperTypes()).contains(elementParent.getElement())) {
            element.setChecked(true);
            for (ParticipantTypeAttribute attributeParent : attributeParentList) {
                for (ParticipantTypeAttribute attributeToEvaluate : this.participantsList.get(element)) {
                    if (attributeParent.getElement() != attributeToEvaluate.getElement()) continue;
                    attributeToEvaluate.setChecked(true);
                }
            }
        }
    }

    protected void simpleSearch() {
        Composite participantManipualtionComposite = new Composite(this.advancedSearchComposite, 0);
        participantManipualtionComposite.setLayout((Layout)new GridLayout(1, false));
        participantManipualtionComposite.setLayoutData((Object)new GridData(4, 128, false, true, 1, 1));
        this.btnSearchInName = new Button(participantManipualtionComposite, 16);
        this.btnSearchInName.setText(Messages.PapyrusSearchPage_16);
        this.btnSearchInName.setLayoutData((Object)new GridData(16384, 128, false, false, 0, 1));
        this.btnSearchInName.setSelection(true);
        this.btnSearchAllStringAttributes = new Button(participantManipualtionComposite, 16);
        this.btnSearchAllStringAttributes.setText(Messages.PapyrusSearchPage_17);
        this.btnSearchAllStringAttributes.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
    }

    public Object[] getMetaClassesList() {
        HashSet<EClassifier> umlMetaClasses = new HashSet<EClassifier>();
        for (EClassifier eClassifier : UMLPackage.eINSTANCE.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            umlMetaClasses.add(eClassifier);
        }
        return umlMetaClasses.toArray();
    }

    protected void createOCLSearchQueryField(EObject root) {
        Composite client = this.queryComposite;
        Composite oclContextComposite = new Composite(client, 0);
        oclContextComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        oclContextComposite.setLayout((Layout)new GridLayout(2, false));
        this.oclContext = new Text(oclContextComposite, 2048);
        this.oclContext.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.oclContext.setEnabled(false);
        this.oclContext.setFocus();
        Button btnSelectContext = new Button(oclContextComposite, 8);
        btnSelectContext.setText(Messages.PapyrusSearchPage_18);
        btnSelectContext.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
                ILabelProvider labelProvider = labelProviderService.getLabelProvider();
                ScopeEntry currentScope = PapyrusSearchPage.this.getCurrentScopeEntry();
                if (currentScope != null) {
                    try {
                        ((UmlModel)currentScope.getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel")).lookupRoot();
                        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), labelProvider, (ITreeContentProvider)new OCLContextContentProvider());
                        dialog.setTitle(Messages.PapyrusSearchPage_19);
                        dialog.setMessage(Messages.PapyrusSearchPage_20);
                        dialog.setInput((Object)currentScope.getModelSet());
                        dialog.setAllowMultiple(false);
                        dialog.open();
                        Object selection = dialog.getFirstResult();
                        if (selection instanceof EObject) {
                            PapyrusSearchPage.this.refreshSelection(selection);
                            if (PapyrusSearchPage.this.contextObject instanceof NamedElement) {
                                PapyrusSearchPage.this.oclContext.setText(((NamedElement)PapyrusSearchPage.this.contextObject).getQualifiedName());
                            } else {
                                PapyrusSearchPage.this.oclContext.setText(labelProvider.getText((Object)PapyrusSearchPage.this.contextObject));
                            }
                        }
                    }
                    catch (NotFoundException notFoundException) {
                        Activator.log.error(String.valueOf(Messages.PapyrusQuery_0) + currentScope.getModelSet(), (Throwable)notFoundException);
                    }
                }
            }
        });
        btnSelectContext.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Injector injector = EssentialOCLActivator.getInstance().getInjector("org.eclipse.ocl.examples.xtext.essentialocl.EssentialOCL");
        Composite editorComposite = client;
        this.oclEditor = new EmbeddedXtextEditor(editorComposite, injector, 770);
        this.oclEditor.getViewer().getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if ((e.keyCode == 0x1000050 || e.keyCode == 13) && (e.stateMask & 0x60000) == 0) {
                    e.doit = false;
                }
            }
        });
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(3);
        editorComposite.setLayoutData((Object)data);
        this.refreshSelection(root);
    }

    protected ScopeEntry getCurrentScopeEntry() {
        Collection scope;
        Collection<ScopeEntry> scopeEntries;
        if (this.container.getSelectedScope() == 1 && (scopeEntries = WorkspaceQueryProvider.createScopeEntries(scope = ScopeCollector.getInstance().computeSearchScope(this.container))).size() == 1) {
            Object[] entries = scopeEntries.toArray();
            ScopeEntry selectedResource = (ScopeEntry)entries[0];
            return selectedResource;
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite searchComposite = new Composite(parent, 0);
        searchComposite.setFont(parent.getFont());
        searchComposite.setLayout((Layout)new GridLayout(2, false));
        searchComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblSearchString = new Label(searchComposite, 0);
        lblSearchString.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        lblSearchString.setText(Messages.PapyrusSearchPage_4);
        this.queryKind = new Combo(searchComposite, 2572);
        this.queryKind.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        this.queryKind.add(Messages.PapyrusSearchPage_21);
        this.queryKind.add(Messages.PapyrusSearchPage_22);
        this.queryKind.select(0);
        this.queryKind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block12: {
                    Control[] controlArray = PapyrusSearchPage.this.queryComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control childControl = controlArray[n2];
                        childControl.dispose();
                        ++n2;
                    }
                    if (PapyrusSearchPage.this.queryKind.getSelectionIndex() == 0) {
                        PapyrusSearchPage.this.createSimpleSearchQueryField();
                    } else if (PapyrusSearchPage.this.container.getSelectedScope() == 1) {
                        ScopeEntry currentScope = PapyrusSearchPage.this.getCurrentScopeEntry();
                        if (currentScope != null) {
                            if (currentScope.getModelSet() != null) {
                                try {
                                    EObject root = ((UmlModel)currentScope.getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel")).lookupRoot();
                                    PapyrusSearchPage.this.createOCLSearchQueryField(root);
                                    if (PapyrusSearchPage.this.contextObject instanceof NamedElement) {
                                        PapyrusSearchPage.this.oclContext.setText(((NamedElement)PapyrusSearchPage.this.contextObject).getQualifiedName());
                                        break block12;
                                    }
                                    LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
                                    ILabelProvider labelProvider = labelProviderService.getLabelProvider();
                                    PapyrusSearchPage.this.oclContext.setText(labelProvider.getText((Object)PapyrusSearchPage.this.contextObject));
                                }
                                catch (NotFoundException notFoundException) {
                                    Activator.log.error(String.valueOf(Messages.PapyrusQuery_0) + currentScope.getModelSet(), (Throwable)notFoundException);
                                }
                            } else {
                                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_23, (String)Messages.PapyrusSearchPage_24);
                                PapyrusSearchPage.this.createSimpleSearchQueryField();
                                PapyrusSearchPage.this.queryKind.select(0);
                            }
                        } else {
                            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_25, (String)Messages.PapyrusSearchPage_26);
                            PapyrusSearchPage.this.createSimpleSearchQueryField();
                            PapyrusSearchPage.this.queryKind.select(0);
                        }
                    } else {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_27, (String)Messages.PapyrusSearchPage_28);
                        PapyrusSearchPage.this.createSimpleSearchQueryField();
                        PapyrusSearchPage.this.queryKind.select(0);
                    }
                }
                PapyrusSearchPage.this.queryComposite.layout();
            }
        });
        this.queryComposite = new Composite(searchComposite, 0);
        this.queryComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.queryComposite.setLayout((Layout)new GridLayout(1, false));
        this.createSimpleSearchQueryField();
        this.setControl((Control)parent);
    }

    public boolean getSearchAllStringAttributes() {
        if (this.btnSearchAllStringAttributes != null) {
            return this.btnSearchAllStringAttributes.getSelection();
        }
        return false;
    }

    private boolean validateRegex() {
        try {
            PatternHelper.getInstance().createPattern(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection());
            this.searchQueryExplanatoryLabel.setForeground(this.getControl().getForeground());
            this.searchQueryExplanatoryLabel.setText("");
            return true;
        }
        catch (PatternSyntaxException e) {
            this.searchQueryExplanatoryLabel.setForeground(Display.getDefault().getSystemColor(3));
            this.searchQueryExplanatoryLabel.setText(e.getDescription());
            return false;
        }
    }

    protected void refreshSelection(final Object selected) {
        BaseDocument editorDocument = (BaseDocument)this.oclEditor.getDocument();
        editorDocument.modify((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Value exec(XtextResource resource) throws Exception {
                Object selectedObject = selected;
                if (selectedObject instanceof IOutlineNode) {
                    if (selectedObject instanceof EObjectNode) {
                        EObjectNode selectedObjectNode = (EObjectNode)selectedObject;
                        selectedObjectNode.getEObjectURI();
                        PapyrusSearchPage.this.contextObject = null;
                    } else if (selectedObject instanceof EStructuralFeatureNode) {
                        PapyrusSearchPage.this.contextObject = null;
                    } else {
                        PapyrusSearchPage.this.contextObject = null;
                    }
                } else {
                    if (selectedObject instanceof IAdaptable) {
                        selectedObject = ((IAdaptable)selectedObject).getAdapter(EObject.class);
                    }
                    if (selectedObject instanceof EObject) {
                        PapyrusSearchPage.this.contextObject = (EObject)selectedObject;
                    } else {
                        PapyrusSearchPage.this.contextObject = null;
                    }
                }
                MetaModelManager metaModelManager = PapyrusSearchPage.this.getMetaModelManager(PapyrusSearchPage.this.contextObject);
                PapyrusSearchPage.this.parserContext = (ParserContext)new EObjectContext(metaModelManager, null, PapyrusSearchPage.this.contextObject);
                EssentialOCLCSResource csResource = (EssentialOCLCSResource)resource;
                if (csResource != null) {
                    ResourceSet resourceSet;
                    if (PapyrusSearchPage.this.contextObject != null) {
                        CS2PivotResourceAdapter.getAdapter((BaseCSResource)csResource, (MetaModelManager)metaModelManager);
                    }
                    if ((resourceSet = PapyrusSearchPage.this.oclEditor.getResourceSet()) != null) {
                        MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)resourceSet, (MetaModelManager)metaModelManager);
                    }
                    csResource.setParserContext(PapyrusSearchPage.this.parserContext);
                }
                return null;
            }
        });
    }

    private Collection<ScopeEntry> createScopeEntries(Collection<URI> scope) {
        HashSet<ScopeEntry> results = new HashSet<ScopeEntry>();
        for (URI resource : scope) {
            ScopeEntry scopeEntry = new ScopeEntry(resource);
            results.add(scopeEntry);
        }
        return results;
    }

    private List<ParticipantTypeElement> getParticipantsToEvaluate(HashMap<ParticipantTypeElement, List<ParticipantTypeAttribute>> participantsList) {
        ArrayList<ParticipantTypeElement> participantsToEvaluate = new ArrayList<ParticipantTypeElement>();
        for (ParticipantTypeElement element : participantsList.keySet()) {
            if (!element.isChecked()) continue;
            participantsToEvaluate.add(element);
            for (ParticipantTypeAttribute attributesToEvaluate : participantsList.get(element)) {
                if (!attributesToEvaluate.isChecked()) continue;
                participantsToEvaluate.add(attributesToEvaluate);
            }
        }
        return participantsToEvaluate;
    }

    public boolean performAction() {
        if (this.queryKind.getSelectionIndex() == 0) {
            if (this.validateRegex()) {
                AbstractPapyrusQuery query;
                Collection scope = ScopeCollector.getInstance().computeSearchScope(this.container);
                if (this.searchKind.getSelectionIndex() == 0) {
                    if (this.searchQueryText.getText().length() == 0) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_29, (String)Messages.PapyrusSearchPage_30);
                        return false;
                    }
                    QueryInfo info = new QueryInfo(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection(), this.btnSearchAllStringAttributes.getSelection(), scope);
                    query = CompositePapyrusQueryProvider.getInstance().createSimpleSearchQuery(info);
                } else {
                    ArrayList<ParticipantTypeElement> participantsToEvaluate = new ArrayList<ParticipantTypeElement>();
                    for (ParticipantTypeElement element : this.participantsList.keySet()) {
                        if (!element.isChecked()) continue;
                        participantsToEvaluate.add(element);
                        for (ParticipantTypeAttribute attributesToEvaluate : this.participantsList.get(element)) {
                            if (!attributesToEvaluate.isChecked()) continue;
                            participantsToEvaluate.add(attributesToEvaluate);
                        }
                    }
                    if (participantsToEvaluate.size() == 0) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_31, (String)Messages.PapyrusSearchPage_32);
                        return false;
                    }
                    if (this.searchQueryText.getText().length() == 0) {
                        Object[] objectArray = this.participantTypesTreeViewer.getCheckedElements();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object participantChecked = objectArray[n2];
                            if (participantChecked instanceof ParticipantTypeAttribute) {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_33, (String)Messages.PapyrusSearchPage_34);
                                return false;
                            }
                            ++n2;
                        }
                    }
                    QueryInfo info = new QueryInfo(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection(), participantsToEvaluate, scope, this.fBtnSearchForAllSelected.getSelection());
                    query = CompositePapyrusQueryProvider.getInstance().createAdvancedSearchQuery(info);
                }
                if (query.canRunInBackground()) {
                    NewSearchUI.runQueryInBackground((ISearchQuery)query);
                }
                return true;
            }
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SEARCH_ISSUE, (String)REGULAR_EXPRESSION_ILLFORMED);
            return false;
        }
        ScopeEntry scopeEntry = this.getCurrentScopeEntry();
        if (scopeEntry != null) {
            try {
                PivotUtil.checkResourceErrors((String)"", (Resource)this.oclEditor.getResource());
                ExpressionInOCL expressionInOCL = this.parserContext.getExpression((BaseResource)this.oclEditor.getResource());
                PapyrusOCLQuery query = new PapyrusOCLQuery((BaseDocument)this.oclEditor.getDocument(), this.parserContext, this.getMetaModelManager(this.contextObject), this.modelManager, this.contextObject, scopeEntry);
                if (query.canRunInBackground()) {
                    NewSearchUI.runQueryInBackground((ISearchQuery)query);
                }
            }
            catch (ParserException e) {
                InvalidValueException value = new InvalidValueException((Exception)((Object)e), Messages.PapyrusSearchPage_35);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SEARCH_ISSUE, (String)OCL_QUERY_ILLFORMED);
                return false;
            }
            return true;
        }
        return false;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
        this.container.setPerformActionEnabled(true);
    }

    public boolean performReplace() {
        if (this.queryKind.getSelectionIndex() == 0) {
            if (this.container.getSelectedScope() == 1) {
                if (this.validateRegex()) {
                    AbstractPapyrusQuery query;
                    if (this.searchQueryText.getText().length() == 0) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_36, (String)Messages.PapyrusSearchPage_37);
                        return false;
                    }
                    Collection scope = ScopeCollector.getInstance().computeSearchScope(this.container);
                    if (this.searchKind.getSelectionIndex() == 0) {
                        QueryInfo info = new QueryInfo(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection(), this.btnSearchAllStringAttributes.getSelection(), scope);
                        query = CompositePapyrusQueryProvider.getInstance().createSimpleSearchQuery(info);
                    } else {
                        ArrayList<ParticipantTypeElement> participantsToEvaluate = new ArrayList<ParticipantTypeElement>();
                        for (ParticipantTypeElement element : this.participantsList.keySet()) {
                            if (!element.isChecked()) continue;
                            participantsToEvaluate.add(element);
                            if (this.participantsList.get(element).size() == 0) {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_38, (String)Messages.PapyrusSearchPage_39);
                                return false;
                            }
                            for (ParticipantTypeAttribute attributesToEvaluate : this.participantsList.get(element)) {
                                Property property;
                                if (!attributesToEvaluate.isChecked()) continue;
                                participantsToEvaluate.add(attributesToEvaluate);
                                boolean canDoReplace = false;
                                if (attributesToEvaluate.getElement() instanceof EAttribute) {
                                    Object value = element.getElement().eGet((EStructuralFeature)((EAttribute)attributesToEvaluate.getElement()));
                                    if (value instanceof String) {
                                        canDoReplace = true;
                                    }
                                } else if (attributesToEvaluate.getElement() instanceof Property && UMLUtil.isString((Type)(property = (Property)attributesToEvaluate.getElement()).getType())) {
                                    canDoReplace = true;
                                }
                                if (canDoReplace) continue;
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_40, (String)Messages.PapyrusSearchPage_41);
                                return false;
                            }
                        }
                        QueryInfo info = new QueryInfo(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection(), participantsToEvaluate, scope, this.fBtnSearchForAllSelected.getSelection());
                        query = CompositePapyrusQueryProvider.getInstance().createAdvancedSearchQuery(info);
                    }
                    NewSearchUI.runQueryInForeground((IRunnableContext)this.container.getRunnableContext(), (ISearchQuery)query);
                    Display.getCurrent().syncExec(new Runnable(){

                        public void run() {
                            ISearchResultPage page;
                            ISearchResultViewPart view = NewSearchUI.activateSearchResultView();
                            if (view != null && (page = view.getActivePage()) instanceof PapyrusSearchResultPage) {
                                PapyrusSearchResultPage resultPage = (PapyrusSearchResultPage)page;
                                ReplaceAction replaceAction = new ReplaceAction(resultPage.getSite().getShell(), resultPage, null);
                                replaceAction.run();
                            }
                        }
                    });
                    NewSearchUI.removeQuery((ISearchQuery)query);
                    return true;
                }
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SEARCH_ISSUE, (String)REGULAR_EXPRESSION_ILLFORMED);
                return false;
            }
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_27, (String)Messages.PapyrusSearchPage_28);
            return false;
        }
        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_42, (String)Messages.PapyrusSearchPage_43);
        return false;
    }

    public MetaModelManager getMetaModelManager(EObject contextObject) {
        MetaModelManager metaModelManager;
        MetaModelManager metaModelManager2 = metaModelManager = contextObject != null ? PivotUtil.findMetaModelManager((EObject)contextObject) : null;
        if (metaModelManager != null) {
            return metaModelManager;
        }
        MetaModelManager nullMetaModelManager2 = this.nullMetaModelManager;
        if (nullMetaModelManager2 == null) {
            nullMetaModelManager2 = this.nullMetaModelManager = new MetaModelManager();
            nullMetaModelManager2.addListener((MetaModelManagerListener)this);
        }
        return nullMetaModelManager2;
    }

    public void metaModelManagerDisposed(MetaModelManager metaModelManager) {
        metaModelManager.removeListener((MetaModelManagerListener)this);
        this.reset();
    }

    protected void flushEvents() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        while (workbench.getDisplay().readAndDispatch()) {
        }
    }

    public void reset() {
        if (this.oclEditor != null) {
            IXtextDocument document = this.oclEditor.getDocument();
            MetaModelManager metaModelManager = (MetaModelManager)document.modify((IUnitOfWork)new IUnitOfWork<MetaModelManager, XtextResource>(){

                public MetaModelManager exec(XtextResource state) throws Exception {
                    if (state == null) {
                        return null;
                    }
                    if (state instanceof BaseResource) {
                        ((BaseResource)state).setParserContext(null);
                    }
                    return PivotUtil.findMetaModelManager((Resource)state);
                }
            });
            this.flushEvents();
            this.flushEvents();
            if (metaModelManager != null) {
                metaModelManager.dispose();
            }
        }
        if (this.modelManager != null) {
            this.modelManager = null;
        }
        if (this.nullMetaModelManager != null) {
            this.nullMetaModelManager.dispose();
            this.nullMetaModelManager = null;
        }
        this.parserContext = null;
        this.contextObject = null;
    }
}

