/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.query;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.results.PapyrusSearchResult;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositePapyrusQuery
extends AbstractPapyrusQuery {
    private final List<? extends AbstractPapyrusQuery> queries;
    private final CompositeSearchResult searchResult = new CompositeSearchResult();

    protected CompositePapyrusQuery(List<? extends AbstractPapyrusQuery> queries) {
        this.queries = queries;
    }

    public static AbstractPapyrusQuery compose(Iterable<? extends AbstractPapyrusQuery> queries) {
        switch (Iterables.size(queries)) {
            case 0: {
                return AbstractPapyrusQuery.Empty.INSTANCE;
            }
            case 1: {
                return (AbstractPapyrusQuery)Iterables.getOnlyElement(queries);
            }
        }
        return new CompositePapyrusQuery((List<? extends AbstractPapyrusQuery>)ImmutableList.copyOf(queries));
    }

    public String getLabel() {
        return this.queries.get(0).getLabel();
    }

    @Override
    public String getSearchQueryText() {
        return this.queries.get(0).getSearchQueryText();
    }

    public boolean canRerun() {
        boolean result = true;
        for (AbstractPapyrusQuery abstractPapyrusQuery : this.queries) {
            if (abstractPapyrusQuery.canRerun()) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean canRunInBackground() {
        boolean result = true;
        for (AbstractPapyrusQuery abstractPapyrusQuery : this.queries) {
            if (abstractPapyrusQuery.canRunInBackground()) continue;
            result = false;
            break;
        }
        return result;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        ArrayList<IStatus> result = new ArrayList<IStatus>(this.queries.size());
        this.searchResult.clear();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)result.size());
        for (AbstractPapyrusQuery abstractPapyrusQuery : this.queries) {
            IStatus status = abstractPapyrusQuery.run((IProgressMonitor)sub.newChild(1));
            if (!status.isOK()) {
                result.add(status);
            }
            this.searchResult.addSearchResult((AbstractTextSearchResult)abstractPapyrusQuery.getSearchResult());
        }
        return result.isEmpty() ? Status.OK_STATUS : (result.size() == 1 ? (IStatus)result.get(0) : new MultiStatus("org.eclipse.papyrus.uml.search.ui", 0, result.toArray(new IStatus[result.size()]), "Problems occurred in search.", null));
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    private final class CompositeSearchResult
    extends PapyrusSearchResult
    implements ISearchResultListener {
        private final Multimap<AbstractTextSearchResult, Match> searchResults;

        CompositeSearchResult() {
            super(CompositePapyrusQuery.this);
            this.searchResults = ArrayListMultimap.create();
        }

        void clear() {
            for (AbstractTextSearchResult next : this.searchResults.keySet()) {
                next.removeListener((ISearchResultListener)this);
            }
            this.searchResults.clear();
        }

        void addSearchResult(AbstractTextSearchResult searchResult) {
            Object[] elements = searchResult.getElements();
            int i = 0;
            while (i < elements.length) {
                Match[] matches = searchResult.getMatches(elements[i]);
                this.searchResults.putAll((Object)searchResult, Arrays.asList(matches));
                this.addMatches(matches);
                ++i;
            }
            if (!this.searchResults.containsKey((Object)searchResult)) {
                this.searchResults.putAll((Object)searchResult, Collections.emptyList());
            }
            searchResult.addListener((ISearchResultListener)this);
        }

        public void searchResultChanged(SearchResultEvent e) {
            AbstractTextSearchResult source = (AbstractTextSearchResult)e.getSearchResult();
            if (e instanceof RemoveAllEvent) {
                this.removeAll(source);
            } else if (e instanceof MatchEvent) {
                MatchEvent event = (MatchEvent)e;
                switch (event.getKind()) {
                    case 1: {
                        this.add(source, event.getMatches());
                        break;
                    }
                    case 2: {
                        this.remove(source, event.getMatches());
                        break;
                    }
                    default: {
                        Activator.log.warn("Unrecognized MatcheEvent kind: " + event.getKind());
                    }
                }
            }
        }

        private void removeAll(AbstractTextSearchResult searchResult) {
            Match[] removed = (Match[])Iterables.toArray((Iterable)this.searchResults.get((Object)searchResult), Match.class);
            this.searchResults.get((Object)searchResult).clear();
            this.removeMatches(removed);
        }

        private void remove(AbstractTextSearchResult searchResult, Match[] matches) {
            this.searchResults.get((Object)searchResult).removeAll(Arrays.asList(matches));
            this.removeMatches(matches);
        }

        private void add(AbstractTextSearchResult searchResult, Match[] matches) {
            this.searchResults.putAll((Object)searchResult, Arrays.asList(matches));
        }
    }
}

