/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.validation.oclpivot;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.helper.OCLHelper;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class AbstractOCLpivotModelConstraint
implements IModelConstraint {
    private final IConstraintDescriptor descriptor;
    private final Map<Stereotype, Reference<?>> queries = new WeakHashMap();
    private QueryManager queryManager;
    protected static OCL oclInstance = null;

    public AbstractOCLpivotModelConstraint(IConstraintDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ExpressionInOCL getConstraintCondition(EObject target) {
        ExpressionInOCL result = null;
        Stereotype umlStereotype = UMLUtil.getStereotype((EObject)target);
        if (umlStereotype == null) {
            return null;
        }
        Reference<?> reference = this.queries.get(umlStereotype);
        if (reference != null) {
            result = (ExpressionInOCL)reference.get();
        }
        if (result == null) {
            if (oclInstance == null) {
                OCL.initialize(null);
                PivotEnvironmentFactory pef = new PivotEnvironmentFactory(null, new MetaModelManager());
                oclInstance = OCL.newInstance((EnvironmentFactory)pef);
            }
            OCLHelper oclHelper = oclInstance.createOCLHelper();
            try {
                NamedElement context = (NamedElement)oclInstance.getMetaModelManager().getPivotOf(NamedElement.class, (EObject)umlStereotype);
                oclHelper.setContext((Type)context);
                String expression = this.getDescriptor().getBody();
                result = oclHelper.createQuery(expression);
            }
            catch (ParserException parserException) {
                throw new WrappedException((Exception)((Object)parserException));
            }
            this.queries.put(umlStereotype, new WeakReference<ExpressionInOCL>(result));
        }
        return result;
    }

    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        try {
            if (this.getQueryManager().check(target)) {
                return ctx.createSuccessStatus();
            }
            return ctx.createFailureStatus(new Object[]{target});
        }
        catch (Exception e) {
            String message = String.format("The '%s' constraint is invalid - %s", this.getDescriptor().getName(), e.getMessage());
            return new ConstraintStatus((IModelConstraint)this, target, 4, -1, message, null);
        }
    }

    private QueryManager getQueryManager() {
        if (this.queryManager == null) {
            this.queryManager = new QueryManager();
        }
        return this.queryManager;
    }

    public IConstraintDescriptor getDescriptor() {
        return this.descriptor;
    }

    private final class QueryManager {
        QueryManager() {
        }

        boolean check(EObject target) {
            ExpressionInOCL query = AbstractOCLpivotModelConstraint.this.getConstraintCondition(target);
            return (Boolean)oclInstance.evaluate((Object)target, query);
        }
    }
}

