/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editor.IReloadableEditor;
import org.eclipse.papyrus.infra.core.editor.reload.EditorReloadAdapter;
import org.eclipse.papyrus.infra.core.editor.reload.EditorReloadEvent;
import org.eclipse.papyrus.infra.core.editor.reload.IEditorReloadListener;
import org.eclipse.papyrus.infra.core.editor.reload.TreeViewerContext;
import org.eclipse.papyrus.infra.core.lifecycleevents.IEditorInputChangedListener;
import org.eclipse.papyrus.infra.core.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyListener;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyEvent;
import org.eclipse.papyrus.infra.core.resource.additional.AdditionalResourcesModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageLifeCycleEventsListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.providers.SemanticFromModelExplorer;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.infra.widgets.editors.SelectionMenu;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.CustomCommonViewer;
import org.eclipse.papyrus.views.modelexplorer.DecoratingLabelProviderWTooltips;
import org.eclipse.papyrus.views.modelexplorer.DirectEditorEditingSupport;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerTreeViewerContext;
import org.eclipse.papyrus.views.modelexplorer.SharedModelExplorerState;
import org.eclipse.papyrus.views.modelexplorer.listener.DoubleClickListener;
import org.eclipse.papyrus.views.modelexplorer.matching.LinkItemMatchingItem;
import org.eclipse.papyrus.views.modelexplorer.matching.ModelElementItemMatchingItem;
import org.eclipse.papyrus.views.modelexplorer.matching.ReferencableMatchingItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.navigator.LinkHelperService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelExplorerView
extends CommonNavigator
implements IRevealSemanticElement,
IEditingDomainProvider,
IPageLifeCycleEventsListener {
    private SharedModelExplorerState sharedState;
    private SharedModelExplorerState.StateChangedListener sharedStateListener;
    public static final String LABEL_PROVIDER_SERVICE_CONTEXT = "org.eclipse.papyrus.views.modelexplorer.labelProvider.context";
    private ServicesRegistry serviceRegistry;
    private ISaveAndDirtyService saveAndDirtyService;
    private IUndoContext undoContext;
    private TransactionalEditingDomain editingDomain;
    private AtomicBoolean isRefreshing = new AtomicBoolean(false);
    private ISelectionListener pageSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            ModelExplorerView.this.handleSelectionChangedFromDiagramEditor(part, selection);
        }
    };
    protected IEditorInputChangedListener editorInputChangedListener = new IEditorInputChangedListener(){

        public void editorInputChanged(FileEditorInput fileEditorInput) {
            ModelExplorerView.this.setPartName(fileEditorInput.getName());
        }

        public void isDirtyChanged() {
            ModelExplorerView.this.firePropertyChange(257);
        }
    };
    private final List<IPropertySheetPage> propertySheetPages = new LinkedList<IPropertySheetPage>();
    TreeItem currentItem;
    SelectionMenu selectionMenu;
    private final ResourceSetListener resourceSetListener = new ResourceSetListenerImpl(){

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            super.resourceSetChanged(event);
            ModelExplorerView.this.handleResourceSetChanged(event);
        }
    };
    private Transaction lastTrans = null;
    private Runnable refreshRunnable;

    public ModelExplorerView(IMultiDiagramEditor part) {
        if (part == null) {
            throw new IllegalArgumentException("A part should be provided.");
        }
        this.init(part);
        IReloadableEditor.Adapter.getAdapter((IMultiDiagramEditor)part).addEditorReloadListener((IEditorReloadListener)new EditorReloadAdapter(){

            public void editorAboutToReload(EditorReloadEvent event) {
                event.putContext((Object)new ModelExplorerTreeViewerContext((AbstractTreeViewer)ModelExplorerView.this.getCommonViewer()));
                ModelExplorerView.this.deactivate();
            }

            public void editorReloaded(EditorReloadEvent event) {
                ModelExplorerView.this.init(event.getEditor());
                ModelExplorerView.this.activate();
                ModelExplorerView.this.initCommonViewer(ModelExplorerView.this.getCommonViewer());
                ((TreeViewerContext)event.getContext()).restore((AbstractTreeViewer)ModelExplorerView.this.getCommonViewer());
            }
        });
    }

    private void init(IMultiDiagramEditor editor) {
        this.serviceRegistry = editor.getServicesRegistry();
        if (this.serviceRegistry == null) {
            throw new IllegalArgumentException("The editor should have a ServiceRegistry.");
        }
        try {
            this.saveAndDirtyService = (ISaveAndDirtyService)this.serviceRegistry.getService(ISaveAndDirtyService.class);
            this.undoContext = (IUndoContext)this.serviceRegistry.getService(IUndoContext.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void handleSelectionChangedFromDiagramEditor(IWorkbenchPart part, ISelection selection) {
        if (this.isLinkingEnabled()) {
            if (part instanceof IEditorPart && selection instanceof IStructuredSelection) {
                Iterator selectionIterator = ((IStructuredSelection)selection).iterator();
                ArrayList<EObject> semanticElementList = new ArrayList<EObject>();
                while (selectionIterator.hasNext()) {
                    Object currentSelection = selectionIterator.next();
                    EObject semanticElement = EMFHelper.getEObject(currentSelection);
                    if (semanticElement == null) continue;
                    semanticElementList.add(semanticElement);
                }
                this.revealSemanticElement(semanticElementList);
            }
            if (part instanceof ModelExplorerPageBookView && !selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection sSelection = (IStructuredSelection)selection;
                LinkHelperService linkService = this.getLinkHelperService();
                ILinkHelper[] helpers = linkService.getLinkHelpersFor(sSelection.getFirstElement());
                if (helpers.length > 0) {
                    helpers[0].activateEditor(part.getSite().getPage(), sSelection);
                }
            }
        }
    }

    protected List<Object> searchPath(EObject eobject, List<Object> objects) {
        IPageManager iPageMngr;
        SemanticFromModelExplorer semanticGetter = new SemanticFromModelExplorer();
        ArrayList<Object> path = new ArrayList<Object>();
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.getCommonViewer().getContentProvider();
        try {
            iPageMngr = ServiceUtils.getInstance().getIPageManager((Object)this.serviceRegistry);
        }
        catch (ServiceException e) {
            return Collections.emptyList();
        }
        Object[] result = iPageMngr.allPages().toArray();
        List<Object> editors = Arrays.asList(result);
        for (Object o : objects) {
            if (!editors.contains(o) && eobject.equals(EMFHelper.getEObject((Object)o))) {
                path.add(o);
                return path;
            }
            int i = 0;
            while (i < contentProvider.getChildren(o).length) {
                Object treeItem = contentProvider.getChildren(o)[i];
                List<Object> tmppath = new ArrayList();
                Object element = semanticGetter.getSemanticElement(treeItem);
                if (element != null) {
                    ArrayList<Object> childs;
                    if (element instanceof EReference) {
                        if (((EReference)element).isContainment() && !((EReference)element).isDerived()) {
                            childs = new ArrayList();
                            childs.add(treeItem);
                            tmppath = this.searchPath(eobject, childs);
                        }
                    } else if (element instanceof EObject) {
                        childs = new ArrayList<Object>();
                        childs.add(treeItem);
                        tmppath = this.searchPath(eobject, childs);
                    }
                }
                if (tmppath.size() > 0 && eobject.equals(EMFHelper.getEObject(tmppath.get(tmppath.size() - 1)))) {
                    path.add(o);
                    path.addAll(tmppath);
                    return path;
                }
                ++i;
            }
        }
        return new ArrayList<Object>();
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        CustomCommonViewer viewer = new CustomCommonViewer(this.getViewSite().getId(), aParent, 770);
        this.initCommonViewer(viewer);
        viewer.getNavigatorContentService().getActivationService().addExtensionActivationListener(new IExtensionActivationListener(){

            public void onExtensionActivation(String aViewerId, String[] theNavigatorExtensionIds, boolean isActive) {
                ModelExplorerView.this.sharedState.updateNavigatorContentExtensions(theNavigatorExtensionIds, isActive);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer, (int)2);
        return viewer;
    }

    private void installEMFFacetTreePainter(Tree tree) {
        LinkedList<Listener> listenersToRemove = new LinkedList<Listener>();
        Listener[] listenerArray = tree.getListeners(41);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            if (listener.getClass().getName().contains("org.eclipse.papyrus.emf.facet.infra.browser.uicore.internal.CustomTreePainter")) {
                listenersToRemove.add(listener);
            }
            ++n2;
        }
        for (Listener listener : listenersToRemove) {
            tree.removeListener(41, listener);
        }
    }

    private void initCommonViewer(CommonViewer viewer) {
        NavigatorContentService contentService = new NavigatorContentService(this.getViewSite().getId());
        Object input = this.getInitialInput();
        Set descriptors = contentService.findDescriptorsByTriggerPoint(input, false);
        for (Object descriptor : descriptors) {
            if (!(descriptor instanceof NavigatorContentDescriptor)) continue;
            Object labelProvider = null;
            if (input instanceof ServicesRegistry) {
                ServicesRegistry registry = (ServicesRegistry)input;
                try {
                    labelProvider = ((LabelProviderService)registry.getService(LabelProviderService.class)).getLabelProvider(LABEL_PROVIDER_SERVICE_CONTEXT);
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                }
                labelProvider = new DecoratingLabelProviderWTooltips((ILabelProvider)labelProvider, (ServicesRegistry)input);
            }
            if (labelProvider == null) {
                labelProvider = new LabelProvider();
            }
            viewer.setLabelProvider(labelProvider);
            break;
        }
        contentService.dispose();
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.getCommonViewer().setSorter(null);
        ((CustomCommonViewer)this.getCommonViewer()).getDropAdapter().setFeedbackEnabled(true);
        this.getCommonViewer().addDoubleClickListener((IDoubleClickListener)new DoubleClickListener(this.serviceRegistry));
        Tree tree = this.getCommonViewer().getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 65536) {
                    ModelExplorerView.this.exitItem();
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode != 65536) {
                    return;
                }
                Tree tree = ModelExplorerView.this.getCommonViewer().getTree();
                Event event = new Event();
                event.widget = tree;
                event.stateMask = 65536;
                Point absoluteTreeLocation = tree.toDisplay(new Point(0, 0));
                event.x = tree.getDisplay().getCursorLocation().x - absoluteTreeLocation.x;
                event.y = tree.getDisplay().getCursorLocation().y - absoluteTreeLocation.y;
                MouseEvent mouseEvent = new MouseEvent(event);
                if (ModelExplorerView.this.isEnterState(mouseEvent)) {
                    ModelExplorerView.this.enterItem(ModelExplorerView.this.currentItem);
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if ((e.stateMask & 0x10000) == 0) {
                    return;
                }
                TreeItem currentItem = ModelExplorerView.this.getTreeItem(e);
                if (currentItem != null) {
                    Object data = currentItem.getData();
                    try {
                        NavigationService service = (NavigationService)ModelExplorerView.this.serviceRegistry.getService(NavigationService.class);
                        List navigableElements = service.getNavigableElements(data);
                        for (NavigableElement navigableElement : navigableElements) {
                            if (!navigableElement.isEnabled()) continue;
                            service.navigate(navigableElement);
                        }
                    }
                    catch (ServiceException ex) {
                        Activator.log.error((Throwable)ex);
                    }
                }
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (ModelExplorerView.this.isExitState(e)) {
                    ModelExplorerView.this.exitItem();
                }
                if (ModelExplorerView.this.isEnterState(e)) {
                    ModelExplorerView.this.enterItem(ModelExplorerView.this.currentItem);
                }
            }
        });
        this.installEMFFacetTreePainter(tree);
        try {
            ISashWindowsContainer sashWindowsContainer = (ISashWindowsContainer)this.serviceRegistry.getService(ISashWindowsContainer.class);
            sashWindowsContainer.addPageLifeCycleListener((IPageLifeCycleEventsListener)this);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (this.sharedState != null) {
            this.initSharedState(this.sharedState);
        }
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        CommonViewer viewer = super.createCommonViewer(aParent);
        ViewerColumn column = (ViewerColumn)viewer.getTree().getData("org.eclipse.jface.columnViewer");
        column.setEditingSupport((EditingSupport)new DirectEditorEditingSupport((ColumnViewer)viewer));
        return viewer;
    }

    private boolean isExitState(MouseEvent e) {
        if (this.currentItem == null) {
            return false;
        }
        TreeItem item = this.getTreeItem(e);
        if (item == null) {
            return true;
        }
        if (item != this.currentItem) {
            return true;
        }
        return (e.stateMask & 0x10000) == 0;
    }

    private boolean isEnterState(MouseEvent e) {
        TreeItem item = this.getTreeItem(e);
        if (item == this.currentItem) {
            return false;
        }
        if (item == null) {
            return false;
        }
        if ((e.stateMask & 0x10000) == 0) {
            return false;
        }
        this.currentItem = item;
        return true;
    }

    private void disposeCurrentMenu() {
        if (this.selectionMenu != null) {
            this.selectionMenu.dispose();
            this.selectionMenu = null;
        }
    }

    private void exitItem() {
        this.currentItem = null;
        this.disposeCurrentMenu();
    }

    private void enterItem(TreeItem item) {
        try {
            final NavigationService navigation = (NavigationService)this.serviceRegistry.getService(NavigationService.class);
            this.disposeCurrentMenu();
            this.selectionMenu = navigation.createNavigationList(item.getData(), (Control)item.getParent());
            if (this.selectionMenu == null) {
                return;
            }
            this.selectionMenu.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    NavigableElement navigableElement;
                    if (event.getSelection().isEmpty()) {
                        return;
                    }
                    Object selectedElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (selectedElement instanceof NavigableElement && (navigableElement = (NavigableElement)selectedElement).isEnabled()) {
                        navigation.navigate((NavigableElement)selectedElement);
                        ModelExplorerView.this.exitItem();
                    }
                }
            });
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    private TreeItem getTreeItem(MouseEvent e) {
        return ((Tree)e.widget).getItem(new Point(e.x, e.y));
    }

    public Control getControl() {
        return this.getCommonViewer().getControl();
    }

    public void init(IViewSite site, IMemento aMemento) throws PartInitException {
        super.init(site, aMemento);
        this.activate();
        this.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                switch (propId) {
                    case 65536: {
                        ModelExplorerView.this.sharedState.setLinkingEnabled(ModelExplorerView.this.isLinkingEnabled());
                    }
                }
            }
        });
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IWorkbenchPage page = site.getPage();
        page.addSelectionListener(this.pageSelectionListener);
    }

    private void handleResourceSetChanged(ResourceSetChangeEvent event) {
        Transaction curTrans = event.getTransaction();
        if (this.lastTrans != null && this.lastTrans.equals(curTrans)) {
            return;
        }
        this.lastTrans = curTrans;
        this.scheduleRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleRefresh() {
        Runnable schedule;
        ModelExplorerView modelExplorerView = this;
        synchronized (modelExplorerView) {
            if (this.refreshRunnable == null) {
                this.refreshRunnable = schedule = this.createRefreshRunnable();
            } else {
                schedule = null;
            }
        }
        if (schedule != null) {
            Display display;
            Control control = this.getControl();
            Display display2 = display = control == null || control.isDisposed() ? null : control.getDisplay();
            if (display != null) {
                display.asyncExec(schedule);
            }
        }
    }

    private Runnable createRefreshRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ModelExplorerView modelExplorerView = ModelExplorerView.this;
                synchronized (modelExplorerView) {
                    if (ModelExplorerView.this.refreshRunnable != this) {
                        return;
                    }
                    ModelExplorerView.this.refreshRunnable = null;
                }
                ModelExplorerView.this.refreshInUIThread();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncRefresh() {
        Runnable pending;
        ModelExplorerView modelExplorerView = this;
        synchronized (modelExplorerView) {
            pending = this.refreshRunnable;
        }
        if (pending != null) {
            Display display;
            Control control = this.getControl();
            Display display2 = display = control == null || control.isDisposed() ? null : control.getDisplay();
            if (display != null) {
                display.syncExec(pending);
            }
        }
    }

    protected void refreshInUIThread() {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.isRefreshing.compareAndSet(false, true)) {
            if (!this.getCommonViewer().isBusy()) {
                this.getCommonViewer().refresh();
            }
            this.isRefreshing.set(false);
        }
    }

    protected Object getInitialInput() {
        if (this.serviceRegistry != null) {
            return this.serviceRegistry;
        }
        return super.getInitialInput();
    }

    private void activate() {
        try {
            this.editingDomain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.serviceRegistry);
            if (this.getCommonViewer() != null) {
                this.getCommonViewer().setInput((Object)this.serviceRegistry);
            }
            this.editingDomain.addResourceSetListener(this.resourceSetListener);
            IReadOnlyHandler2 readOnlyHandler = (IReadOnlyHandler2)AdapterUtils.adapt((Object)this.editingDomain, IReadOnlyHandler2.class, null);
            if (readOnlyHandler != null) {
                readOnlyHandler.addReadOnlyListener(this.createReadOnlyListener());
            }
        }
        catch (ServiceException readOnlyHandler) {
            // empty catch block
        }
        this.saveAndDirtyService.addInputChangedListener(this.editorInputChangedListener);
        if (this.getCommonViewer() != null) {
            Display display = this.getControl().getDisplay();
            if (display == Display.getCurrent()) {
                this.refreshInUIThread();
            } else {
                Activator.log.warn("Model Explorer activated on a non-UI thread.");
                this.scheduleRefresh();
            }
        }
    }

    private void deactivate() {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug("deactivate ModelExplorerView");
        }
        try {
            ISashWindowsContainer sashWindowsContainer = (ISashWindowsContainer)this.serviceRegistry.getService(ISashWindowsContainer.class);
            if (sashWindowsContainer != null) {
                sashWindowsContainer.removePageLifeCycleListener((IPageLifeCycleEventsListener)this);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.getSite().getPage().removeSelectionListener(this.pageSelectionListener);
        this.saveAndDirtyService.removeInputChangedListener(this.editorInputChangedListener);
        if (this.editingDomain != null) {
            this.editingDomain.removeResourceSetListener(this.resourceSetListener);
            this.editingDomain = null;
        }
        this.saveAndDirtyService = null;
        this.undoContext = null;
        this.editingDomain = null;
        this.editingDomain = null;
        this.lastTrans = null;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.sharedStateListener != null && this.sharedState != null) {
            this.sharedState.removeListener(this.sharedStateListener);
        }
        if (this.getSite() != null) {
            this.getSite().getPage().removeSelectionListener(this.pageSelectionListener);
        }
        this.deactivate();
        for (IPropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        this.propertySheetPages.clear();
        this.pageSelectionListener = null;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.saveAndDirtyService == null;
    }

    private IPropertySheetPage getPropertySheetPage() {
        try {
            IMultiDiagramEditor multiDiagramEditor = (IMultiDiagramEditor)ServiceUtils.getInstance().getService(IMultiDiagramEditor.class, (Object)this.serviceRegistry);
            if (multiDiagramEditor != null && multiDiagramEditor instanceof ITabbedPropertySheetPageContributor) {
                ITabbedPropertySheetPageContributor contributor = (ITabbedPropertySheetPageContributor)multiDiagramEditor;
                TabbedPropertySheetPage propertySheetPage = new TabbedPropertySheetPage(contributor);
                this.propertySheetPages.add((IPropertySheetPage)propertySheetPage);
                return propertySheetPage;
            }
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class.equals((Object)adapter)) {
            return this.getPropertySheetPage();
        }
        if (IUndoContext.class == adapter) {
            return this.undoContext;
        }
        if (ISaveablePart.class.equals((Object)adapter)) {
            try {
                return this.serviceRegistry.getService(IMultiDiagramEditor.class);
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
                return this.saveAndDirtyService;
            }
        }
        if (ServicesRegistry.class == adapter) {
            return this.serviceRegistry;
        }
        return super.getAdapter(adapter);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void selectReveal(ISelection selection) {
        this.syncRefresh();
        if (this.getCommonViewer() != null) {
            this.getCommonViewer().setSelection(selection, true);
        }
    }

    public void revealSemanticElement(List<?> elementList) {
        this.syncRefresh();
        ModelExplorerView.reveal(elementList, this.getCommonViewer());
    }

    public static void reveal(Iterable<?> elementList, final CommonViewer commonViewer) {
        ArrayList<ModelElementItemMatchingItem> matchingItemsToSelect = new ArrayList<ModelElementItemMatchingItem>();
        Iterable list = Iterables.filter(elementList, EObject.class);
        for (EObject currentEObject : list) {
            matchingItemsToSelect.add(new ModelElementItemMatchingItem(currentEObject));
            if (commonViewer.getContentProvider() == null) continue;
            ArrayList<EObject> parents = new ArrayList<EObject>();
            EObject tmp = currentEObject.eContainer();
            while (tmp != null) {
                parents.add(tmp);
                tmp = tmp.eContainer();
            }
            List reverseParents = Lists.reverse(parents);
            Resource r = null;
            r = !parents.isEmpty() ? ((EObject)parents.get(parents.size() - 1)).eResource() : currentEObject.eResource();
            if (r != null) {
                final ResourceSet rs = r.getResourceSet();
                final Resource resource = r;
                if (rs instanceof ModelSet && AdditionalResourcesModel.isAdditionalResource((ModelSet)((ModelSet)rs), (URI)r.getURI())) {
                    commonViewer.getControl().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            commonViewer.expandToLevel((Object)new ReferencableMatchingItem(rs), 1);
                            commonViewer.expandToLevel((Object)new ReferencableMatchingItem(resource), 1);
                        }
                    });
                }
            }
            EObject previousParent = null;
            for (EObject parent : reverseParents) {
                if (parent.eContainingFeature() != null && previousParent != null) {
                    commonViewer.expandToLevel((Object)new LinkItemMatchingItem(previousParent, parent.eContainmentFeature()), 1);
                }
                final ModelElementItemMatchingItem itemToExpand = new ModelElementItemMatchingItem(parent);
                commonViewer.getControl().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        commonViewer.expandToLevel((Object)itemToExpand, 1);
                    }
                });
                previousParent = parent;
            }
            final LinkItemMatchingItem itemToExpand = new LinkItemMatchingItem(currentEObject.eContainer(), currentEObject.eContainmentFeature());
            commonViewer.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    commonViewer.expandToLevel((Object)itemToExpand, 1);
                }
            });
        }
        ModelExplorerView.selectReveal((ISelection)new StructuredSelection(matchingItemsToSelect), (Viewer)commonViewer);
    }

    public static void selectReveal(final ISelection structuredSelection, final Viewer commonViewer) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                commonViewer.setSelection(structuredSelection, true);
            }
        });
    }

    public static void reveal(final ISelection selection, final CommonViewer viewer) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            ModelExplorerView.reveal(Lists.newArrayList((Iterator)structured.iterator()), viewer);
        } else {
            viewer.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    viewer.setSelection(selection);
                }
            });
        }
    }

    public void pageOpened(IPage page) {
        this.refreshTree();
    }

    public void pageClosed(IPage page) {
        this.refreshTree();
    }

    private void refreshTree() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ModelExplorerView.this.getCommonViewer().refresh(true);
                ModelExplorerView.this.getCommonViewer().getTree().redraw();
            }
        });
    }

    public void pageChanged(IPage newPage) {
    }

    public void pageActivated(IPage page) {
    }

    public void pageDeactivated(IPage page) {
    }

    public void pageAboutToBeOpened(IPage page) {
    }

    public void pageAboutToBeClosed(IPage page) {
    }

    private IReadOnlyListener createReadOnlyListener() {
        return new IReadOnlyListener(){

            public void readOnlyStateChanged(ReadOnlyEvent event) {
                switch (event.getEventType()) {
                    case 0: {
                        ModelExplorerView.this.scheduleRefresh();
                        break;
                    }
                    case 1: {
                        CommonViewer viewer = ModelExplorerView.this.getCommonViewer();
                        if (viewer == null || viewer.getControl() == null || viewer.getControl().isDisposed()) break;
                        viewer.refresh((Object)event.getObject());
                        break;
                    }
                    default: {
                        Activator.log.warn("Unsupported read-only event type: " + event.getEventType());
                    }
                }
            }
        };
    }

    void setSharedState(SharedModelExplorerState state) {
        if (this.sharedState != null) {
            this.sharedState.removeListener(this.getSharedStateListener());
        }
        this.sharedState = state;
        if (state != null) {
            state.addListener(this.getSharedStateListener());
            this.initSharedState(state);
        }
    }

    void initSharedState(SharedModelExplorerState state) {
        this.setLinkingEnabled(state.isLinkingEnabled());
        this.setAlphaSorted(state.isAlphaSorted());
    }

    void setAlphaSorted(boolean sorted) {
        CommonViewer viewer = this.getCommonViewer();
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            if (sorted) {
                viewer.setSorter((ViewerSorter)new CommonViewerSorter());
                if (viewer instanceof CustomCommonViewer) {
                    ((CustomCommonViewer)viewer).getDropAdapter().setFeedbackEnabled(false);
                }
            } else {
                viewer.setSorter(null);
                if (viewer instanceof CustomCommonViewer) {
                    ((CustomCommonViewer)viewer).getDropAdapter().setFeedbackEnabled(true);
                }
            }
        }
    }

    SharedModelExplorerState.StateChangedListener getSharedStateListener() {
        if (this.sharedStateListener == null) {
            this.sharedStateListener = new SharedModelExplorerState.StateChangedListener(){
                private volatile Runnable contentUpdate;

                public void sharedStateChanged(SharedModelExplorerState.StateChangedEvent event) {
                    switch (event.getEventType()) {
                        case 1: {
                            ModelExplorerView.this.setLinkingEnabled(event.getSource().isLinkingEnabled());
                            break;
                        }
                        case 2: {
                            ModelExplorerView.this.setAlphaSorted(event.getSource().isAlphaSorted());
                            break;
                        }
                        case 3: {
                            if (this.contentUpdate != null) break;
                            ModelExplorerView.this.getCommonViewer().getControl().getDisplay().asyncExec(this.getContentUpdate());
                        }
                    }
                }

                private Runnable getContentUpdate() {
                    if (this.contentUpdate == null) {
                        this.contentUpdate = new Runnable(){

                            public void run() {
                                CommonViewer viewer = ModelExplorerView.this.getCommonViewer();
                                if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                                    viewer.getNavigatorContentService().getActivationService().activateExtensions(ModelExplorerView.this.sharedState.getNavigatorContentExtensions(), true);
                                }
                                contentUpdate = null;
                            }
                        };
                    }
                    return this.contentUpdate;
                }
            };
        }
        return this.sharedStateListener;
    }
}

