/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewRefactorHelper;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.modelexplorer.commands.EObjectInheritanceCopyCommand;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTransformer {
    private static HashMap<String, AdapterFactory> factories = new HashMap();
    private static final String EXT_FACTORIES = "org.eclipse.emf.edit.itemProviderAdapterFactories";
    private static final String WARNING_TITLE = "Problems during transformation";
    private static final String WARNING_MSG = "It seems the transformation you want to perform can't be executed";
    private CompositeCommand globalCommand;
    private EObject element;
    private Set<View> referencingViews = new HashSet<View>();
    private EObjectInheritanceCopyCommand commandModel;
    private boolean graphCopy = true;
    private ImporterCommand importerCommand;

    public GenericTransformer(AbstractGraphicalEditPart currentNode) {
        this(currentNode, true);
    }

    public GenericTransformer(AbstractGraphicalEditPart currentNode, boolean graphCopy) {
        Object model;
        this.graphCopy = graphCopy;
        if (currentNode != null && (model = currentNode.getModel()) instanceof View) {
            this.element = ((View)model).getElement();
        }
    }

    public GenericTransformer(EObject currentEobject) {
        this.element = currentEobject;
    }

    public void transform(EClass eclass) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = page.getActiveEditor();
        CommandStack stack = (CommandStack)editor.getAdapter(CommandStack.class);
        this.globalCommand = new CompositeCommand("Generic Transformation");
        if (this.graphCopy && this.element != null) {
            EReference[] features = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
            Collection views = EMFCoreUtil.getReferencers((EObject)this.element, (EReference[])features);
            for (Object view : views) {
                if (!(view instanceof View)) continue;
                this.referencingViews.add((View)view);
            }
        }
        if (stack != null) {
            EObject model = (EObject)AdapterFactoryEditingDomain.unwrap((Object)this.element);
            TransactionalEditingDomain domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((EObject)model);
            this.commandModel = new EObjectInheritanceCopyCommand(model, eclass, domain);
            this.globalCommand.add((IUndoableOperation)this.commandModel);
            if (this.graphCopy) {
                this.importerCommand = new ImporterCommand(domain);
                if (this.importerCommand.canExecute()) {
                    this.globalCommand.add((IUndoableOperation)this.importerCommand);
                }
            }
            if (this.globalCommand.canExecute()) {
                try {
                    ECrossReferenceAdapter cross = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)this.element);
                    if (cross != null) {
                        cross.unsetTarget((Notifier)this.element);
                    }
                    stack.execute((Command)new ICommandProxy((ICommand)this.globalCommand));
                }
                catch (Exception e) {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)WARNING_TITLE, (String)WARNING_MSG);
                    e.printStackTrace();
                }
            } else {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)WARNING_TITLE, (String)WARNING_MSG);
            }
        }
    }

    public static HashSet<EClass> getAllSuperTypes(EClass class1) {
        HashSet<EClass> results = new HashSet<EClass>();
        results.addAll((Collection<EClass>)class1.getEAllSuperTypes());
        return results;
    }

    public static AdapterFactory getFactory(String uri) {
        AdapterFactory factory = factories.get(uri);
        if (factory == null) {
            IConfigurationElement[] extensions;
            IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_FACTORIES);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (uri.equals(e.getAttribute("uri"))) {
                    try {
                        factory = (AdapterFactory)e.createExecutableExtension("class");
                        if (factory != null) {
                            factories.put(uri, factory);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        return factory;
    }

    public MultiStatus isTransformationPossible(EClass eclass) {
        Collection usages;
        MultiStatus result = new MultiStatus("org.eclipse.papyrus.views.modelexplorer", 0, "Type incompatibility", null);
        if (this.element != null && (usages = EMFHelper.getUsages((EObject)this.element)) != null) {
            for (EStructuralFeature.Setting nonNavigableInverseReference : usages) {
                boolean compatible;
                EStructuralFeature structuralFeature = nonNavigableInverseReference.getEStructuralFeature();
                if (nonNavigableInverseReference.getEObject() instanceof View || (compatible = EObjectInheritanceCopyCommand.isCompatible(structuralFeature.getEType(), (EClassifier)eclass))) continue;
                String econtainer = structuralFeature.eContainer() instanceof EClassifier ? String.valueOf(((EClassifier)structuralFeature.eContainer()).getName()) + " ( " + nonNavigableInverseReference.getEObject().toString() + " )" : structuralFeature.eContainer().toString();
                Status s = new Status(2, "org.eclipse.papyrus.views.modelexplorer", String.format("an element typed %s references your selection, we can not assign instead of your selection an object typed %s", econtainer, eclass.getName()));
                result.add((IStatus)s);
            }
        }
        return result;
    }

    private class ImporterCommand
    extends AbstractTransactionalCommand {
        public ImporterCommand(TransactionalEditingDomain domain) {
            super(domain, "Import graphical nodes", null);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.graphCopy(null, GenericTransformer.this.commandModel.getResultEobject());
            return CommandResult.newOKCommandResult();
        }

        private void graphCopy(IDiagramEditDomain domain, EObject target) {
            for (View graphElement : GenericTransformer.this.referencingViews) {
                LayoutConstraint constraint;
                View parent = ViewUtil.getContainerView((View)graphElement);
                if (parent == null || graphElement.getDiagram() == null) continue;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                DiagramEditPart diagramEditPart = null;
                IEditorPart activeEditorPart = page.getActiveEditor();
                if (activeEditorPart instanceof IDiagramWorkbenchPart && graphElement.getDiagram().equals(((IDiagramWorkbenchPart)activeEditorPart).getDiagram())) {
                    diagramEditPart = ((IDiagramWorkbenchPart)activeEditorPart).getDiagramEditPart();
                }
                if (diagramEditPart == null) {
                    List editorParts = EditorService.getInstance().getRegisteredEditorParts();
                    for (Object editorPart : editorParts) {
                        if (!(editorPart instanceof IDiagramWorkbenchPart) || !graphElement.getDiagram().equals(((IDiagramWorkbenchPart)editorPart).getDiagram())) continue;
                        diagramEditPart = ((IDiagramWorkbenchPart)editorPart).getDiagramEditPart();
                    }
                }
                if (diagramEditPart == null) continue;
                EditPart containerPart = (EditPart)diagramEditPart.getViewer().getEditPartRegistry().get(parent);
                DropObjectsRequest req = new DropObjectsRequest();
                req.setObjects(Collections.singletonList(target));
                if (graphElement instanceof Node && (constraint = ((Node)graphElement).getLayoutConstraint()) instanceof Location) {
                    Location location = (Location)constraint;
                    req.setLocation(new Point(location.getX(), location.getY()));
                }
                if (req.getLocation() == null) {
                    req.setLocation(new Point());
                }
                Command partCreationCmd = containerPart.getCommand((Request)req);
                partCreationCmd.execute();
                View newView = null;
                if (partCreationCmd instanceof ICommandProxy) {
                    CommandResult res = ((ICommandProxy)partCreationCmd).getICommand().getCommandResult();
                    Object newValue = res.getReturnValue();
                    if (newValue instanceof Collection) {
                        for (Object value : (Collection)newValue) {
                            if (!(value instanceof CreateViewRequest.ViewDescriptor)) continue;
                            newView = (View)((CreateViewRequest.ViewDescriptor)value).getAdapter(View.class);
                        }
                    } else if (newValue instanceof CreateViewRequest.ViewDescriptor) {
                        newView = (View)((CreateViewRequest.ViewDescriptor)newValue).getAdapter(View.class);
                    }
                }
                if (newView != null) {
                    ViewTransformerHelper helper = new ViewTransformerHelper(diagramEditPart.getDiagramPreferencesHint());
                    helper.copyMixedViewFeatures(graphElement, newView);
                }
                GroupRequest deleteReq = new GroupRequest((Object)"delete");
                EditPart oldPart = (EditPart)diagramEditPart.getViewer().getEditPartRegistry().get(graphElement);
                Command partDeletionCmd = oldPart.getCommand((Request)deleteReq);
                partDeletionCmd.execute();
            }
        }
    }

    private static class ViewTransformerHelper
    extends ViewRefactorHelper {
        public ViewTransformerHelper(PreferencesHint preferencesHint) {
            super(preferencesHint);
        }

        public void copyMixedViewFeatures(View oldView, View newView) {
            if (oldView instanceof Diagram && newView instanceof Diagram) {
                this.copyDiagramFeatures((Diagram)oldView, (Diagram)newView);
            } else if (oldView instanceof Node && newView instanceof Node) {
                this.copyNodeFeatures((Node)oldView, (Node)newView);
            } else if (oldView instanceof Edge && newView instanceof Edge) {
                this.copyEdgeFeatures((Edge)oldView, (Edge)newView);
            } else {
                this.copyViewFeatures(oldView, newView);
            }
        }
    }
}

