/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.modelelement;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.views.properties.modelelement.DataSourceFactory;
import org.eclipse.papyrus.views.properties.modelelement.IDataSourceListener;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;

public class DataSource
implements IChangeListener {
    private final ListenerList changeListeners = new ListenerList(1);
    private final ListenerList dataSourceListeners = new ListenerList(1);
    private View view;
    private IStructuredSelection selection;
    private Map<String, ModelElement> elements = new HashMap<String, ModelElement>();

    protected DataSource(View view, IStructuredSelection selection) {
        this.view = view;
        this.selection = selection;
    }

    public ModelElement getModelElement(String propertyPath) {
        String key = propertyPath.substring(0, propertyPath.lastIndexOf(":"));
        if (!this.elements.containsKey(key)) {
            ModelElement element = DataSourceFactory.instance.getModelElementFromPropertyPath(this, propertyPath);
            if (element == null) {
                Activator.log.warn("Unable to find a ModelElement for " + propertyPath + ". Elements : " + this.elements);
            }
            this.elements.put(key, element);
        }
        return this.elements.get(key);
    }

    private String getLocalPropertyPath(String propertyPath) {
        return propertyPath.substring(propertyPath.lastIndexOf(":") + 1);
    }

    public IObservable getObservable(String propertyPath) {
        String localPropertyPath = this.getLocalPropertyPath(propertyPath);
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        IObservable observable = element.getObservable(localPropertyPath);
        if (observable != null) {
            observable.addChangeListener((IChangeListener)this);
        }
        return observable;
    }

    public String toString() {
        return "[DataSource] " + super.toString();
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return EmptyContentProvider.instance;
        }
        String localPropertyPath = this.getLocalPropertyPath(propertyPath);
        return element.getContentProvider(localPropertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        String localPropertyPath = this.getLocalPropertyPath(propertyPath);
        return element.getLabelProvider(localPropertyPath);
    }

    public void addChangeListener(IChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    public void addDataSourceListener(IDataSourceListener listener) {
        this.dataSourceListeners.add((Object)listener);
    }

    public void removeDataSourceListener(IDataSourceListener listener) {
        this.dataSourceListeners.remove((Object)listener);
    }

    public void handleChange(ChangeEvent event) {
        Object[] listeners = this.changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                ((IChangeListener)listeners[i]).handleChange(event);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in observable change listener.", (Throwable)e);
            }
            ++i;
        }
    }

    protected void fireDataSourceChanged() {
        Object[] listeners = this.dataSourceListeners.getListeners();
        if (listeners.length > 0) {
            DataSourceChangedEvent event = new DataSourceChangedEvent(this);
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((IDataSourceListener)listeners[i]).dataSourceChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in data-source listener.", (Throwable)e);
                }
                ++i;
            }
        }
    }

    public View getView() {
        return this.view;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setSelection(IStructuredSelection selection) {
        if (!selection.equals(this.selection)) {
            this.selection = selection;
            this.fireDataSourceChanged();
        }
    }

    public boolean isOrdered(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return false;
        }
        return element.isOrdered(this.getLocalPropertyPath(propertyPath));
    }

    public boolean isUnique(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return false;
        }
        return element.isUnique(this.getLocalPropertyPath(propertyPath));
    }

    public boolean isMandatory(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return false;
        }
        return element.isMandatory(this.getLocalPropertyPath(propertyPath));
    }

    public boolean isEditable(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return false;
        }
        return element.isEditable(this.getLocalPropertyPath(propertyPath));
    }

    public boolean forceRefresh(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return false;
        }
        return element.forceRefresh(this.getLocalPropertyPath(propertyPath));
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        return element.getValueFactory(this.getLocalPropertyPath(propertyPath));
    }

    public Object getDefaultValue(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        return element.getDefaultValue(this.getLocalPropertyPath(propertyPath));
    }

    public boolean getDirectCreation(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return true;
        }
        return element.getDirectCreation(this.getLocalPropertyPath(propertyPath));
    }

    public void dispose() {
        for (ModelElement element : this.elements.values()) {
            if (element == null) continue;
            element.dispose();
        }
        this.elements.clear();
    }

    public IValidator getValidator(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        return element.getValidator(this.getLocalPropertyPath(propertyPath));
    }
}

