/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.modelelement;

import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.databinding.EMFObservableList;
import org.eclipse.papyrus.infra.emf.databinding.EMFObservableValue;
import org.eclipse.papyrus.infra.emf.dialog.NestedEditingDialogContext;
import org.eclipse.papyrus.infra.emf.providers.EMFContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.creation.EcorePropertyEditorFactory;
import org.eclipse.papyrus.views.properties.modelelement.AbstractModelElement;

public class EMFModelElement
extends AbstractModelElement {
    protected EObject source;
    protected EditingDomain domain;

    public EMFModelElement(EObject source) {
        this(source, null);
    }

    public EMFModelElement(EObject source, EditingDomain domain) {
        this.source = source;
        this.domain = domain;
    }

    public EditingDomain getDomain() {
        return this.domain;
    }

    public EObject getSource() {
        return this.source;
    }

    protected IObservable doGetObservable(String propertyPath) {
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return null;
        }
        if (feature.getUpperBound() != 1) {
            EMFObservableList list = this.domain == null ? EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source) : new EMFObservableList((List)EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source), this.domain, this.getSource(featurePath), feature);
            return list;
        }
        EMFObservableValue value = this.domain == null ? EMFProperties.value((FeaturePath)featurePath).observe((Object)this.source) : new EMFObservableValue(this.getSource(featurePath), feature, this.domain);
        return value;
    }

    public EObject getSource(FeaturePath featurePath) {
        EObject currentSource = this.source;
        EStructuralFeature[] features = featurePath.getFeaturePath();
        int i = 0;
        while (i < features.length - 1) {
            currentSource = (EObject)currentSource.eGet(features[i]);
            ++i;
        }
        return currentSource;
    }

    public EStructuralFeature getFeature(FeaturePath featurePath) {
        EStructuralFeature[] features = featurePath.getFeaturePath();
        return features[features.length - 1];
    }

    public EStructuralFeature getFeature(String propertyPath) {
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        return this.getFeature(featurePath);
    }

    public FeaturePath getFeaturePath(String propertyPath) {
        String[] featureNames = propertyPath.split("\\.");
        EStructuralFeature[] features = new EStructuralFeature[featureNames.length];
        int i = 0;
        EClass currentClass = this.source.eClass();
        String[] stringArray = featureNames;
        int n = featureNames.length;
        int n2 = 0;
        while (n2 < n) {
            String featureName = stringArray[n2];
            EStructuralFeature feature = currentClass.getEStructuralFeature(featureName);
            features[i++] = feature;
            if (i < featureNames.length) {
                EReference reference;
                EClassifier type;
                if (feature instanceof EReference && (type = (reference = (EReference)feature).getEType()) instanceof EClass) {
                    currentClass = (EClass)type;
                } else {
                    Activator.log.warn("Cannot find feature path " + propertyPath + " for EClass " + this.source.eClass());
                    return null;
                }
            }
            ++n2;
        }
        return FeaturePath.fromList((EStructuralFeature[])features);
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        EStructuralFeature feature = this.getFeature(featurePath);
        if (feature != null) {
            return new EMFContentProvider(this.getSource(featurePath), feature);
        }
        return super.getContentProvider(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        try {
            LabelProviderService lpSvc = this.source.eResource() != null ? (LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)this.source) : (LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)NestedEditingDialogContext.getInstance().getResourceSet());
            return lpSvc.getLabelProvider();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return new EMFLabelProvider();
        }
    }

    public boolean isOrdered(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return true;
        }
        return feature.isOrdered();
    }

    public boolean isUnique(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return false;
        }
        return feature.isUnique();
    }

    public boolean isMandatory(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return false;
        }
        return EMFHelper.isRequired((EStructuralFeature)feature);
    }

    public final boolean isEditable(String propertyPath) {
        return this.isFeatureEditable(propertyPath) && this.isElementEditable();
    }

    protected boolean isFeatureEditable(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return false;
        }
        return feature.isChangeable();
    }

    protected boolean isElementEditable() {
        return !EMFHelper.isReadOnly((EObject)this.source);
    }

    public boolean forceRefresh(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return false;
        }
        return feature.isDerived();
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        EReference reference;
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature != null && feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            return new EcorePropertyEditorFactory(reference);
        }
        return super.getValueFactory(propertyPath);
    }

    public Object getDefaultValue(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return null;
        }
        return feature.getDefaultValue();
    }

    public boolean getDirectCreation(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return false;
        }
        if (feature instanceof EAttribute) {
            return false;
        }
        return ((EReference)feature).isContainment();
    }
}

