/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.match;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.php.internal.core.ast.nodes.ASTError;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ChainingInstanceCall;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.ast.nodes.DeclareStatement;
import org.eclipse.php.internal.core.ast.nodes.DereferenceNode;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.ast.nodes.EmptyStatement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FinallyClause;
import org.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.GotoLabel;
import org.eclipse.php.internal.core.ast.nodes.GotoStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.IgnoreError;
import org.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.PHPArrayDereferenceList;
import org.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Quote;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitAlias;
import org.eclipse.php.internal.core.ast.nodes.TraitPrecedence;
import org.eclipse.php.internal.core.ast.nodes.TraitStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.nodes.YieldExpression;

public class ASTMatcher {
    private boolean matchDocTags;

    public ASTMatcher() {
        this(false);
    }

    public ASTMatcher(boolean matchDocTags) {
        this.matchDocTags = matchDocTags;
    }

    public final boolean safeSubtreeListMatch(Collection list1, Collection list2) {
        int size2;
        int size1 = list1.size();
        if (size1 != (size2 = list2.size())) {
            return false;
        }
        Iterator it1 = list1.iterator();
        Iterator it2 = list2.iterator();
        while (it1.hasNext()) {
            ASTNode n1 = (ASTNode)it1.next();
            ASTNode n2 = (ASTNode)it2.next();
            if (n1 == null && n2 == null) continue;
            if (n1 == null || n2 == null) {
                return false;
            }
            if (n1.subtreeMatch(this, n2)) continue;
            return false;
        }
        return true;
    }

    public final boolean safeSubtreeListMatch(Expression[] list1, Expression[] list2) {
        return this.safeSubtreeListMatch(Arrays.asList(list1), Arrays.asList(list2));
    }

    public final boolean safeSubtreeListMatch(Statement[] list1, Statement[] list2) {
        return this.safeSubtreeListMatch(Arrays.asList(list1), Arrays.asList(list2));
    }

    public final boolean safeSubtreeListMatch(ASTNode[] list1, ASTNode[] list2) {
        return this.safeSubtreeListMatch(Arrays.asList(list1), Arrays.asList(list2));
    }

    public final boolean safeSubtreeMatch(Object node1, Object node2) {
        if (node1 == null && node2 == null) {
            return true;
        }
        if (node1 == null || node2 == null) {
            return false;
        }
        return ((ASTNode)node1).subtreeMatch(this, node2);
    }

    public static boolean safeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public boolean match(ArrayAccess node, Object other) {
        if (!(other instanceof ArrayAccess)) {
            return false;
        }
        ArrayAccess o = (ArrayAccess)other;
        return this.safeSubtreeMatch(node.getName(), o.getName()) && this.safeSubtreeMatch(node.getIndex(), o.getIndex()) && ASTMatcher.safeEquals(node.getArrayType(), o.getArrayType());
    }

    public boolean match(ArrayCreation node, Object other) {
        if (!(other instanceof ArrayCreation)) {
            return false;
        }
        ArrayCreation o = (ArrayCreation)other;
        return this.safeSubtreeListMatch(node.elements(), o.elements());
    }

    public boolean match(ArrayElement node, Object other) {
        if (!(other instanceof ArrayElement)) {
            return false;
        }
        ArrayElement o = (ArrayElement)other;
        return this.safeSubtreeMatch(node.getKey(), o.getKey()) && this.safeSubtreeMatch(node.getValue(), o.getValue());
    }

    public boolean match(Assignment node, Object other) {
        if (!(other instanceof Assignment)) {
            return false;
        }
        Assignment o = (Assignment)other;
        return ASTMatcher.safeEquals(node.getOperator(), o.getOperator()) && this.safeSubtreeMatch(node.getRightHandSide(), o.getRightHandSide()) && this.safeSubtreeMatch(node.getLeftHandSide(), o.getLeftHandSide());
    }

    public boolean match(ASTError node, Object other) {
        return false;
    }

    public boolean match(BackTickExpression node, Object other) {
        if (!(other instanceof BackTickExpression)) {
            return false;
        }
        BackTickExpression o = (BackTickExpression)other;
        return this.safeSubtreeListMatch(node.expressions(), o.expressions());
    }

    public boolean match(Block node, Object other) {
        if (!(other instanceof Block)) {
            return false;
        }
        Block o = (Block)other;
        return ASTMatcher.safeEquals(node.isCurly(), o.isCurly()) && this.safeSubtreeListMatch(node.statements(), o.statements());
    }

    public boolean match(BreakStatement node, Object other) {
        if (!(other instanceof BreakStatement)) {
            return false;
        }
        BreakStatement o = (BreakStatement)other;
        return this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(CastExpression node, Object other) {
        if (!(other instanceof CastExpression)) {
            return false;
        }
        CastExpression o = (CastExpression)other;
        return ASTMatcher.safeEquals(node.getCastingType(), o.getCastingType()) && this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(CatchClause node, Object other) {
        if (!(other instanceof CatchClause)) {
            return false;
        }
        CatchClause o = (CatchClause)other;
        return this.safeSubtreeMatch(node.getClassName(), o.getClassName()) && this.safeSubtreeMatch(node.getVariable(), o.getVariable()) && this.safeSubtreeMatch(node.getBody(), o.getBody());
    }

    public boolean match(ConstantDeclaration node, Object other) {
        if (!(other instanceof ConstantDeclaration)) {
            return false;
        }
        ConstantDeclaration o = (ConstantDeclaration)other;
        return this.safeSubtreeListMatch(node.initializers(), o.initializers()) && this.safeSubtreeListMatch(node.names(), o.names());
    }

    public boolean match(ClassDeclaration node, Object other) {
        if (!(other instanceof ClassDeclaration)) {
            return false;
        }
        ClassDeclaration o = (ClassDeclaration)other;
        return ASTMatcher.safeEquals(node.getModifier(), o.getModifier()) && this.safeSubtreeMatch(node.getSuperClass(), o.getSuperClass()) && this.match((TypeDeclaration)node, (Object)o);
    }

    private boolean match(TypeDeclaration node, Object other) {
        if (!(other instanceof TypeDeclaration)) {
            return false;
        }
        TypeDeclaration o = (TypeDeclaration)other;
        return this.safeSubtreeMatch(node.getName(), o.getName()) && this.safeSubtreeMatch(node.getBody(), o.getBody()) && this.safeSubtreeListMatch(node.interfaces(), o.interfaces());
    }

    public boolean match(ClassInstanceCreation node, Object other) {
        if (!(other instanceof ClassInstanceCreation)) {
            return false;
        }
        ClassInstanceCreation o = (ClassInstanceCreation)other;
        return this.safeSubtreeMatch(node.getClassName(), o.getClassName()) && this.safeSubtreeListMatch(node.ctorParams(), o.ctorParams());
    }

    public boolean match(ClassName node, Object other) {
        if (!(other instanceof ClassName)) {
            return false;
        }
        ClassName o = (ClassName)other;
        return this.safeSubtreeMatch(node.getName(), o.getName());
    }

    public boolean match(CloneExpression node, Object other) {
        if (!(other instanceof CloneExpression)) {
            return false;
        }
        CloneExpression o = (CloneExpression)other;
        return this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(Comment node, Object other) {
        return true;
    }

    public boolean match(ConditionalExpression node, Object other) {
        if (!(other instanceof ConditionalExpression)) {
            return false;
        }
        ConditionalExpression o = (ConditionalExpression)other;
        return this.safeSubtreeMatch(node.getCondition(), o.getCondition()) && this.safeSubtreeMatch(node.getIfTrue(), o.getIfTrue()) && this.safeSubtreeMatch(node.getIfFalse(), o.getIfFalse());
    }

    public boolean match(ContinueStatement node, Object other) {
        if (!(other instanceof ContinueStatement)) {
            return false;
        }
        ContinueStatement o = (ContinueStatement)other;
        return this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(DeclareStatement node, Object other) {
        if (!(other instanceof DeclareStatement)) {
            return false;
        }
        DeclareStatement o = (DeclareStatement)other;
        return this.safeSubtreeMatch(node.getBody(), o.getBody()) && this.safeSubtreeListMatch(node.directiveNames(), o.directiveNames()) && this.safeSubtreeListMatch(node.directiveValues(), o.directiveValues());
    }

    public boolean match(DoStatement node, Object other) {
        if (!(other instanceof DoStatement)) {
            return false;
        }
        DoStatement o = (DoStatement)other;
        return this.safeSubtreeMatch(node.getCondition(), o.getCondition()) && this.safeSubtreeMatch(node.getBody(), o.getBody());
    }

    public boolean match(EchoStatement node, Object other) {
        if (!(other instanceof EchoStatement)) {
            return false;
        }
        EchoStatement o = (EchoStatement)other;
        return this.safeSubtreeListMatch(node.expressions(), o.expressions());
    }

    public boolean match(EmptyStatement node, Object other) {
        return other instanceof EmptyStatement;
    }

    public boolean match(ExpressionStatement node, Object other) {
        if (!(other instanceof ExpressionStatement)) {
            return false;
        }
        ExpressionStatement o = (ExpressionStatement)other;
        return this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(FieldAccess node, Object other) {
        if (!(other instanceof FieldAccess)) {
            return false;
        }
        FieldAccess o = (FieldAccess)other;
        return this.safeSubtreeMatch(node.getDispatcher(), o.getDispatcher()) && this.safeSubtreeMatch(node.getField(), o.getField());
    }

    public boolean match(FieldsDeclaration node, Object other) {
        if (!(other instanceof FieldsDeclaration)) {
            return false;
        }
        FieldsDeclaration o = (FieldsDeclaration)other;
        return ASTMatcher.safeEquals(node.getModifier(), o.getModifier()) && this.safeSubtreeListMatch(node.getInitialValues(), o.getInitialValues()) && this.safeSubtreeListMatch(node.getVariableNames(), o.getVariableNames());
    }

    public boolean match(ForEachStatement node, Object other) {
        if (!(other instanceof ForEachStatement)) {
            return false;
        }
        ForEachStatement o = (ForEachStatement)other;
        return this.safeSubtreeMatch(node.getExpression(), o.getExpression()) && this.safeSubtreeMatch(node.getKey(), o.getKey()) && this.safeSubtreeMatch(node.getValue(), o.getValue()) && this.safeSubtreeMatch(node.getStatement(), o.getStatement());
    }

    public boolean match(FormalParameter node, Object other) {
        if (!(other instanceof FormalParameter)) {
            return false;
        }
        FormalParameter o = (FormalParameter)other;
        return ASTMatcher.safeEquals(node.isMandatory(), o.isMandatory()) && this.safeSubtreeMatch(node.getParameterType(), o.getParameterType()) && this.safeSubtreeMatch(node.getParameterName(), o.getParameterName()) && this.safeSubtreeMatch(node.getDefaultValue(), o.getDefaultValue());
    }

    public boolean match(ForStatement node, Object other) {
        if (!(other instanceof ForStatement)) {
            return false;
        }
        ForStatement o = (ForStatement)other;
        return this.safeSubtreeMatch(node.getBody(), o.getBody()) && this.safeSubtreeListMatch(node.initializers(), o.initializers()) && this.safeSubtreeListMatch(node.conditions(), o.conditions()) && this.safeSubtreeListMatch(node.updaters(), o.updaters());
    }

    public boolean match(FunctionDeclaration node, Object other) {
        if (!(other instanceof FunctionDeclaration)) {
            return false;
        }
        FunctionDeclaration o = (FunctionDeclaration)other;
        return ASTMatcher.safeEquals(node.isReference(), o.isReference()) && this.safeSubtreeMatch(node.getBody(), o.getBody()) && this.safeSubtreeMatch(node.getFunctionName(), o.getFunctionName()) && this.safeSubtreeListMatch(node.formalParameters(), o.formalParameters());
    }

    public boolean match(FunctionInvocation node, Object other) {
        if (!(other instanceof FunctionInvocation)) {
            return false;
        }
        FunctionInvocation o = (FunctionInvocation)other;
        return this.safeSubtreeMatch(node.getFunctionName(), o.getFunctionName()) && this.safeSubtreeListMatch(node.parameters(), o.parameters());
    }

    public boolean match(FunctionName node, Object other) {
        if (!(other instanceof FunctionName)) {
            return false;
        }
        FunctionName o = (FunctionName)other;
        return this.safeSubtreeMatch(node.getName(), o.getName());
    }

    public boolean match(GlobalStatement node, Object other) {
        if (!(other instanceof GlobalStatement)) {
            return false;
        }
        GlobalStatement o = (GlobalStatement)other;
        return this.safeSubtreeListMatch(node.variables(), o.variables());
    }

    public boolean match(Identifier node, Object other) {
        if (!(other instanceof Identifier)) {
            return false;
        }
        Identifier o = (Identifier)other;
        return ASTMatcher.safeEquals(node.getName(), o.getName());
    }

    public boolean match(IfStatement node, Object other) {
        if (!(other instanceof IfStatement)) {
            return false;
        }
        IfStatement o = (IfStatement)other;
        return this.safeSubtreeMatch(node.getCondition(), o.getCondition()) && this.safeSubtreeMatch(node.getTrueStatement(), o.getTrueStatement()) && this.safeSubtreeMatch(node.getFalseStatement(), o.getFalseStatement());
    }

    public boolean match(IgnoreError node, Object other) {
        if (!(other instanceof IgnoreError)) {
            return false;
        }
        IgnoreError o = (IgnoreError)other;
        return this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(Include node, Object other) {
        if (!(other instanceof Include)) {
            return false;
        }
        Include o = (Include)other;
        return ASTMatcher.safeEquals(node.getIncludeType(), o.getIncludeType()) && this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(InfixExpression node, Object other) {
        if (!(other instanceof InfixExpression)) {
            return false;
        }
        InfixExpression o = (InfixExpression)other;
        return ASTMatcher.safeEquals(node.getOperator(), o.getOperator()) && this.safeSubtreeMatch(node.getRight(), o.getRight()) && this.safeSubtreeMatch(node.getLeft(), o.getLeft());
    }

    public boolean match(InLineHtml node, Object other) {
        if (!(other instanceof InLineHtml)) {
            return false;
        }
        InLineHtml cfr_ignored_0 = (InLineHtml)other;
        return false;
    }

    public boolean match(InstanceOfExpression node, Object other) {
        if (!(other instanceof InstanceOfExpression)) {
            return false;
        }
        InstanceOfExpression o = (InstanceOfExpression)other;
        return this.safeSubtreeMatch(node.getClassName(), o.getClassName()) && this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(InterfaceDeclaration node, Object other) {
        if (!(other instanceof InterfaceDeclaration)) {
            return false;
        }
        InterfaceDeclaration o = (InterfaceDeclaration)other;
        return this.match((TypeDeclaration)node, (Object)o);
    }

    public boolean match(ListVariable node, Object other) {
        if (!(other instanceof ListVariable)) {
            return false;
        }
        ListVariable o = (ListVariable)other;
        return this.safeSubtreeListMatch(node.variables(), o.variables());
    }

    public boolean match(MethodDeclaration node, Object other) {
        if (!(other instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration o = (MethodDeclaration)other;
        return ASTMatcher.safeEquals(node.getModifier(), o.getModifier()) && this.safeSubtreeMatch(node.getFunction(), o.getFunction());
    }

    public boolean match(MethodInvocation node, Object other) {
        if (!(other instanceof MethodInvocation)) {
            return false;
        }
        MethodInvocation o = (MethodInvocation)other;
        return this.safeSubtreeMatch(node.getDispatcher(), o.getDispatcher()) && this.safeSubtreeMatch(node.getMethod(), o.getMethod());
    }

    public boolean match(ParenthesisExpression node, Object other) {
        if (!(other instanceof ParenthesisExpression)) {
            return false;
        }
        ParenthesisExpression o = (ParenthesisExpression)other;
        return this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(PostfixExpression node, Object other) {
        if (!(other instanceof PostfixExpression)) {
            return false;
        }
        PostfixExpression o = (PostfixExpression)other;
        return ASTMatcher.safeEquals(node.getOperator(), o.getOperator()) && this.safeSubtreeMatch(node.getVariable(), o.getVariable());
    }

    public boolean match(PrefixExpression node, Object other) {
        if (!(other instanceof PrefixExpression)) {
            return false;
        }
        PrefixExpression o = (PrefixExpression)other;
        return ASTMatcher.safeEquals(node.getOperator(), o.getOperator()) && this.safeSubtreeMatch(node.getVariable(), o.getVariable());
    }

    public boolean match(Program node, Object other) {
        if (!(other instanceof Program)) {
            return false;
        }
        Program o = (Program)other;
        return this.safeSubtreeListMatch(node.statements(), o.statements()) && this.safeSubtreeListMatch(((Map)((Object)node.comments())).values(), ((Map)((Object)o.comments())).values());
    }

    public boolean match(Quote node, Object other) {
        if (!(other instanceof Quote)) {
            return false;
        }
        Quote o = (Quote)other;
        return ASTMatcher.safeEquals(node.getQuoteType(), o.getQuoteType()) && this.safeSubtreeListMatch(node.expressions(), o.expressions());
    }

    public boolean match(Reference node, Object other) {
        if (!(other instanceof Reference)) {
            return false;
        }
        Reference o = (Reference)other;
        return this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(ReflectionVariable node, Object other) {
        if (!(other instanceof ReflectionVariable)) {
            return false;
        }
        ReflectionVariable o = (ReflectionVariable)other;
        return this.match((Variable)node, (Object)o);
    }

    public boolean match(ReturnStatement node, Object other) {
        if (!(other instanceof ReturnStatement)) {
            return false;
        }
        ReturnStatement o = (ReturnStatement)other;
        return this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(YieldExpression node, Object other) {
        if (!(other instanceof YieldExpression)) {
            return false;
        }
        YieldExpression o = (YieldExpression)other;
        return this.safeSubtreeMatch(node.getKey(), o.getKey()) && this.safeSubtreeMatch(node.getExpression(), o.getExpression());
    }

    public boolean match(Scalar node, Object other) {
        if (!(other instanceof Scalar)) {
            return false;
        }
        Scalar o = (Scalar)other;
        return ASTMatcher.safeEquals(node.getStringValue(), o.getStringValue()) && ASTMatcher.safeEquals(node.getScalarType(), o.getScalarType());
    }

    public boolean match(SingleFieldDeclaration node, Object other) {
        if (!(other instanceof SingleFieldDeclaration)) {
            return false;
        }
        SingleFieldDeclaration o = (SingleFieldDeclaration)other;
        return this.safeSubtreeMatch(node.getName(), o.getName()) && this.safeSubtreeMatch(node.getValue(), o.getValue());
    }

    public boolean match(StaticConstantAccess node, Object other) {
        if (!(other instanceof StaticConstantAccess)) {
            return false;
        }
        StaticConstantAccess o = (StaticConstantAccess)other;
        return this.safeSubtreeMatch(node.getClassName(), o.getClassName()) && this.safeSubtreeMatch(node.getConstant(), o.getConstant());
    }

    public boolean match(StaticFieldAccess node, Object other) {
        if (!(other instanceof StaticFieldAccess)) {
            return false;
        }
        StaticFieldAccess o = (StaticFieldAccess)other;
        return this.safeSubtreeMatch(node.getClassName(), o.getClassName()) && this.safeSubtreeMatch(node.getField(), o.getField());
    }

    public boolean match(StaticMethodInvocation node, Object other) {
        if (!(other instanceof StaticMethodInvocation)) {
            return false;
        }
        StaticMethodInvocation o = (StaticMethodInvocation)other;
        return this.safeSubtreeMatch(node.getClassName(), o.getClassName()) && this.safeSubtreeMatch(node.getMethod(), o.getMethod());
    }

    public boolean match(StaticStatement node, Object other) {
        if (!(other instanceof StaticStatement)) {
            return false;
        }
        StaticStatement o = (StaticStatement)other;
        return this.safeSubtreeListMatch(node.getExpressions(), o.getExpressions());
    }

    public boolean match(SwitchCase node, Object other) {
        if (!(other instanceof SwitchCase)) {
            return false;
        }
        SwitchCase o = (SwitchCase)other;
        return ASTMatcher.safeEquals(node.isDefault(), o.isDefault()) && this.safeSubtreeMatch(node.getValue(), o.getValue()) && this.safeSubtreeListMatch(node.getActions(), o.getActions());
    }

    public boolean match(SwitchStatement node, Object other) {
        if (!(other instanceof SwitchStatement)) {
            return false;
        }
        SwitchStatement o = (SwitchStatement)other;
        return this.safeSubtreeMatch(node.getExpr(), o.getExpr()) && this.safeSubtreeMatch(node.getStatement(), o.getStatement());
    }

    public boolean match(ThrowStatement node, Object other) {
        if (!(other instanceof ThrowStatement)) {
            return false;
        }
        ThrowStatement cfr_ignored_0 = (ThrowStatement)other;
        return false;
    }

    public boolean match(TryStatement node, Object other) {
        if (!(other instanceof TryStatement)) {
            return false;
        }
        TryStatement o = (TryStatement)other;
        return this.safeSubtreeMatch(node.getTryStatement(), o.getTryStatement()) && this.safeSubtreeListMatch(node.getCatchClauses(), o.getCatchClauses()) && this.safeSubtreeMatch(node.finallyClause(), o.finallyClause());
    }

    public boolean match(FinallyClause node, Object other) {
        if (!(other instanceof FinallyClause)) {
            return false;
        }
        FinallyClause o = (FinallyClause)other;
        return this.safeSubtreeMatch(node.getBody(), o.getBody());
    }

    public boolean match(UnaryOperation node, Object other) {
        if (!(other instanceof UnaryOperation)) {
            return false;
        }
        UnaryOperation o = (UnaryOperation)other;
        return ASTMatcher.safeEquals(node.getOperator(), o.getOperator()) && this.safeSubtreeMatch(node.getExpr(), o.getExpr());
    }

    public boolean match(Variable node, Object other) {
        if (!(other instanceof Variable)) {
            return false;
        }
        Variable o = (Variable)other;
        return this.safeSubtreeMatch(node.getVariableName(), o.getVariableName()) && ASTMatcher.safeEquals(node.isDollared(), o.isDollared());
    }

    public boolean match(WhileStatement node, Object other) {
        if (!(other instanceof WhileStatement)) {
            return false;
        }
        WhileStatement o = (WhileStatement)other;
        return this.safeSubtreeMatch(node.getCondition(), o.getCondition()) && this.safeSubtreeMatch(node.getAction(), o.getAction());
    }

    public boolean match(NamespaceDeclaration node, Object other) {
        if (!(other instanceof NamespaceDeclaration)) {
            return false;
        }
        NamespaceDeclaration o = (NamespaceDeclaration)other;
        return this.safeSubtreeMatch(node.getName(), o.getName()) && this.safeSubtreeMatch(node.getBody(), o.getBody());
    }

    public boolean match(NamespaceName node, Object other) {
        if (!(other instanceof NamespaceName)) {
            return false;
        }
        NamespaceName o = (NamespaceName)other;
        return ASTMatcher.safeEquals(node.isGlobal(), o.isGlobal()) && ASTMatcher.safeEquals(node.isCurrent(), o.isCurrent()) && this.safeSubtreeListMatch(node.segments(), o.segments());
    }

    public boolean match(UseStatementPart node, Object other) {
        if (!(other instanceof UseStatementPart)) {
            return false;
        }
        UseStatementPart o = (UseStatementPart)other;
        return this.safeSubtreeMatch(node.getName(), o.getName()) && this.safeSubtreeMatch(node.getAlias(), o.getAlias());
    }

    public boolean match(UseStatement node, Object other) {
        if (!(other instanceof UseStatement)) {
            return false;
        }
        UseStatement o = (UseStatement)other;
        return this.safeSubtreeListMatch(node.parts(), o.parts());
    }

    public boolean match(GotoLabel node, Object other) {
        if (!(other instanceof GotoLabel)) {
            return false;
        }
        GotoLabel o = (GotoLabel)other;
        return this.safeSubtreeMatch(node.getName(), o.getName());
    }

    public boolean match(GotoStatement node, Object other) {
        if (!(other instanceof GotoStatement)) {
            return false;
        }
        GotoStatement o = (GotoStatement)other;
        return this.safeSubtreeMatch(node.getLabel(), o.getLabel());
    }

    public boolean match(LambdaFunctionDeclaration node, Object other) {
        if (!(other instanceof LambdaFunctionDeclaration)) {
            return false;
        }
        LambdaFunctionDeclaration o = (LambdaFunctionDeclaration)other;
        return ASTMatcher.safeEquals(node.isReference(), o.isReference()) && ASTMatcher.safeEquals(node.isStatic(), o.isStatic()) && this.safeSubtreeMatch(node.getBody(), o.getBody()) && this.safeSubtreeListMatch(node.formalParameters(), o.formalParameters()) && this.safeSubtreeListMatch(node.lexicalVariables(), o.lexicalVariables());
    }

    public boolean match(PHPArrayDereferenceList node, Object other) {
        if (!(other instanceof PHPArrayDereferenceList)) {
            return false;
        }
        PHPArrayDereferenceList o = (PHPArrayDereferenceList)other;
        return this.safeSubtreeListMatch(node.getDereferences(), o.getDereferences());
    }

    public boolean match(DereferenceNode node, Object other) {
        if (!(other instanceof DereferenceNode)) {
            return false;
        }
        DereferenceNode o = (DereferenceNode)other;
        return this.safeSubtreeMatch(node.getName(), o.getName());
    }

    public boolean match(TraitUseStatement node, Object other) {
        if (!(other instanceof TraitUseStatement)) {
            return false;
        }
        TraitUseStatement o = (TraitUseStatement)other;
        return this.safeSubtreeListMatch(node.getTraitList(), o.getTraitList()) && this.safeSubtreeListMatch(node.getTsList(), o.getTsList());
    }

    public boolean match(TraitStatement node, Object other) {
        if (!(other instanceof TraitStatement)) {
            return false;
        }
        TraitStatement o = (TraitStatement)other;
        return this.safeSubtreeMatch(node.getExp(), o.getExp());
    }

    public boolean match(TraitPrecedence node, Object other) {
        if (!(other instanceof TraitPrecedence)) {
            return false;
        }
        TraitPrecedence o = (TraitPrecedence)other;
        return this.safeSubtreeMatch(node.getMethodReference(), o.getMethodReference()) && this.safeSubtreeListMatch(node.getTrList(), o.getTrList());
    }

    public boolean match(TraitAlias node, Object other) {
        if (!(other instanceof TraitAlias)) {
            return false;
        }
        TraitAlias o = (TraitAlias)other;
        return this.safeSubtreeMatch(node.getTraitMethod(), o.getTraitMethod()) && node.getModifier() == o.getModifier() && node.getFunctionName().equals(o.getFunctionName());
    }

    public boolean match(FullyQualifiedTraitMethodReference node, Object other) {
        if (!(other instanceof FullyQualifiedTraitMethodReference)) {
            return false;
        }
        FullyQualifiedTraitMethodReference o = (FullyQualifiedTraitMethodReference)other;
        return this.safeSubtreeMatch(node.getClassName(), o.getClassName()) && node.getFunctionName().equals(o.getFunctionName());
    }

    public boolean match(ChainingInstanceCall node, Object other) {
        if (!(other instanceof ChainingInstanceCall)) {
            return false;
        }
        ChainingInstanceCall o = (ChainingInstanceCall)other;
        return this.safeSubtreeMatch(node.getArrayDereferenceList(), o.getArrayDereferenceList()) && this.safeSubtreeMatch(node.getChainingMethodOrProperty(), o.getChainingMethodOrProperty());
    }
}

