/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java_cup.runtime.Scanner;
import java_cup.runtime.lr_parser;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTError;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.ast.nodes.BindingResolver;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ChainingInstanceCall;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.ast.nodes.DeclareStatement;
import org.eclipse.php.internal.core.ast.nodes.DereferenceNode;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.ast.nodes.EmptyStatement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FinallyClause;
import org.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.GotoLabel;
import org.eclipse.php.internal.core.ast.nodes.GotoStatement;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.IgnoreError;
import org.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.InternalASTRewrite;
import org.eclipse.php.internal.core.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.NodeEventHandler;
import org.eclipse.php.internal.core.ast.nodes.PHPArrayDereferenceList;
import org.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Quote;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitAlias;
import org.eclipse.php.internal.core.ast.nodes.TraitAliasStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.internal.core.ast.nodes.TraitPrecedence;
import org.eclipse.php.internal.core.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.nodes.YieldExpression;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.ast.scanner.php53.PhpAstLexer;
import org.eclipse.php.internal.core.ast.scanner.php54.PhpAstParser;
import org.eclipse.text.edits.TextEdit;

public class AST {
    final AstLexer lexer;
    final lr_parser parser;
    final PHPVersion apiLevel;
    final boolean useASPTags;
    private NodeEventHandler eventHandler = new NodeEventHandler();
    private long modificationCount = 0L;
    private long originalModificationCount = 0L;
    private int disableEvents = 0;
    private final Object internalASTLock = new Object();
    private int defaultNodeFlag = 0;
    InternalASTRewrite rewriter;
    private BindingResolver resolver = new BindingResolver();
    private static final Class[] AST_CLASS = new Class[]{AST.class};
    private final Object[] THIS_AST = new Object[]{this};
    static final int RESOLVED_BINDINGS = Integer.MIN_VALUE;
    private int bits;

    public AST(Reader reader, PHPVersion apiLevel, boolean aspTagsAsPhp, boolean useShortTags) throws IOException {
        this.useASPTags = aspTagsAsPhp;
        this.apiLevel = apiLevel;
        this.lexer = this.getLexerInstance(reader, apiLevel, aspTagsAsPhp, useShortTags);
        this.parser = this.getParserInstance(apiLevel, this.lexer);
    }

    private AstLexer getLexerInstance(Reader reader, PHPVersion phpVersion, boolean aspTagsAsPhp, boolean useShortTags) throws IOException {
        if (PHPVersion.PHP4 == phpVersion) {
            AstLexer lexer4 = this.getLexer4(reader);
            lexer4.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer4.setUseShortTags(useShortTags);
            return lexer4;
        }
        if (PHPVersion.PHP5 == phpVersion) {
            AstLexer lexer5 = this.getLexer5(reader);
            lexer5.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer5.setUseShortTags(useShortTags);
            return lexer5;
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            AstLexer lexer53 = this.getLexer53(reader);
            lexer53.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer53.setUseShortTags(useShortTags);
            return lexer53;
        }
        if (PHPVersion.PHP5_4 == phpVersion) {
            AstLexer lexer54 = this.getLexer54(reader);
            lexer54.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer54.setUseShortTags(useShortTags);
            return lexer54;
        }
        if (PHPVersion.PHP5_5 == phpVersion) {
            AstLexer lexer55 = this.getLexer55(reader);
            lexer55.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer55.setUseShortTags(useShortTags);
            return lexer55;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + (Object)((Object)phpVersion));
    }

    private AstLexer getLexer55(Reader reader) throws IOException {
        org.eclipse.php.internal.core.ast.scanner.php55.PhpAstLexer phpAstLexer5 = new org.eclipse.php.internal.core.ast.scanner.php55.PhpAstLexer(reader);
        phpAstLexer5.setAST(this);
        return phpAstLexer5;
    }

    private AstLexer getLexer54(Reader reader) throws IOException {
        org.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer phpAstLexer5 = new org.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer(reader);
        phpAstLexer5.setAST(this);
        return phpAstLexer5;
    }

    private AstLexer getLexer53(Reader reader) throws IOException {
        PhpAstLexer phpAstLexer5 = new PhpAstLexer(reader);
        phpAstLexer5.setAST(this);
        return phpAstLexer5;
    }

    private AstLexer getLexer5(Reader reader) throws IOException {
        org.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer phpAstLexer5 = new org.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer(reader);
        phpAstLexer5.setAST(this);
        return phpAstLexer5;
    }

    private AstLexer getLexer4(Reader reader) throws IOException {
        org.eclipse.php.internal.core.ast.scanner.php4.PhpAstLexer phpAstLexer4 = new org.eclipse.php.internal.core.ast.scanner.php4.PhpAstLexer(reader);
        phpAstLexer4.setAST(this);
        return phpAstLexer4;
    }

    private lr_parser getParserInstance(PHPVersion phpVersion, Scanner lexer) {
        if (PHPVersion.PHP4 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php4.PhpAstParser parser = new org.eclipse.php.internal.core.ast.scanner.php4.PhpAstParser(lexer);
            parser.setAST(this);
            return parser;
        }
        if (PHPVersion.PHP5 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php5.PhpAstParser parser = new org.eclipse.php.internal.core.ast.scanner.php5.PhpAstParser(lexer);
            parser.setAST(this);
            return parser;
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php53.PhpAstParser parser = new org.eclipse.php.internal.core.ast.scanner.php53.PhpAstParser(lexer);
            parser.setAST(this);
            return parser;
        }
        if (PHPVersion.PHP5_4 == phpVersion) {
            PhpAstParser parser = new PhpAstParser(lexer);
            parser.setAST(this);
            return parser;
        }
        if (PHPVersion.PHP5_5 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php55.PhpAstParser parser = new org.eclipse.php.internal.core.ast.scanner.php55.PhpAstParser(lexer);
            parser.setAST(this);
            return parser;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + (Object)((Object)phpVersion));
    }

    public long modificationCount() {
        return this.modificationCount;
    }

    void modifying() {
        if (this.disableEvents > 0) {
            return;
        }
        ++this.modificationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disableEvents() {
        Object object = this.internalASTLock;
        synchronized (object) {
            ++this.disableEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reenableEvents() {
        Object object = this.internalASTLock;
        synchronized (object) {
            --this.disableEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preRemoveChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preRemoveChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRemoveChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postRemoveChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preReplaceChildEvent(ASTNode node, ASTNode child, ASTNode newChild, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preReplaceChildEvent(node, child, newChild, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postReplaceChildEvent(ASTNode node, ASTNode child, ASTNode newChild, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postReplaceChildEvent(node, child, newChild, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preAddChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preAddChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postAddChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postAddChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preValueChangeEvent(ASTNode node, SimplePropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preValueChangeEvent(node, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postValueChangeEvent(ASTNode node, SimplePropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postValueChangeEvent(node, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preCloneNodeEvent(ASTNode node) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preCloneNodeEvent(node);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postCloneNodeEvent(ASTNode node, ASTNode clone) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postCloneNodeEvent(node, clone);
        }
        finally {
            this.reenableEvents();
        }
    }

    public BindingResolver getBindingResolver() {
        return this.resolver;
    }

    NodeEventHandler getEventHandler() {
        return this.eventHandler;
    }

    void setEventHandler(NodeEventHandler eventHandler) {
        if (this.eventHandler == null) {
            throw new IllegalArgumentException();
        }
        this.eventHandler = eventHandler;
    }

    int getDefaultNodeFlag() {
        return this.defaultNodeFlag;
    }

    void setDefaultNodeFlag(int flag) {
        this.defaultNodeFlag = flag;
    }

    void setOriginalModificationCount(long count) {
        this.originalModificationCount = count;
    }

    public ITypeBinding resolveWellKnownType(String name) {
        if (name == null) {
            return null;
        }
        return this.getBindingResolver().resolveWellKnownType(name);
    }

    void setBindingResolver(BindingResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        this.resolver = resolver;
    }

    void unsupportedIn2() {
        if (this.apiLevel == PHPVersion.PHP4) {
            throw new UnsupportedOperationException("Operation not supported in JLS2 AST");
        }
    }

    void supportedOnlyIn2() {
        if (this.apiLevel != PHPVersion.PHP4) {
            throw new UnsupportedOperationException("Operation not supported in JLS2 AST");
        }
    }

    public ASTNode createInstance(Class nodeClass) {
        if (nodeClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            Constructor c = nodeClass.getDeclaredConstructor(AST_CLASS);
            Object result = c.newInstance(this.THIS_AST);
            return (ASTNode)result;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException();
        }
    }

    public ASTNode createInstance(int nodeType) {
        Class<? extends ASTNode> nodeClass = ASTNode.nodeClassForType(nodeType);
        return this.createInstance(nodeClass);
    }

    void recordModifications(Program root) {
        if (this.modificationCount != this.originalModificationCount) {
            throw new IllegalArgumentException("AST is already modified");
        }
        if (this.rewriter != null) {
            throw new IllegalArgumentException("AST modifications are already recorded");
        }
        if ((root.getFlags() & 4) != 0) {
            throw new IllegalArgumentException("Root node is unmodifiable");
        }
        if (root.getAST() != this) {
            throw new IllegalArgumentException("Root node is not owned by this ast");
        }
        this.rewriter = new InternalASTRewrite(root);
        this.setEventHandler(this.rewriter);
    }

    TextEdit rewrite(IDocument document, Map options) {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        if (this.rewriter == null) {
            throw new IllegalStateException("Modifications record is not enabled");
        }
        return this.rewriter.rewriteAST(document, options);
    }

    public boolean hasResolvedBindings() {
        return (this.bits & Integer.MIN_VALUE) != 0;
    }

    void setFlag(int newValue) {
        this.bits |= newValue;
    }

    public AstLexer lexer() {
        return this.lexer;
    }

    public lr_parser parser() {
        return this.parser;
    }

    public PHPVersion apiLevel() {
        return this.apiLevel;
    }

    public boolean useASPTags() {
        return this.useASPTags;
    }

    public void setSource(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException();
        }
        this.lexer.yyreset(reader);
        this.lexer.resetCommentList();
        this.parser.setScanner((Scanner)this.lexer);
    }

    public ArrayAccess newArrayAccess() {
        ArrayAccess arrayAccess = new ArrayAccess(this);
        return arrayAccess;
    }

    public ArrayAccess newArrayAccess(VariableBase variableName, Expression index, int arrayType) {
        ArrayAccess arrayAccess = new ArrayAccess(this);
        arrayAccess.setName(variableName);
        arrayAccess.setIndex(index);
        arrayAccess.setArrayType(arrayType);
        return arrayAccess;
    }

    public ArrayAccess newArrayAccess(VariableBase variableName, Expression index) {
        ArrayAccess arrayAccess = new ArrayAccess(this);
        arrayAccess.setName(variableName);
        arrayAccess.setIndex(index);
        arrayAccess.setArrayType(1);
        return arrayAccess;
    }

    public ArrayCreation newArrayCreation() {
        ArrayCreation arrayCreation = new ArrayCreation(this);
        return arrayCreation;
    }

    public ArrayCreation newArrayCreation(List<ArrayElement> elements) {
        ArrayCreation arrayCreation = new ArrayCreation(this);
        arrayCreation.elements().addAll(elements);
        return arrayCreation;
    }

    public ArrayElement newArrayElement() {
        ArrayElement arrayElement = new ArrayElement(this);
        return arrayElement;
    }

    public ArrayElement newArrayElement(Expression key, Expression value) {
        ArrayElement arrayElement = new ArrayElement(this);
        arrayElement.setKey(key);
        arrayElement.setValue(value);
        return arrayElement;
    }

    public Assignment newAssignment() {
        Assignment assignment = new Assignment(this);
        return assignment;
    }

    public Assignment newAssignment(VariableBase leftHandSide, int operator, Expression rightHandSide) {
        Assignment assignment = new Assignment(this);
        assignment.setLeftHandSide(leftHandSide);
        assignment.setOperator(operator);
        assignment.setRightHandSide(rightHandSide);
        return assignment;
    }

    public ASTError newASTError() {
        ASTError astError = new ASTError(this);
        return astError;
    }

    public BackTickExpression newBackTickExpression() {
        BackTickExpression backTickExpression = new BackTickExpression(this);
        return backTickExpression;
    }

    public BackTickExpression newBackTickExpression(List<Expression> expressions) {
        BackTickExpression backTickExpression = new BackTickExpression(this);
        backTickExpression.expressions().addAll(expressions);
        return backTickExpression;
    }

    public Block newBlock() {
        Block block = new Block(this);
        block.setIsCurly(true);
        return block;
    }

    public Block newBlock(List<Statement> statements) {
        Block block = new Block(this);
        block.statements().addAll(statements);
        block.setIsCurly(true);
        return block;
    }

    public BreakStatement newBreakStatement() {
        BreakStatement breakStatement = new BreakStatement(this);
        return breakStatement;
    }

    public BreakStatement newBreakStatement(Expression expression) {
        BreakStatement breakStatement = new BreakStatement(this);
        breakStatement.setExpression(expression);
        return breakStatement;
    }

    public CastExpression newCastExpression() {
        CastExpression castExpression = new CastExpression(this);
        return castExpression;
    }

    public CastExpression newCastExpression(Expression expression, int castType) {
        CastExpression castExpression = new CastExpression(this);
        castExpression.setExpression(expression);
        castExpression.setCastingType(castType);
        return castExpression;
    }

    public CatchClause newCatchClause() {
        CatchClause catchClause = new CatchClause(this);
        return catchClause;
    }

    public CatchClause newCatchClause(Identifier className, Variable variable, Block statement) {
        CatchClause catchClause = new CatchClause(this);
        catchClause.setClassName(className);
        catchClause.setVariable(variable);
        catchClause.setBody(statement);
        return catchClause;
    }

    public FinallyClause newFinallyClause() {
        FinallyClause finallyClause = new FinallyClause(this);
        return finallyClause;
    }

    public FinallyClause newFinallyClause(Block statement) {
        FinallyClause finallyClause = new FinallyClause(this);
        finallyClause.setBody(statement);
        return finallyClause;
    }

    public ConstantDeclaration newClassConstantDeclaration() {
        ConstantDeclaration classConstantDeclaration = new ConstantDeclaration(this);
        return classConstantDeclaration;
    }

    public ConstantDeclaration newClassConstantDeclaration(List<Identifier> names, List<Expression> initializers) {
        ConstantDeclaration classConstantDeclaration = new ConstantDeclaration(this);
        classConstantDeclaration.initializers().addAll(initializers);
        classConstantDeclaration.names().addAll(names);
        return classConstantDeclaration;
    }

    public ClassDeclaration newClassDeclaration() {
        ClassDeclaration classDeclaration = new ClassDeclaration(this);
        return classDeclaration;
    }

    public ClassDeclaration newClassDeclaration(int modifier, String className, String superClass, List<Identifier> interfaces, Block body) {
        ClassDeclaration classDeclaration = new ClassDeclaration(this);
        classDeclaration.setModifier(modifier);
        classDeclaration.setName(this.newIdentifier(className));
        if (superClass != null) {
            classDeclaration.setSuperClass(this.newIdentifier(superClass));
        } else {
            classDeclaration.setSuperClass(null);
        }
        classDeclaration.interfaces().addAll(interfaces);
        classDeclaration.setBody(body);
        return classDeclaration;
    }

    public ClassInstanceCreation newClassInstanceCreation() {
        ClassInstanceCreation classInstanceCreation = new ClassInstanceCreation(this);
        return classInstanceCreation;
    }

    public ClassInstanceCreation newClassInstanceCreation(ClassName className, List<Expression> ctorParams) {
        ClassInstanceCreation classInstanceCreation = new ClassInstanceCreation(this);
        classInstanceCreation.setClassName(className);
        classInstanceCreation.ctorParams().addAll(ctorParams);
        return classInstanceCreation;
    }

    public ClassName newClassName() {
        ClassName className = new ClassName(this);
        return className;
    }

    public ClassName newClassName(Expression name) {
        ClassName className = new ClassName(this);
        className.setClassName(name);
        return className;
    }

    public CloneExpression newCloneExpression() {
        CloneExpression cloneExpression = new CloneExpression(this);
        return cloneExpression;
    }

    public CloneExpression newCloneExpression(Expression expr) {
        CloneExpression cloneExpression = new CloneExpression(this);
        cloneExpression.setExpression(expr);
        return cloneExpression;
    }

    public Comment newComment() {
        Comment comment = new Comment(this);
        return comment;
    }

    public Comment newComment(int commentType) {
        Comment comment = new Comment(this);
        comment.setCommentType(commentType);
        return comment;
    }

    public ConditionalExpression newConditionalExpression() {
        ConditionalExpression conditionalExpression = new ConditionalExpression(this);
        return conditionalExpression;
    }

    public ConditionalExpression newConditionalExpression(Expression condition, Expression ifTrue, Expression ifFalse) {
        ConditionalExpression conditionalExpression = new ConditionalExpression(this);
        conditionalExpression.setCondition(condition);
        conditionalExpression.setIfTrue(ifTrue);
        conditionalExpression.setIfFalse(ifFalse);
        return conditionalExpression;
    }

    public ContinueStatement newContinueStatement() {
        ContinueStatement continueStatement = new ContinueStatement(this);
        return continueStatement;
    }

    public ContinueStatement newContinueStatement(Expression expr) {
        ContinueStatement continueStatement = new ContinueStatement(this);
        continueStatement.setExpression(expr);
        return continueStatement;
    }

    public DeclareStatement newDeclareStatement(List<Identifier> directiveNames, List<Expression> directiveValues, Statement body) {
        DeclareStatement declareStatement = new DeclareStatement(this);
        declareStatement.directiveNames().addAll(directiveNames);
        declareStatement.directiveValues().addAll(directiveValues);
        declareStatement.setBody(body);
        return declareStatement;
    }

    public DoStatement newDoStatement() {
        DoStatement doStatement = new DoStatement(this);
        return doStatement;
    }

    public DoStatement newDoStatement(Expression condition, Statement body) {
        DoStatement doStatement = new DoStatement(this);
        doStatement.setCondition(condition);
        doStatement.setBody(body);
        return doStatement;
    }

    public EchoStatement newEchoStatement() {
        EchoStatement echoStatement = new EchoStatement(this);
        return echoStatement;
    }

    public EchoStatement newEchoStatement(List<Expression> expressions) {
        EchoStatement echoStatement = new EchoStatement(this);
        echoStatement.expressions().addAll(expressions);
        return echoStatement;
    }

    public EchoStatement newEchoStatement(Expression expression) {
        EchoStatement echoStatement = new EchoStatement(this);
        echoStatement.expressions().add(expression);
        return echoStatement;
    }

    public EmptyStatement newEmptyStatement() {
        EmptyStatement emptyStatement = new EmptyStatement(this);
        return emptyStatement;
    }

    public ExpressionStatement newExpressionStatement() {
        ExpressionStatement expressionStatement = new ExpressionStatement(this);
        return expressionStatement;
    }

    public ExpressionStatement newExpressionStatement(Expression expression) {
        ExpressionStatement statement = this.newExpressionStatement();
        statement.setExpression(expression);
        return statement;
    }

    public FieldAccess newFieldAccess() {
        FieldAccess fieldAccess = new FieldAccess(this);
        return fieldAccess;
    }

    public FieldAccess newFieldAccess(VariableBase dispatcher, Variable field) {
        FieldAccess fieldAccess = new FieldAccess(this);
        fieldAccess.setDispatcher(dispatcher);
        fieldAccess.setField(field);
        return fieldAccess;
    }

    public FieldsDeclaration newFieldsDeclaration() {
        FieldsDeclaration fieldsDeclaration = new FieldsDeclaration(this);
        return fieldsDeclaration;
    }

    public FieldsDeclaration newFieldsDeclaration(int modifier, List<SingleFieldDeclaration> variablesAndDefaults) {
        FieldsDeclaration fieldsDeclaration = new FieldsDeclaration(this);
        fieldsDeclaration.setModifier(modifier);
        List<SingleFieldDeclaration> fields = fieldsDeclaration.fields();
        fields.addAll(variablesAndDefaults);
        return fieldsDeclaration;
    }

    public ForEachStatement newForEachStatement() {
        ForEachStatement forEachStatement = new ForEachStatement(this);
        return forEachStatement;
    }

    public ForEachStatement newForEachStatement(Expression expression, Expression key, Expression value, Statement statement) {
        ForEachStatement forEachStatement = new ForEachStatement(this);
        forEachStatement.setExpression(expression);
        forEachStatement.setKey(key);
        forEachStatement.setValue(value);
        forEachStatement.setStatement(statement);
        return forEachStatement;
    }

    public FormalParameter newFormalParameter() {
        FormalParameter formalParameter = new FormalParameter(this);
        return formalParameter;
    }

    public FormalParameter newFormalParameter(Identifier type, Expression parameterName, Expression defaultValue, boolean isMandatory) {
        FormalParameter formalParameter = new FormalParameter(this);
        formalParameter.setParameterType(type);
        formalParameter.setParameterName(parameterName);
        formalParameter.setDefaultValue(defaultValue);
        if (this.apiLevel() == PHPVersion.PHP4) {
            formalParameter.setIsMandatory(isMandatory);
        }
        return formalParameter;
    }

    public ForStatement newForStatement() {
        ForStatement forStatement = new ForStatement(this);
        return forStatement;
    }

    public ForStatement newForStatement(List<Expression> initializers, List<Expression> conditions, List<Expression> updaters, Statement body) {
        ForStatement forStatement = new ForStatement(this);
        forStatement.initializers().addAll(initializers);
        forStatement.updaters().addAll(updaters);
        forStatement.conditions().addAll(conditions);
        forStatement.setBody(body);
        return forStatement;
    }

    public FunctionDeclaration newFunctionDeclaration() {
        FunctionDeclaration functionDeclaration = new FunctionDeclaration(this);
        return functionDeclaration;
    }

    public FunctionDeclaration newFunctionDeclaration(Identifier functionName, List<FormalParameter> formalParameters, Block body, boolean isReference) {
        FunctionDeclaration functionDeclaration = new FunctionDeclaration(this);
        functionDeclaration.setFunctionName(functionName);
        functionDeclaration.formalParameters().addAll(formalParameters);
        functionDeclaration.setBody(body);
        functionDeclaration.setIsReference(isReference);
        return functionDeclaration;
    }

    public FunctionInvocation newFunctionInvocation() {
        FunctionInvocation functionInvocation = new FunctionInvocation(this);
        return functionInvocation;
    }

    public FunctionInvocation newFunctionInvocation(FunctionName functionName, List<Expression> parameters) {
        FunctionInvocation functionInvocation = new FunctionInvocation(this);
        functionInvocation.setFunctionName(functionName);
        if (parameters != null) {
            functionInvocation.parameters().addAll(parameters);
        }
        return functionInvocation;
    }

    public FunctionName newFunctionName() {
        FunctionName functionName = new FunctionName(this);
        return functionName;
    }

    public FunctionName newFunctionName(Expression name) {
        FunctionName functionName = new FunctionName(this);
        functionName.setName(name);
        return functionName;
    }

    public GlobalStatement newGlobalStatement() {
        GlobalStatement globalStatement = new GlobalStatement(this);
        return globalStatement;
    }

    public GlobalStatement newGlobalStatement(List<Variable> variables) {
        GlobalStatement globalStatement = new GlobalStatement(this);
        globalStatement.variables().addAll(variables);
        return globalStatement;
    }

    public Identifier newIdentifier() {
        Identifier identifier = new Identifier(this);
        return identifier;
    }

    public Identifier newIdentifier(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException();
        }
        Identifier result = new Identifier(this);
        result.setName(identifier);
        return result;
    }

    public IfStatement newIfStatement() {
        IfStatement ifStatement = new IfStatement(this);
        return ifStatement;
    }

    public IfStatement newIfStatement(Expression condition, Statement trueStatement, Statement falseStatement) {
        IfStatement ifStatement = new IfStatement(this);
        ifStatement.setCondition(condition);
        ifStatement.setTrueStatement(trueStatement);
        ifStatement.setFalseStatement(falseStatement);
        return ifStatement;
    }

    public IgnoreError newIgnoreError() {
        IgnoreError ignoreError = new IgnoreError(this);
        return ignoreError;
    }

    public IgnoreError newIgnoreError(Expression expression) {
        IgnoreError ignoreError = new IgnoreError(this);
        ignoreError.setExpression(expression);
        return ignoreError;
    }

    public Include newInclude() {
        Include include = new Include(this);
        return include;
    }

    public Include newInclude(Expression expr, int type) {
        Include include = new Include(this);
        include.setExpression(expr);
        include.setIncludetype(type);
        return include;
    }

    public InfixExpression newInfixExpression() {
        InfixExpression infixExpression = new InfixExpression(this);
        return infixExpression;
    }

    public InfixExpression newInfixExpression(Expression left, int operator, Expression right) {
        InfixExpression infixExpression = new InfixExpression(this);
        infixExpression.setLeft(left);
        infixExpression.setOperator(operator);
        infixExpression.setRight(right);
        return infixExpression;
    }

    public InLineHtml newInLineHtml() {
        InLineHtml inLineHtml = new InLineHtml(this);
        return inLineHtml;
    }

    public InstanceOfExpression newInstanceOfExpression() {
        InstanceOfExpression instanceOfExpression = new InstanceOfExpression(this);
        return instanceOfExpression;
    }

    public InstanceOfExpression newInstanceOfExpression(Expression expr, ClassName className) {
        InstanceOfExpression instanceOfExpression = new InstanceOfExpression(this);
        instanceOfExpression.setClassName(className);
        instanceOfExpression.setExpression(expr);
        return instanceOfExpression;
    }

    public InterfaceDeclaration newInterfaceDeclaration() {
        InterfaceDeclaration interfaceDeclaration = new InterfaceDeclaration(this);
        return interfaceDeclaration;
    }

    public InterfaceDeclaration newInterfaceDeclaration(Identifier interfaceName, List<Identifier> interfaces, Block body) {
        InterfaceDeclaration interfaceDeclaration = new InterfaceDeclaration(this);
        interfaceDeclaration.setName(interfaceName);
        interfaceDeclaration.interfaces().addAll(interfaces);
        interfaceDeclaration.setBody(body);
        return interfaceDeclaration;
    }

    public ListVariable newListVariable() {
        ListVariable listVariable = new ListVariable(this);
        return listVariable;
    }

    public ListVariable newListVariable(List<VariableBase> variables) {
        ListVariable listVariable = new ListVariable(this);
        listVariable.variables().addAll(variables);
        return listVariable;
    }

    public MethodDeclaration newMethodDeclaration() {
        MethodDeclaration methodDeclaration = new MethodDeclaration(this);
        return methodDeclaration;
    }

    public MethodDeclaration newMethodDeclaration(int modifier, FunctionDeclaration function) {
        MethodDeclaration methodDeclaration = new MethodDeclaration(this);
        methodDeclaration.setModifier(modifier);
        methodDeclaration.setFunction(function);
        return methodDeclaration;
    }

    public MethodInvocation newMethodInvocation() {
        MethodInvocation methodInvocation = new MethodInvocation(this);
        return methodInvocation;
    }

    public MethodInvocation newMethodInvocation(VariableBase dispatcher, FunctionInvocation method) {
        MethodInvocation methodInvocation = new MethodInvocation(this);
        methodInvocation.setDispatcher(dispatcher);
        methodInvocation.setMethod(method);
        return methodInvocation;
    }

    public ParenthesisExpression newParenthesisExpression() {
        ParenthesisExpression parenthesisExpression = new ParenthesisExpression(this);
        return parenthesisExpression;
    }

    public ParenthesisExpression newParenthesisExpression(Expression expression) {
        ParenthesisExpression parenthesisExpression = new ParenthesisExpression(this);
        parenthesisExpression.setExpression(expression);
        return parenthesisExpression;
    }

    public PostfixExpression newPostfixExpression() {
        PostfixExpression postfixExpression = new PostfixExpression(this);
        return postfixExpression;
    }

    public PostfixExpression newPostfixExpression(VariableBase variable, int operator) {
        PostfixExpression postfixExpression = new PostfixExpression(this);
        postfixExpression.setVariable(variable);
        postfixExpression.setOperator(operator);
        return postfixExpression;
    }

    public PrefixExpression newPrefixExpression() {
        PrefixExpression prefixExpression = new PrefixExpression(this);
        return prefixExpression;
    }

    public PrefixExpression newPrefixExpression(VariableBase variable, int operator) {
        PrefixExpression prefixExpression = new PrefixExpression(this);
        prefixExpression.setVariable(variable);
        prefixExpression.setOperator(operator);
        return prefixExpression;
    }

    public Program newProgram() {
        Program program = new Program(this);
        return program;
    }

    public Program newProgram(List<Statement> statements, List<Comment> commentList) {
        Program program = new Program(this);
        program.statements().addAll(statements);
        program.comments().addAll(commentList);
        return program;
    }

    public Quote newQuote() {
        Quote quote = new Quote(this);
        return quote;
    }

    public Quote newQuote(List<Expression> expressions, int type) {
        Quote quote = new Quote(this);
        quote.expressions().addAll(expressions);
        quote.setQuoteType(type);
        return quote;
    }

    public Reference newReference() {
        Reference reference = new Reference(this);
        return reference;
    }

    public Reference newReference(Expression expression) {
        Reference reference = new Reference(this);
        reference.setExpression(expression);
        return reference;
    }

    public ReflectionVariable newReflectionVariable() {
        ReflectionVariable reflectionVariable = new ReflectionVariable(this);
        return reflectionVariable;
    }

    public ReflectionVariable newReflectionVariable(Expression expression) {
        ReflectionVariable reflectionVariable = new ReflectionVariable(this);
        reflectionVariable.setName(expression);
        return reflectionVariable;
    }

    public ReturnStatement newReturnStatement() {
        ReturnStatement returnStatement = new ReturnStatement(this);
        return returnStatement;
    }

    public ReturnStatement newReturnStatement(Expression expression) {
        ReturnStatement returnStatement = new ReturnStatement(this);
        returnStatement.setExpression(expression);
        return returnStatement;
    }

    public YieldExpression newYieldExpression() {
        YieldExpression YieldExpression2 = new YieldExpression(this);
        return YieldExpression2;
    }

    public YieldExpression newYieldExpression(Expression expression) {
        YieldExpression YieldExpression2 = new YieldExpression(this);
        YieldExpression2.setExpression(expression);
        return YieldExpression2;
    }

    public YieldExpression newYieldExpression(Expression key, Expression expression) {
        YieldExpression YieldExpression2 = new YieldExpression(this);
        YieldExpression2.setKey(key);
        YieldExpression2.setExpression(expression);
        return YieldExpression2;
    }

    public Scalar newScalar() {
        Scalar scalar = new Scalar(this);
        return scalar;
    }

    public Scalar newScalar(String string, int scalarType) {
        Scalar scalar = this.newScalar(string);
        scalar.setScalarType(scalarType);
        return scalar;
    }

    public Scalar newScalar(String string) {
        Scalar scalar = new Scalar(this);
        scalar.setStringValue(string);
        return scalar;
    }

    public SingleFieldDeclaration newSingleFieldDeclaration() {
        SingleFieldDeclaration singleFieldDeclaration = new SingleFieldDeclaration(this);
        return singleFieldDeclaration;
    }

    public SingleFieldDeclaration newSingleFieldDeclaration(Variable name, Expression value) {
        SingleFieldDeclaration singleFieldDeclaration = new SingleFieldDeclaration(this);
        singleFieldDeclaration.setName(name);
        singleFieldDeclaration.setValue(value);
        return singleFieldDeclaration;
    }

    public StaticConstantAccess newStaticConstantAccess() {
        StaticConstantAccess staticConstantAccess = new StaticConstantAccess(this);
        return staticConstantAccess;
    }

    public StaticConstantAccess newStaticConstantAccess(Identifier className, Identifier constant) {
        StaticConstantAccess staticConstantAccess = new StaticConstantAccess(this);
        staticConstantAccess.setClassName(className);
        staticConstantAccess.setConstant(constant);
        return staticConstantAccess;
    }

    public StaticFieldAccess newStaticFieldAccess() {
        StaticFieldAccess staticFieldAccess = new StaticFieldAccess(this);
        return staticFieldAccess;
    }

    public StaticFieldAccess newStaticFieldAccess(Identifier className, Variable field) {
        StaticFieldAccess staticFieldAccess = new StaticFieldAccess(this);
        staticFieldAccess.setClassName(className);
        staticFieldAccess.setField(field);
        return staticFieldAccess;
    }

    public StaticMethodInvocation newStaticMethodInvocation() {
        StaticMethodInvocation staticMethodInvocation = new StaticMethodInvocation(this);
        return staticMethodInvocation;
    }

    public StaticMethodInvocation newStaticMethodInvocation(Identifier className, FunctionInvocation method) {
        StaticMethodInvocation staticMethodInvocation = new StaticMethodInvocation(this);
        staticMethodInvocation.setClassName(className);
        staticMethodInvocation.setMethod(method);
        return staticMethodInvocation;
    }

    public StaticStatement newStaticStatement() {
        StaticStatement staticStatement = new StaticStatement(this);
        return staticStatement;
    }

    public StaticStatement newStaticStatement(List<Expression> expressions) {
        StaticStatement staticStatement = new StaticStatement(this);
        staticStatement.expressions().addAll(expressions);
        return staticStatement;
    }

    public SwitchCase newSwitchCase() {
        SwitchCase switchCase = new SwitchCase(this);
        return switchCase;
    }

    public SwitchCase newSwitchCase(Expression value, List<Statement> actions2, boolean isDefault) {
        SwitchCase switchCase = new SwitchCase(this);
        switchCase.setValue(value);
        switchCase.actions().addAll(actions2);
        switchCase.setIsDefault(isDefault);
        return switchCase;
    }

    public SwitchStatement newSwitchStatement() {
        SwitchStatement switchStatement = new SwitchStatement(this);
        return switchStatement;
    }

    public SwitchStatement newSwitchStatement(Expression expression, Block body) {
        SwitchStatement switchStatement = new SwitchStatement(this);
        switchStatement.setExpression(expression);
        switchStatement.setBody(body);
        return switchStatement;
    }

    public ThrowStatement newThrowStatement() {
        ThrowStatement throwStatement = new ThrowStatement(this);
        return throwStatement;
    }

    public ThrowStatement newThrowStatement(Expression expression) {
        ThrowStatement throwStatement = new ThrowStatement(this);
        throwStatement.setExpression(expression);
        return throwStatement;
    }

    public TryStatement newTryStatement() {
        TryStatement tryStatement = new TryStatement(this);
        return tryStatement;
    }

    public TryStatement newTryStatement(Block block, List<CatchClause> catchClauses) {
        TryStatement tryStatement = new TryStatement(this);
        tryStatement.setBody(block);
        tryStatement.catchClauses().addAll(catchClauses);
        return tryStatement;
    }

    public UnaryOperation newUnaryOperation() {
        UnaryOperation unaryOperation = new UnaryOperation(this);
        return unaryOperation;
    }

    public UnaryOperation newUnaryOperation(Expression expression, int operator) {
        UnaryOperation unaryOperation = new UnaryOperation(this);
        unaryOperation.setExpression(expression);
        unaryOperation.setOperator(operator);
        return unaryOperation;
    }

    public Variable newVariable() {
        Variable variable = new Variable(this);
        return variable;
    }

    public Variable newVariable(Expression name, boolean isDollared) {
        Variable variable = this.newVariable();
        variable.setIsDollared(isDollared);
        variable.setName(name);
        return variable;
    }

    public Variable newVariable(String name) {
        Variable variable = this.newVariable();
        variable.setIsDollared(true);
        variable.setName(this.newIdentifier(name));
        return variable;
    }

    public WhileStatement newWhileStatement() {
        WhileStatement whileStatement = new WhileStatement(this);
        return whileStatement;
    }

    public WhileStatement newWhileStatement(Expression condition, Statement body) {
        WhileStatement whileStatement = new WhileStatement(this);
        whileStatement.setCondition(condition);
        whileStatement.setBody(body);
        return whileStatement;
    }

    public NamespaceName newNamespaceName(Collection<Identifier> segments, boolean isglobal, boolean iscurrent) {
        NamespaceName namespaceName = new NamespaceName(this);
        namespaceName.segments().addAll(segments);
        namespaceName.setGlobal(isglobal);
        namespaceName.setCurrent(iscurrent);
        return namespaceName;
    }

    public NamespaceDeclaration newNamespaceDeclaration(NamespaceName name, Block body) {
        NamespaceDeclaration namespaceDeclaration = new NamespaceDeclaration(this);
        namespaceDeclaration.setName(name);
        namespaceDeclaration.setBody(body);
        return namespaceDeclaration;
    }

    public UseStatementPart newUseStatementPart(NamespaceName name, Identifier alias) {
        UseStatementPart usePart = new UseStatementPart(this);
        usePart.setName(name);
        usePart.setAlias(alias);
        return usePart;
    }

    public UseStatement newUseStatement(Collection<UseStatementPart> parts) {
        UseStatement useStatement = new UseStatement(this);
        useStatement.parts().addAll(parts);
        return useStatement;
    }

    public GotoLabel newGotoLabel(Identifier label) {
        GotoLabel gotoLabel = new GotoLabel(this);
        gotoLabel.setName(label);
        return gotoLabel;
    }

    public GotoStatement newGotoStatement(Identifier label) {
        GotoStatement gotoStatement = new GotoStatement(this);
        gotoStatement.setLabel(label);
        return gotoStatement;
    }

    public LambdaFunctionDeclaration newLambdaFunctionDeclaration(Collection<FormalParameter> formalParameters, Collection<Variable> lexicalVars, Block body, boolean isReference, boolean isStatic) {
        LambdaFunctionDeclaration lfDeclaration = new LambdaFunctionDeclaration(this);
        lfDeclaration.setBody(body);
        lfDeclaration.setIsReference(isReference);
        lfDeclaration.setStatic(isStatic);
        lfDeclaration.formalParameters().addAll(formalParameters);
        lfDeclaration.lexicalVariables().addAll(lexicalVars);
        return lfDeclaration;
    }

    public ChainingInstanceCall newChainingInstanceCall(PHPArrayDereferenceList arrayDereferenceList, List<VariableBase> chainingMethodOrProperty) {
        ChainingInstanceCall lfDeclaration = new ChainingInstanceCall(this, arrayDereferenceList, chainingMethodOrProperty);
        return lfDeclaration;
    }

    public DereferenceNode newDereferenceNode(Expression indexName) {
        DereferenceNode lfDeclaration = new DereferenceNode(this);
        lfDeclaration.setName(indexName);
        return lfDeclaration;
    }

    public FullyQualifiedTraitMethodReference newFullyQualifiedTraitMethodReference(NamespaceName className, Identifier functionName) {
        FullyQualifiedTraitMethodReference lfDeclaration = new FullyQualifiedTraitMethodReference(this);
        lfDeclaration.setClassName(className);
        lfDeclaration.setFunctionName(functionName);
        return lfDeclaration;
    }

    public PHPArrayDereferenceList newPHPArrayDereferenceList(List<DereferenceNode> dereferences) {
        PHPArrayDereferenceList lfDeclaration = new PHPArrayDereferenceList(this, dereferences);
        return lfDeclaration;
    }

    public TraitAlias newTraitAlias(Expression traitMethod, int modifier, Identifier functionName) {
        TraitAlias lfDeclaration = new TraitAlias(this);
        lfDeclaration.setModifier(modifier);
        lfDeclaration.setTraitMethod(traitMethod);
        lfDeclaration.setFunctionName(functionName);
        return lfDeclaration;
    }

    public TraitAliasStatement newTraitAliasStatement(TraitAlias alias) {
        TraitAliasStatement lfDeclaration = new TraitAliasStatement(this);
        lfDeclaration.setAlias(alias);
        return lfDeclaration;
    }

    public TraitDeclaration newTraitDeclaration() {
        TraitDeclaration lfDeclaration = new TraitDeclaration(this);
        return lfDeclaration;
    }

    public TraitDeclaration newTraitDeclaration(int modifier, String className, String superClass, List<Identifier> interfaces, Block body) {
        TraitDeclaration traitDeclaration = new TraitDeclaration(this);
        traitDeclaration.setModifier(modifier);
        traitDeclaration.setName(this.newIdentifier(className));
        if (superClass != null) {
            traitDeclaration.setSuperClass(this.newIdentifier(superClass));
        } else {
            traitDeclaration.setSuperClass(null);
        }
        traitDeclaration.interfaces().addAll(interfaces);
        traitDeclaration.setBody(body);
        return traitDeclaration;
    }

    public TraitPrecedence newTraitPrecedence(FullyQualifiedTraitMethodReference methodReference, List<NamespaceName> trList) {
        TraitPrecedence lfDeclaration = new TraitPrecedence(this);
        lfDeclaration.setMethodReference(methodReference);
        lfDeclaration.setTrList(trList);
        return lfDeclaration;
    }

    public TraitPrecedenceStatement newTraitPrecedenceStatement(TraitPrecedence precedence) {
        TraitPrecedenceStatement lfDeclaration = new TraitPrecedenceStatement(this);
        lfDeclaration.setPrecedence(precedence);
        return lfDeclaration;
    }

    public TraitUseStatement newTraitUseStatement(List<NamespaceName> traitList, List<TraitStatement> tsList) {
        TraitUseStatement lfDeclaration = new TraitUseStatement(this);
        lfDeclaration.setTraitList(traitList);
        lfDeclaration.setTsList(tsList);
        return lfDeclaration;
    }

    public void setInsertUseStatement(boolean isInsertUseStatement) {
        this.rewriter.setInsertUseStatement(isInsertUseStatement);
    }
}

