/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.phar.IStub;
import org.eclipse.php.internal.core.phar.PharConstants;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.core.phar.PharUtil;

public class Stub
implements IStub {
    private PharPackage jarPackage;

    public Stub(PharPackage jarPackage) {
        this.jarPackage = jarPackage;
    }

    @Override
    public void write(OutputStream os) throws CoreException, IOException {
        if (this.jarPackage.isStubGenerated()) {
            os.write(PharConstants.PHP_START);
            os.write(PharConstants.Line_Seperator);
            os.write(PharConstants.STUB_ENDS);
            os.write(PharConstants.STUB_TAIL);
            os.write(PharConstants.Line_Seperator);
        } else {
            InputStream contentStream = this.getStubInputStream();
            try {
                PharUtil.checkStubVilidaty(contentStream);
            }
            finally {
                if (contentStream != null) {
                    contentStream.close();
                }
            }
            contentStream = this.getStubInputStream();
            try {
                int n;
                byte[] readBuffer = new byte[4096];
                while ((n = contentStream.read(readBuffer)) > 0) {
                    os.write(readBuffer, 0, n);
                }
            }
            finally {
                if (contentStream != null) {
                    contentStream.close();
                }
            }
        }
    }

    private InputStream getStubInputStream() throws CoreException, FileNotFoundException {
        InputStream contentStream = null;
        IFile stubFile = this.jarPackage.getStubFile();
        contentStream = stubFile.exists() ? stubFile.getContents(false) : new BufferedInputStream(new FileInputStream(this.jarPackage.getStubLocation().toFile()));
        return contentStream;
    }
}

