/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.ui.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.core.data.RegexImpl;
import org.eclipse.ptp.internal.rm.jaxb.control.core.exceptions.UnsatisfiedMatchException;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.JAXBControlUIConstants;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.FileMatchType;
import org.eclipse.ptp.rm.jaxb.core.data.RangeType;
import org.eclipse.ptp.rm.jaxb.core.data.RegexType;
import org.eclipse.ptp.rm.jaxb.core.data.ValidatorType;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class WidgetActionUtils {
    public static String browseWorkspace(Shell shell) {
        IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        FileDialog dialog = new FileDialog(shell);
        dialog.setFilterPath(path.toFile().getAbsolutePath());
        return dialog.open();
    }

    public static void errorMessage(Shell shell, Throwable throwable, String message, String title, boolean causeTrace) {
        String append = throwable == null ? "" : throwable.getMessage();
        Throwable t = throwable == null ? null : throwable.getCause();
        String lineSep = JAXBControlUIConstants.LINE_SEP;
        if (causeTrace) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (t != null) {
                t.printStackTrace(pw);
                append = sw.toString();
            }
        } else if (t != null) {
            append = t.getMessage();
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)(String.valueOf(message) + lineSep + lineSep + append));
    }

    public static String[] getItemsFrom(IVariableMap map, String itemsFrom) {
        if (itemsFrom == null) {
            return new String[0];
        }
        AttributeType data = map.get(itemsFrom);
        if (data == null) {
            return new String[0];
        }
        Collection values = null;
        Object value = data.getValue();
        if (value instanceof Collection) {
            values = (Collection)value;
        }
        if (values != null) {
            return values.toArray(new String[0]);
        }
        return new String[0];
    }

    public static String getSelected(Combo combo) {
        if (combo.isDisposed()) {
            return "";
        }
        if (combo.getItemCount() == 0) {
            return combo.getText();
        }
        int i = combo.getSelectionIndex();
        if (i < 0) {
            return combo.getText();
        }
        return combo.getItem(i);
    }

    public static String openInputDialog(Shell shell, String message, String title, String initial) {
        InputDialog nameDialog = new InputDialog(shell, message, title, initial, null);
        if (nameDialog.open() != 1) {
            return nameDialog.getValue();
        }
        return null;
    }

    public static String select(Combo combo, String text) {
        if (combo.isDisposed()) {
            return "";
        }
        int style = combo.getStyle();
        boolean readOnly = style == (style | 8);
        String[] items = combo.getItems();
        if (items.length == 0) {
            return "";
        }
        int i = 0;
        if (text == null) {
            text = "";
        }
        while (i < items.length) {
            if (items[i].equals(text)) {
                combo.select(i);
                break;
            }
            ++i;
        }
        if (i == items.length) {
            if (readOnly) {
                return "";
            }
            ArrayList<String> newItems = new ArrayList<String>();
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                newItems.add(item.trim());
                ++n2;
            }
            newItems.add(text.trim());
            combo.setItems(newItems.toArray(new String[0]));
            i = newItems.size() - 1;
        }
        combo.select(i);
        return combo.getItem(i);
    }

    public static void validate(String value, ValidatorType validator, IRemoteFileManager fileManager) throws Exception {
        block10: {
            RegexType reg = validator.getRegex();
            FileMatchType match = validator.getFileInfo();
            List ranges = validator.getRange();
            String error = validator.getErrorMessage();
            if (error == null) {
                error = "";
            }
            if (reg != null && new RegexImpl(reg, null, null).getMatched(value) == null) {
                throw new UnsatisfiedMatchException(String.valueOf(error) + ":" + " " + reg.getExpression() + "," + " " + value);
            }
            if (match != null) {
                try {
                    if (match != null && !WidgetActionUtils.validate(match, value, fileManager)) {
                        throw new UnsatisfiedMatchException(String.valueOf(error) + ":" + " " + value);
                    }
                    break block10;
                }
                catch (CoreException ce) {
                    throw new UnsatisfiedMatchException((Throwable)ce);
                }
            }
            if (!ranges.isEmpty()) {
                try {
                    double dVal = Double.valueOf(value);
                    for (RangeType r : ranges) {
                        if (!WidgetActionUtils.validate(dVal, r)) continue;
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    throw new UnsatisfiedMatchException((Throwable)e);
                }
                throw new UnsatisfiedMatchException(String.valueOf(error) + ":" + " " + value);
            }
        }
    }

    private static int getEfsAttributeValue(String efsAttrStr) {
        String[] split;
        int attributes = 0;
        String[] stringArray = split = efsAttrStr.split("[|]");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ("ATTRIBUTE_READ_ONLY".equals(s = s.trim())) {
                attributes |= 2;
            } else if ("ATTRIBUTE_IMMUTABLE".equals(s)) {
                attributes |= 0x200000;
            } else if ("ATTRIBUTE_OWNER_READ".equals(s)) {
                attributes |= 0x400000;
            } else if ("ATTRIBUTE_OWNER_WRITE".equals(s)) {
                attributes |= 0x800000;
            } else if ("ATTRIBUTE_OWNER_EXECUTE".equals(s)) {
                attributes |= 0x1000000;
            } else if ("ATTRIBUTE_GROUP_READ".equals(s)) {
                attributes |= 0x2000000;
            } else if ("ATTRIBUTE_GROUP_WRITE".equals(s)) {
                attributes |= 0x4000000;
            } else if ("ATTRIBUTE_GROUP_EXECUTE".equals(s)) {
                attributes |= 0x8000000;
            } else if ("ATTRIBUTE_OTHER_READ".equals(s)) {
                attributes |= 0x10000000;
            } else if ("ATTRIBUTE_OTHER_WRITE".equals(s)) {
                attributes |= 0x20000000;
            } else if ("ATTRIBUTE_OTHER_EXECUTE".equals(s)) {
                attributes |= 0x40000000;
            } else if ("ATTRIBUTE_EXECUTABLE".equals(s)) {
                attributes |= 4;
            } else if ("ATTRIBUTE_ARCHIVE".equals(s)) {
                attributes |= 8;
            } else if ("ATTRIBUTE_HIDDEN".equals(s)) {
                attributes |= 0x10;
            } else if ("ATTRIBUTE_SYMLINK".equals(s)) {
                attributes |= 0x20;
            } else if ("ATTRIBUTE_LINK_TARGET".equals(s)) {
                attributes |= 0x40;
            }
            ++n2;
        }
        return attributes;
    }

    private static Long getTimeInMillis(String dateTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            Date d = formatter.parse(dateTime);
            return new Long(d.getTime());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static boolean validate(double value, RangeType range) throws NumberFormatException {
        String exp = range.getGreaterThan();
        if (exp != null ? value <= Double.valueOf(exp) : value < Double.valueOf(exp = range.getGreaterThanOrEqualTo())) {
            return false;
        }
        exp = range.getLessThan();
        return !(exp != null ? value >= Double.valueOf(exp) : value > Double.valueOf(exp = range.getLessThanOrEqualTo()));
    }

    private static boolean validate(FileMatchType match, String value, IRemoteFileManager fileManager) throws CoreException {
        Long t;
        if (fileManager == null) {
            return false;
        }
        if (value == null || "".equals(value.trim())) {
            return true;
        }
        final IFileStore rres = fileManager.getResource(value);
        final IFileInfo[] info = new IFileInfo[1];
        Job j = new Job(value){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    info[0] = rres.fetchInfo(0, monitor);
                }
                catch (CoreException t) {
                    return CoreExceptionUtils.getErrorStatus((String)t.getMessage(), (Throwable)t);
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        try {
            j.join();
        }
        catch (InterruptedException interruptedException) {}
        if (!info[0].exists()) {
            return false;
        }
        if (match.isIsDirectory() != info[0].isDirectory()) {
            return false;
        }
        Long len = match.getLength();
        if (len != null && len.longValue() != info[0].getLength()) {
            return false;
        }
        String date = match.getLastModifiedAfter();
        if (date != null && (t = WidgetActionUtils.getTimeInMillis(date)) != null && t > info[0].getLastModified()) {
            return false;
        }
        date = match.getLastModifiedBefore();
        if (date != null && (t = WidgetActionUtils.getTimeInMillis(date)) != null && t < info[0].getLastModified()) {
            return false;
        }
        String attributes = match.getEfsAttributes();
        int a = WidgetActionUtils.getEfsAttributeValue(attributes);
        return info[0].getAttribute(a);
    }

    private WidgetActionUtils() {
    }
}

