/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.apidocs;

import com.google.common.base.Optional;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.apidocs.MethodSelfcallDirectives;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Openable;
import org.eclipse.recommenders.utils.Zips;
import org.eclipse.recommenders.utils.gson.GsonUtil;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class SingleZipMethodSelfCallsModelProvider
implements IModelProvider<IUniqueName<IMethodName>, MethodSelfcallDirectives>,
Openable {
    private final File models;
    private ZipFile zip;

    public SingleZipMethodSelfCallsModelProvider(File models) {
        this.models = models;
    }

    public void open() throws IOException {
        Zips.readFully((File)this.models);
        this.zip = new ZipFile(this.models);
    }

    public void close() throws IOException {
        Zips.closeQuietly((ZipFile)this.zip);
    }

    public Set<ITypeName> acquireableTypes() {
        return Zips.types(this.zip.entries(), (String)".json");
    }

    public Optional<MethodSelfcallDirectives> acquireModel(IUniqueName<IMethodName> key) {
        InputStream is;
        String path = Zips.path((IMethodName)((IMethodName)key.getName()), (String)".json");
        ZipEntry entry = this.zip.getEntry(path);
        if (entry == null) {
            return Optional.absent();
        }
        try {
            is = this.zip.getInputStream(entry);
        }
        catch (IOException iOException) {
            return Optional.absent();
        }
        MethodSelfcallDirectives res = (MethodSelfcallDirectives)GsonUtil.deserialize((InputStream)is, MethodSelfcallDirectives.class);
        IOUtils.closeQuietly((Closeable)is);
        return Optional.of((Object)res);
    }

    public void releaseModel(MethodSelfcallDirectives value) {
    }
}

