/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.net;

import com.google.common.base.Optional;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.fluent.Executor;
import org.eclipse.core.internal.net.ProxyManager;

public class Proxies {
    private static final String DOUBLEBACKSLASH = "\\\\";
    private static final String ENV_USERDOMAIN = "USERDOMAIN";
    private static final String PROP_HTTP_AUTH_NTLM_DOMAIN = "http.auth.ntlm.domain";

    public static Optional<String> getUserDomain(String userName) {
        String domain = System.getProperty(PROP_HTTP_AUTH_NTLM_DOMAIN);
        if (domain != null) {
            return Optional.of((Object)domain);
        }
        domain = System.getenv(ENV_USERDOMAIN);
        if (domain != null) {
            return Optional.of((Object)domain);
        }
        if (StringUtils.contains((CharSequence)userName, (CharSequence)DOUBLEBACKSLASH)) {
            return Optional.of((Object)StringUtils.substringBefore((String)userName, (String)DOUBLEBACKSLASH));
        }
        return Optional.absent();
    }

    public static Optional<String> getWorkstation() {
        try {
            return Optional.of((Object)InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            return Optional.absent();
        }
    }

    public static Optional<String> getUserName(String userName) {
        if (userName == null) {
            return Optional.absent();
        }
        return StringUtils.contains((CharSequence)userName, (CharSequence)DOUBLEBACKSLASH) ? Optional.of((Object)StringUtils.substringAfterLast((String)userName, (String)DOUBLEBACKSLASH)) : Optional.of((Object)userName);
    }

    public static Executor proxy(Executor executor, URI target) {
        Object[] proxies = ProxyManager.getProxyManager().select(target);
        if (ArrayUtils.isEmpty((Object[])proxies)) {
            executor.clearAuth();
        } else {
            Object proxy = proxies[0];
            HttpHost host = new HttpHost(proxy.getHost(), proxy.getPort());
            if (proxy.getUserId() != null) {
                String userId = (String)Proxies.getUserName(proxy.getUserId()).orNull();
                String pass = proxy.getPassword();
                String workstation = (String)Proxies.getWorkstation().orNull();
                String domain = (String)Proxies.getUserDomain(proxy.getUserId()).orNull();
                executor.auth(host, userId, pass, workstation, domain);
            }
        }
        return executor;
    }
}

