/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.recommenders.internal.rcp.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.names.IFieldName;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.IPackageName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmFieldName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmPackageName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class AstBindings {
    public static Optional<ITypeName> toTypeName(ITypeBinding b) {
        String binaryName;
        if (b == null) {
            return Optional.absent();
        }
        StringBuilder sb = new StringBuilder();
        if ((b = b.getErasure()).isArray()) {
            int i = b.getDimensions();
            while (i-- > 0) {
                sb.append('[');
            }
            if ((b = b.getElementType()) == null) {
                return Optional.absent();
            }
        }
        if ((binaryName = b.getBinaryName()) == null) {
            return Optional.absent();
        }
        if (b.isPrimitive()) {
            sb.append(binaryName);
        } else {
            sb.append('L').append(binaryName.replace('.', '/'));
        }
        try {
            VmTypeName res = VmTypeName.get((String)sb.toString());
            return Optional.of((Object)res);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.FAILED_TO_CREATE_TYPENAME, (Object[])new Object[]{b, e});
            return Optional.absent();
        }
    }

    public static Optional<ITypeName> toTypeName(Type type) {
        if (type == null) {
            return Optional.absent();
        }
        ITypeBinding b = type.resolveBinding();
        if (b == null) {
            return Optional.absent();
        }
        return AstBindings.toTypeName(b);
    }

    public static List<ITypeName> toTypeNames(ITypeBinding[] interfaces) {
        LinkedList res = Lists.newLinkedList();
        ITypeBinding[] iTypeBindingArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding b = iTypeBindingArray[n2];
            Optional<ITypeName> opt = AstBindings.toTypeName(b);
            if (opt.isPresent()) {
                res.add((ITypeName)opt.get());
            }
            ++n2;
        }
        return res;
    }

    private static boolean needsColon(ITypeBinding p) {
        if (p.isArray()) {
            return !p.getElementType().isPrimitive();
        }
        return !p.isPrimitive();
    }

    public static Optional<IMethodName> toMethodName(IMethodBinding b) {
        VmMethodName ref;
        if (b == null) {
            return Optional.absent();
        }
        IMethodBinding decl = b.getMethodDeclaration();
        if (decl != null) {
            b = decl;
        }
        StringBuilder sb = new StringBuilder();
        ITypeName declaringType = (ITypeName)AstBindings.toTypeName(b.getDeclaringClass()).orNull();
        if (declaringType == null) {
            return Optional.absent();
        }
        String methodName = b.isConstructor() ? "<init>" : b.getName();
        sb.append(declaringType).append('.').append(methodName).append('(');
        ITypeBinding[] iTypeBindingArray = b.getParameterTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding param = iTypeBindingArray[n2];
            ITypeName paramType = (ITypeName)AstBindings.toTypeName(param).orNull();
            if (paramType == null) {
                return Optional.absent();
            }
            sb.append(paramType);
            if (AstBindings.needsColon(param)) {
                sb.append(';');
            }
            ++n2;
        }
        ITypeBinding returnType = b.getReturnType();
        ITypeName obj = (ITypeName)AstBindings.toTypeName(returnType).orNull();
        if (obj == null) {
            return Optional.absent();
        }
        sb.append(')').append(obj);
        if (AstBindings.needsColon(returnType)) {
            sb.append(';');
        }
        try {
            ref = VmMethodName.get((String)sb.toString());
        }
        catch (Exception e1) {
            Logs.log((Logs.ILogMessage)LogMessages.FAILED_TO_CREATE_METHODNAME, (Object[])new Object[]{b, e1});
            return Optional.absent();
        }
        return Optional.of((Object)ref);
    }

    public static Optional<IVariableBinding> getVariableBinding(Name name) {
        IBinding b = name.resolveBinding();
        IVariableBinding res = (IVariableBinding)(b instanceof IVariableBinding ? b : null);
        return Optional.fromNullable((Object)res);
    }

    public static Optional<IFieldName> toFieldName(IVariableBinding b) {
        if (b == null || !b.isField()) {
            return Optional.absent();
        }
        String name = b.getName();
        ITypeName declared = (ITypeName)AstBindings.toTypeName(b.getDeclaringClass()).orNull();
        ITypeName type = (ITypeName)AstBindings.toTypeName(b.getType()).orNull();
        if (declared == null || type == null) {
            return Optional.absent();
        }
        VmFieldName res = VmFieldName.get((String)(String.valueOf(declared.getIdentifier()) + '.' + name + ';' + type.getIdentifier()));
        return Optional.of((Object)res);
    }

    public static Optional<IPackageName> toPackageName(IPackageBinding pkg) {
        if (pkg == null) {
            return Optional.absent();
        }
        String s = pkg.getName().replace('.', '/');
        return Optional.of((Object)VmPackageName.get((String)s));
    }

    public static Optional<IPackageName> toPackageName(ITypeBinding b) {
        if (b == null) {
            return Optional.absent();
        }
        return AstBindings.toPackageName(b.getPackage());
    }

    public static List<IPackageName> toPackageNames(ITypeBinding[] types) {
        LinkedList res = Lists.newLinkedList();
        ITypeBinding[] iTypeBindingArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding b = iTypeBindingArray[n2];
            Optional<IPackageName> opt = AstBindings.toPackageName(b);
            if (opt.isPresent()) {
                res.add((IPackageName)opt.get());
            }
            ++n2;
        }
        return res;
    }
}

