/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.snipmatch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.Location;
import org.eclipse.recommenders.utils.Checks;

public class Snippet
implements ISnippet {
    public static final String FORMAT_VERSION = "format-4";
    private transient PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    @SerializedName(value="uuid")
    private UUID uuid;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="extraSearchTerms")
    private List<String> extraSearchTerms = Lists.newArrayList();
    @SerializedName(value="tags")
    private List<String> tags = Lists.newArrayList();
    @SerializedName(value="code")
    private String code;
    @SerializedName(value="location")
    private Location location = Location.FILE;

    public Snippet(UUID uuid, String name, String description, List<String> extraSearchTerms, List<String> tags, String code, Location location) {
        Checks.ensureIsNotNull((Object)uuid);
        Checks.ensureIsNotNull((Object)name);
        Checks.ensureIsNotNull((Object)description);
        Checks.ensureIsNotNull(extraSearchTerms);
        Checks.ensureIsNotNull(tags);
        Checks.ensureIsNotNull((Object)code);
        Checks.ensureIsNotNull((Object)((Object)location));
        this.uuid = uuid;
        this.name = name;
        this.description = description;
        this.extraSearchTerms = extraSearchTerms;
        this.tags = tags;
        this.code = code;
        this.location = location;
    }

    protected Snippet() {
        this.location = Location.FILE;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getExtraSearchTerms() {
        return ImmutableList.copyOf(this.extraSearchTerms);
    }

    @Override
    public List<String> getTags() {
        return ImmutableList.copyOf(this.tags);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setCode(String code) {
        this.code = code;
        this.firePropertyChange("code", this.code, this.code);
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange("name", this.name, this.name);
    }

    public void setDescription(String description) {
        this.description = description;
        this.firePropertyChange("description", this.description, this.description);
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setExtraSearchTerms(List<String> extraSearchTerms) {
        this.firePropertyChange("extraSearchTerms", this.extraSearchTerms, extraSearchTerms);
        this.extraSearchTerms.clear();
        this.extraSearchTerms.addAll(extraSearchTerms);
    }

    public void setTags(List<String> tags) {
        this.firePropertyChange("tags", this.tags, tags);
        this.tags.clear();
        this.tags.addAll(tags);
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public static Snippet copy(ISnippet snippet) {
        return new Snippet(snippet.getUuid(), snippet.getName(), snippet.getDescription(), Lists.newArrayList(snippet.getExtraSearchTerms()), Lists.newArrayList(snippet.getTags()), snippet.getCode(), snippet.getLocation() != null ? snippet.getLocation() : Location.FILE);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

