/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.core.factory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.communication.core.hooks.CallContext;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.core.util.Orderer;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.communication.core.factory.ICallHookExtension;

public class OrderedCallHooksExecuter
implements ICallHook {
    private List<ICallHook> orderedCallHooks;
    private List<ICallHook> reversedCallHooks;

    @Override
    public void beforeCall(CallContext context) {
        for (ICallHook sHook : this.orderedCallHooks) {
            sHook.beforeCall(context);
        }
    }

    @Override
    public void afterCall(CallContext context) {
        for (ICallHook sHook : this.reversedCallHooks) {
            sHook.afterCall(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectExtension
    public void update(ICallHookExtension[] callHookExtensions) {
        Orderer orderer = new Orderer();
        ICallHookExtension[] iCallHookExtensionArray = callHookExtensions;
        int n = callHookExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            ICallHookExtension extension = iCallHookExtensionArray[n2];
            orderer.add((Object)extension.getCallHook(), extension.getName(), extension.getPreHooks(), extension.getPostHooks());
            ++n2;
        }
        List tempOrdered = orderer.getOrderedObjects();
        ArrayList<ICallHook> tempReverse = new ArrayList<ICallHook>(tempOrdered.size());
        for (ICallHook hook : Iter.ableReverse((List)tempOrdered)) {
            tempReverse.add(hook);
        }
        OrderedCallHooksExecuter orderedCallHooksExecuter = this;
        synchronized (orderedCallHooksExecuter) {
            this.orderedCallHooks = tempOrdered;
            this.reversedCallHooks = tempReverse;
        }
    }
}

