/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.eclipse.riena.core.util.Nop;

public final class CipherUtils {
    private static final String DES_ALGORITHM = "DES";

    private CipherUtils() {
    }

    public static Cipher getCipher(byte[] key, int mode) throws GeneralSecurityException {
        Cipher desCipher = Cipher.getInstance(DES_ALGORITHM);
        desCipher.init(mode, CipherUtils.getKey(key));
        return desCipher;
    }

    private static Key getKey(byte[] key) throws GeneralSecurityException {
        DESKeySpec pass = new DESKeySpec(CipherUtils.getAtLeastEightBytes(key));
        SecretKeyFactory skf = SecretKeyFactory.getInstance(DES_ALGORITHM);
        SecretKey s = skf.generateSecret(pass);
        return s;
    }

    private static byte[] getAtLeastEightBytes(byte[] initialBytes) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        int bytesIndex = 0;
        byte[] byArray = initialBytes == null ? new byte[]{} : initialBytes;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            bos.write(b);
            ++bytesIndex;
            ++n2;
        }
        if (bytesIndex < 8) {
            Random random = new Random(4711081542L);
            while (bytesIndex++ < 8) {
                byte[] randomByte = new byte[1];
                random.nextBytes(randomByte);
                try {
                    bos.write(randomByte);
                }
                catch (IOException iOException) {
                    Nop.reason(" That should never happen on a ByteArrayOutputStream");
                }
            }
        }
        return bos.toByteArray();
    }
}

