/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class Iter {
    private Iter() {
    }

    public static <T> Iterable<T> able(Iterator<T> iterator) {
        if (iterator == null) {
            return Collections.emptyList();
        }
        return new IteratorIterable(iterator);
    }

    public static <T> Iterable<T> able(Enumeration<T> enumeration) {
        if (enumeration == null) {
            return Collections.emptyList();
        }
        return new IteratorIterable(new EnumerationIterator(enumeration));
    }

    public static <T> Iterable<T> able(Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return iterable;
    }

    public static <T> Iterable<T> ableReverse(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return new ReverseIterable(list.listIterator(list.size()));
    }

    public static <T> Iterable<T> able(T ... array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public static <T> Iterable<T> able(Iterator iterator, Class<T> t) {
        return Iter.able(iterator);
    }

    public static <T> Iterable<T> able(Enumeration enumeration, Class<T> t) {
        return Iter.able(enumeration);
    }

    private static final class EnumerationIterator<T>
    implements Iterator<T> {
        private final Enumeration<T> enumeration;

        private EnumerationIterator(Enumeration<T> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public T next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new NoSuchMethodError("No remove() on an wrapped Enumeration!");
        }
    }

    private static final class IteratorIterable<T>
    implements Iterable<T> {
        private final Iterator<T> iterator;

        private IteratorIterable(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterator;
        }
    }

    private static final class ReverseIterable<T>
    implements Iterable<T> {
        private Iterator<T> reversed;

        private ReverseIterable(final ListIterator<T> iterator) {
            this.reversed = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasPrevious();
                }

                @Override
                public T next() {
                    return iterator.previous();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public Iterator<T> iterator() {
            return this.reversed;
        }
    }
}

