/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.application;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.ReflectionFailure;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.internal.navigation.ui.swt.IAdvisorHelper;
import org.eclipse.riena.internal.ui.swt.utils.RcpUtilities;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.ui.application.AbstractApplication;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.login.ILoginDialogView;
import org.eclipse.riena.navigation.ui.swt.application.LoginNonActivityTimer;
import org.eclipse.riena.navigation.ui.swt.login.ILoginSplashViewExtension;
import org.eclipse.riena.navigation.ui.swt.splashHandlers.AbstractLoginSplashHandler;
import org.eclipse.riena.navigation.ui.swt.views.ApplicationAdvisor;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.Workbench;

public class SwtApplication
extends AbstractApplication {
    protected ILoginSplashViewExtension loginSplashViewExtension;

    protected void initializeUI() {
        PlatformUI.createDisplay();
    }

    public Object createView(IApplicationContext context, IApplicationNode pNode) {
        Display display = Display.getCurrent();
        try {
            ApplicationAdvisor advisor = new ApplicationAdvisor(this.createApplicationController(pNode), new AdvisorHelper());
            this.initializeLoginNonActivityTimer(display, pNode, context);
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)advisor);
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ActionBarAdvisor(configurer);
    }

    protected String getKeyScheme() {
        return "org.eclipse.riena.ui.defaultBindings";
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    @InjectExtension
    public void update(ILoginSplashViewExtension[] data) {
        if (data.length > 0) {
            this.loginSplashViewExtension = data[0];
        }
    }

    protected ApplicationController createApplicationController(IApplicationNode pModel) {
        return new ApplicationController(pModel);
    }

    protected void prePerformLogin(IApplicationContext context) {
        if (RcpUtilities.getWorkbenchShell() != null) {
            RcpUtilities.getWorkbenchShell().setVisible(false);
            RcpUtilities.getWorkbenchShell().setMinimized(true);
            RcpUtilities.getWorkbenchShell().setVisible(true);
        }
    }

    protected void postPerformLogin(IApplicationContext context, Object result) {
        if (!EXIT_OK.equals(result)) {
            PlatformUI.getWorkbench().close();
        } else {
            RcpUtilities.getWorkbenchShell().setMinimized(false);
        }
    }

    protected Integer doPerformLogin(IApplicationContext context) {
        Realm realm = SWTObservables.getRealm((Display)this.getDisplay());
        final ILoginDialogView loginDialogView = this.loginDialogViewExtension.createViewClass();
        do {
            Realm.runWithDefault((Realm)realm, (Runnable)new Runnable(){

                @Override
                public void run() {
                    loginDialogView.build();
                }
            });
        } while (EXIT_RESTART.equals(loginDialogView.getResult()));
        return loginDialogView.getResult();
    }

    protected Integer doPerformSplashLogin(IApplicationContext context) {
        Shell shell = new Shell(this.getDisplay(), 65544);
        this.initilizeShellBackgroundImage(shell, this.getBackgroundImagePath(context));
        AbstractLoginSplashHandler loginSplashHandler = this.getLoginSplashHandler();
        loginSplashHandler.init(shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (this.getDisplay().readAndDispatch()) continue;
            this.getDisplay().sleep();
        }
        return loginSplashHandler.getResult();
    }

    protected boolean isSplashLogin(IApplicationContext context) {
        return this.loginSplashViewExtension != null && this.getLoginSplashHandler() != null;
    }

    protected boolean isDialogLogin(IApplicationContext context) {
        return super.isDialogLogin(context) && this.loginSplashViewExtension == null;
    }

    protected void initializeLoginViewDefinition() {
        super.initializeLoginViewDefinition();
        this.initializeLoginSplashViewDefinition();
    }

    private String getBackgroundImagePath(IApplicationContext context) {
        return "splash.bmp";
    }

    private Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return PlatformUI.createDisplay();
    }

    private AbstractLoginSplashHandler getLoginSplashHandler() {
        AbstractLoginSplashHandler result = null;
        if (PlatformUI.isWorkbenchRunning() && !SWTFacade.isRAP()) {
            try {
                Object loginSplashHandler = ReflectionUtils.invokeHidden(Workbench.class, (String)"getSplash", (Object[])new Object[0]);
                if (loginSplashHandler instanceof AbstractLoginSplashHandler) {
                    result = (AbstractLoginSplashHandler)((Object)loginSplashHandler);
                }
            }
            catch (ReflectionFailure refFail) {
                Log4r.getLogger(SwtApplication.class).log(1, "Workbench.getSplash()", (Throwable)refFail);
            }
        }
        return result;
    }

    private void initializeLoginNonActivityTimer(final Display display, IApplicationNode pNode, final IApplicationContext context) {
        pNode.addListener((INavigationNodeListener)new ApplicationNodeListener(){

            public void afterActivated(IApplicationNode source) {
                LoginNonActivityTimer.ILoginExecutor<Integer> loginExecutor = new LoginNonActivityTimer.ILoginExecutor<Integer>(){

                    @Override
                    public void prePerformLogin() throws Exception {
                        SwtApplication.this.prePerformLogin(context);
                    }

                    @Override
                    public void postPerformLogin(Integer result) throws Exception {
                        SwtApplication.this.postPerformLogin(context, result);
                    }

                    @Override
                    public Integer performLogin() {
                        try {
                            return SwtApplication.this.performLogin(context);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public int getNonActivityDuration() {
                        if (SwtApplication.this.isSplashLogin(context)) {
                            return (this).SwtApplication.this.loginSplashViewExtension.getNonActivityDuration();
                        }
                        if (SwtApplication.this.isDialogLogin(context)) {
                            return SwtApplication.this.loginDialogViewExtension.getNonActivityDuration();
                        }
                        return 0;
                    }
                };
                if (SwtApplication.this.isSplashLogin(context)) {
                    SwtApplication.this.startNonActivityTimer(display, loginExecutor);
                } else if (SwtApplication.this.isDialogLogin(context)) {
                    SwtApplication.this.startNonActivityTimer(display, loginExecutor);
                }
            }
        });
    }

    private boolean startNonActivityTimer(Display display, LoginNonActivityTimer.ILoginExecutor<Integer> loginExecutor) {
        if (this.loginDialogViewExtension.getNonActivityDuration() > 0) {
            new LoginNonActivityTimer(display, loginExecutor, this.loginSplashViewExtension.getNonActivityDuration()).schedule();
            return true;
        }
        return false;
    }

    private void initializeLoginSplashViewDefinition() {
        Wire.instance((Object)((Object)this)).andStart(Activator.getDefault().getContext());
    }

    private void initilizeShellBackgroundImage(Shell shell, String imageName) {
        Image bi = ImageStore.getInstance().getImage(imageName);
        shell.setSize(bi.getBounds().width, bi.getBounds().height);
        shell.setBackgroundImage(bi);
    }

    private final class AdvisorHelper
    implements IAdvisorHelper {
        private AdvisorHelper() {
        }

        @Override
        public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
            return SwtApplication.this.createActionBarAdvisor(configurer);
        }

        @Override
        public String getKeyScheme() {
            return SwtApplication.this.getKeyScheme();
        }
    }
}

