/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.singleton.SessionSingletonProvider;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaManager;

public class SwtViewProvider {
    private final Map<INavigationNode<?>, SwtViewId> views;
    private final Map<String, Integer> viewCounter;
    private final HashMap<String, Boolean> viewShared;
    private INavigationNode<?> currentPrepared = null;
    private static final SingletonProvider<SwtViewProvider> SVP = new SessionSingletonProvider(SwtViewProvider.class);
    private final Map<SwtViewId, SubModuleView> registerdViewInstances = new HashMap<SwtViewId, SubModuleView>();

    public static SwtViewProvider getInstance() {
        return (SwtViewProvider)SVP.getInstance();
    }

    protected SwtViewProvider() {
        this.viewCounter = new LinkedHashMap<String, Integer>();
        this.views = new LinkedHashMap();
        this.viewShared = new HashMap();
    }

    public SwtViewId getSwtViewId(INavigationNode<?> node) {
        SwtViewId swtViewId = this.views.get(node);
        if (swtViewId == null) {
            ISubModuleNode submodule = (ISubModuleNode)node.getTypecastedAdapter(ISubModuleNode.class);
            swtViewId = submodule != null && submodule.getNodeId() != null ? this.createAndRegisterSwtViewId(submodule) : this.createAndRegisterSwtViewId(node);
        }
        boolean found = false;
        for (Map.Entry<INavigationNode<?>, SwtViewId> entry : this.views.entrySet()) {
            if (entry.getKey() != node) continue;
            found = true;
        }
        Assert.isLegal((boolean)found, (String)("Cannot register node " + node + " because a different node with the same id is already registered."));
        return swtViewId;
    }

    public void unregisterSwtViewId(INavigationNode<?> node) {
        this.views.remove(node);
    }

    public void replaceNavigationNodeId(INavigationNode<?> node, NavigationNodeId oldId, NavigationNodeId newId) {
        node.setNodeId(oldId);
        SwtViewId swtViewId = this.views.remove(node);
        if (swtViewId != null) {
            node.setNodeId(newId);
            this.views.put(node, swtViewId);
        }
    }

    private SwtViewId createAndRegisterSwtViewId(INavigationNode<?> node) {
        IWorkareaDefinition def = WorkareaManager.getInstance().getDefinition(node);
        String viewId = this.getViewId(node, def);
        SwtViewId swtViewId = new SwtViewId(viewId, this.getNextSecondaryId(viewId));
        this.views.put(node, swtViewId);
        return swtViewId;
    }

    private SwtViewId createAndRegisterSwtViewId(ISubModuleNode submodule) {
        IWorkareaDefinition def = WorkareaManager.getInstance().getDefinition((Object)submodule);
        String viewId = this.getViewId((INavigationNode<?>)submodule, def);
        if (this.viewShared.get(viewId) != null) {
            if (def.isViewShared() != this.viewShared.get(viewId).booleanValue()) {
                throw new ApplicationModelFailure("Inconsistent view usage. The view with the id \"" + viewId + "\" is already used with a different 'shared' state. A view must be defined in all workarea definitions as either shared or not shared.");
            }
        } else {
            this.viewShared.put(viewId, def.isViewShared());
        }
        SwtViewId swtViewId = null;
        if (def.isViewShared()) {
            if (this.views.get(submodule) == null) {
                this.viewCounter.put(viewId, 0);
            }
            if (this.viewCounter.get(viewId) == 0) {
                String secondary = "shared";
                IModuleGroupNode group = (IModuleGroupNode)submodule.getParentOfType(IModuleGroupNode.class);
                if (group != null && group.getContext("shared.views.context") instanceof String) {
                    secondary = String.valueOf(secondary) + ".";
                    secondary = String.valueOf(secondary) + (String)group.getContext("shared.views.context");
                }
                swtViewId = new SwtViewId(viewId, secondary);
                this.views.put((INavigationNode<?>)submodule, swtViewId);
                this.viewCounter.put(viewId, 1);
            } else {
                swtViewId = this.views.get(this.getNavigationNode(viewId, null, ISubModuleNode.class, true));
                this.views.put((INavigationNode<?>)submodule, swtViewId);
            }
        } else {
            swtViewId = new SwtViewId(viewId, this.getNextSecondaryId(viewId));
            this.views.put((INavigationNode<?>)submodule, swtViewId);
        }
        return swtViewId;
    }

    private String getViewId(INavigationNode<?> node, IWorkareaDefinition def) {
        if (def == null) {
            throw new ApplicationModelFailure("no work area definition for node " + node.getNodeId());
        }
        Object viewId = def.getViewId();
        if (viewId == null) {
            throw new ApplicationModelFailure("viewId is null for nodeId " + node.getNodeId());
        }
        if (!(viewId instanceof String)) {
            throw new ApplicationModelFailure("viewId is not a String for nodeId " + node.getNodeId());
        }
        return (String)viewId;
    }

    private String getNextSecondaryId(String pViewId) {
        if (this.viewCounter.get(pViewId) == null) {
            this.viewCounter.put(pViewId, 0);
        }
        this.viewCounter.put(pViewId, this.viewCounter.get(pViewId) + 1);
        return String.valueOf(this.viewCounter.get(pViewId));
    }

    private boolean isViewShared(String viewId) {
        Boolean result = this.viewShared.get(viewId);
        return result == null ? false : result;
    }

    public <N extends INavigationNode<?>> N getNavigationNode(String pId, Class<N> pClass) {
        return this.getNavigationNode(pId, null, pClass);
    }

    public <N extends INavigationNode<?>> N getNavigationNode(String pId, String secondary, Class<N> pClass) {
        return this.getNavigationNode(pId, secondary, pClass, false);
    }

    public <N extends INavigationNode<?>> N getNavigationNode(String pId, String secondary, Class<N> pClass, boolean ignoreSharedState) {
        for (Map.Entry<INavigationNode<?>, SwtViewId> entry : this.views.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().getId().equals(pId) || secondary != null && !secondary.equals(entry.getValue().getSecondary())) continue;
            if (ignoreSharedState || !this.isViewShared(pId) || entry.getKey().isActivated()) {
                return (N)((INavigationNode)entry.getKey().getTypecastedAdapter(pClass));
            }
            if (!this.isViewShared(pId) || !((INavigationNode)entry.getKey().getTypecastedAdapter(pClass)).equals(this.currentPrepared)) continue;
            return (N)this.currentPrepared;
        }
        return null;
    }

    public List<INavigationNode<?>> getViewUsers(SwtViewId id) {
        ArrayList result = new ArrayList();
        Set<INavigationNode<?>> nodes = this.views.keySet();
        for (INavigationNode<?> regNode : nodes) {
            SwtViewId swtViewId = this.views.get(regNode);
            if (regNode.isDisposed() || swtViewId == null || !swtViewId.getCompoundId().equals(id.getCompoundId())) continue;
            result.add(regNode);
        }
        return result;
    }

    public void setCurrentPrepared(INavigationNode<?> node) {
        this.currentPrepared = node;
    }

    public INavigationNode<?> getCurrentPrepared() {
        return this.currentPrepared;
    }

    public void registerView(String id, String secondaryId, SubModuleView subModuleView) {
        this.registerdViewInstances.put(new SwtViewId(id, secondaryId), subModuleView);
    }

    public SubModuleView getRegisteredView(String id, String secondaryId) {
        return this.registerdViewInstances.get(new SwtViewId(id, secondaryId));
    }

    public void unregisterView(String id, String secondaryId) {
        this.registerdViewInstances.remove(new SwtViewId(id, secondaryId));
    }
}

