/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import org.eclipse.riena.core.injector.extension.ExtensionInterface;
import org.eclipse.riena.core.singleton.SessionSingletonProvider;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.navigation.INavigationNodeProvider;

public final class NavigationNodeProvider {
    private static final SingletonProvider<NavigationNodeProvider> NNP = new SessionSingletonProvider(NavigationNodeProvider.class);
    private INavigationNodeProvider provider;

    public static INavigationNodeProvider getInstance() {
        return ((NavigationNodeProvider)NNP.getInstance()).getProvider();
    }

    private NavigationNodeProvider() {
    }

    private INavigationNodeProvider getProvider() {
        return this.provider;
    }

    @InjectExtension
    public void update(INavigationNodeProviderExtension[] availableExtensions) {
        if (this.provider != null) {
            this.provider.cleanUp();
        }
        INavigationNodeProviderExtension found = null;
        int maxPriority = Integer.MIN_VALUE;
        this.provider = null;
        INavigationNodeProviderExtension[] iNavigationNodeProviderExtensionArray = availableExtensions;
        int n = availableExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            INavigationNodeProviderExtension probe = iNavigationNodeProviderExtensionArray[n2];
            int p = probe.getPriority();
            if (found == null || p > maxPriority) {
                found = probe;
                maxPriority = p;
            }
            ++n2;
        }
        if (found != null) {
            this.provider = found.createClass();
        }
    }

    @ExtensionInterface(id="navigationNodeProvider")
    public static interface INavigationNodeProviderExtension {
        public String getId();

        public int getPriority();

        public INavigationNodeProvider createClass();
    }
}

