/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.common.authorization;

import java.security.Permission;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.security.common.authorization.ISentinelService;

public final class Sentinel {
    private static final SingletonProvider<Sentinel> SENTINEL = new SingletonProvider(Sentinel.class);
    private ISentinelService sentinelService;

    private Sentinel() {
    }

    private static Sentinel getInstance() {
        return (Sentinel)SENTINEL.getInstance();
    }

    private ISentinelService getSentinelService() {
        return this.sentinelService;
    }

    @InjectService(useRanking=true)
    public void bind(ISentinelService sentinelServiceParm) {
        this.sentinelService = sentinelServiceParm;
    }

    public void unbind(ISentinelService sentinelServiceParm) {
        this.sentinelService = null;
    }

    public static boolean checkAccess(Permission permission) {
        if (((Sentinel)SENTINEL.getInstance()).getSentinelService() == null) {
            return false;
        }
        return Sentinel.getInstance().getSentinelService().checkAccess(permission);
    }
}

