/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.ssl;

import java.io.File;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.riena.communication.core.ssl.TestHostnameVerifier;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.communication.core.ssl.ISSLPropertiesExtension;
import org.eclipse.riena.internal.communication.core.ssl.SSLConfiguration;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.tests.nanohttp.TestServer;
import org.osgi.framework.Bundle;

@NonUITestCase
public class SSLConfigurationTest
extends RienaTestCase {
    public void testZeroConfiguration() {
        this.printTestName();
        SSLConfiguration config = new SSLConfiguration();
        SSLConfigurationTest.assertNull((Object)ReflectionUtils.getHidden((Object)config, (String)"protocol"));
        SSLConfigurationTest.assertNull((Object)ReflectionUtils.getHidden((Object)config, (String)"keystore"));
        SSLConfigurationTest.assertNull((Object)ReflectionUtils.getHidden((Object)config, (String)"password"));
        SSLConfigurationTest.assertNull((Object)ReflectionUtils.getHidden((Object)config, (String)"hostnameVerifier"));
    }

    public void testOneConfiguration() {
        this.printTestName();
        this.addPluginXml(SSLConfigurationTest.class, "plugin.xml");
        try {
            SSLConfiguration config = new SSLConfiguration();
            Wire.instance((Object)config).andStart(this.getContext());
            SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"protocol"), (Object)"TLSv1");
            SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"keystore"), (Object)"#jre-cacerts#");
            SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"password"), (Object)"changeit");
            SSLConfigurationTest.assertNotNull((Object)ReflectionUtils.getHidden((Object)config, (String)"hostnameVerifier"));
            SSLConfigurationTest.assertEquals(ReflectionUtils.getHidden((Object)config, (String)"hostnameVerifier").getClass(), SSLConfiguration.StrictHostnameVerifier.class);
        }
        finally {
            this.removeExtension("org.eclipse.riena.communication.core.ssl.test");
        }
    }

    public void testOneConfigurationWithEncryptedPassword() {
        this.printTestName();
        this.addPluginXml(SSLConfigurationTest.class, "pluginWithEncryptedPassword.xml");
        try {
            SSLConfiguration config = new SSLConfiguration();
            Wire.instance((Object)config).andStart(this.getContext());
            SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"protocol"), (Object)"TLSv1");
            SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"keystore"), (Object)"#jre-cacerts#");
            SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"password"), (Object)"cae3c55508eaa369d5c8870398c90a64");
            SSLConfigurationTest.assertNotNull((Object)ReflectionUtils.getHidden((Object)config, (String)"hostnameVerifier"));
            SSLConfigurationTest.assertEquals(ReflectionUtils.getHidden((Object)config, (String)"hostnameVerifier").getClass(), SSLConfiguration.StrictHostnameVerifier.class);
        }
        finally {
            this.removeExtension("org.eclipse.riena.communication.core.ssl.test");
        }
    }

    public void testOneConfigurationWithHostnameVerifier() {
        this.printTestName();
        this.addPluginXml(SSLConfigurationTest.class, "pluginWithHostnameVerifier.xml");
        try {
            SSLConfiguration config = new SSLConfiguration();
            Wire.instance((Object)config).andStart(this.getContext());
            SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"protocol"), (Object)"TLSv1");
            SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"keystore"), (Object)"#jre-cacerts#");
            SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"password"), (Object)"changeit");
            SSLConfigurationTest.assertEquals(ReflectionUtils.getHidden((Object)config, (String)"hostnameVerifier").getClass(), TestHostnameVerifier.class);
        }
        finally {
            this.removeExtension("org.eclipse.riena.communication.core.ssl.test");
        }
    }

    public void testLocateKeystoreJreCacerts() {
        this.printTestName();
        SSLProperties properties = new SSLProperties("TLSv1", "#jre-cacerts#", "changeit");
        SSLConfiguration config = new SSLConfiguration();
        config.configure((ISSLPropertiesExtension)properties);
        SSLConfigurationTest.assertTrue((boolean)config.isConfigured());
        SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"protocol"), (Object)"TLSv1");
        SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"keystore"), (Object)"#jre-cacerts#");
        SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"password"), (Object)"changeit");
        SSLConfigurationTest.assertNotNull((Object)ReflectionUtils.getHidden((Object)config, (String)"hostnameVerifier"));
        SSLConfigurationTest.assertEquals(ReflectionUtils.getHidden((Object)config, (String)"hostnameVerifier").getClass(), SSLConfiguration.StrictHostnameVerifier.class);
    }

    public void testLocateKeystoreJreCacertsEncryptedPassword() {
        this.printTestName();
        SSLProperties properties = new SSLProperties("TLSv1", "#jre-cacerts#", "cae3c55508eaa369d5c8870398c90a64", "true");
        SSLConfiguration config = new SSLConfiguration();
        config.configure((ISSLPropertiesExtension)properties);
        SSLConfigurationTest.assertTrue((boolean)config.isConfigured());
        SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"protocol"), (Object)"TLSv1");
        SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"keystore"), (Object)"#jre-cacerts#");
        SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"password"), (Object)"cae3c55508eaa369d5c8870398c90a64");
        SSLConfigurationTest.assertNotNull((Object)ReflectionUtils.getHidden((Object)config, (String)"hostnameVerifier"));
        SSLConfigurationTest.assertEquals(ReflectionUtils.getHidden((Object)config, (String)"hostnameVerifier").getClass(), SSLConfiguration.StrictHostnameVerifier.class);
    }

    public void testGetPasswordCharsNotEncrypted() {
        SSLConfiguration config = new SSLConfiguration();
        char[] password = (char[])ReflectionUtils.invokeHidden((Object)config, (String)"getPasswordChars", (Object[])new Object[]{"changeit", "false"});
        SSLConfigurationTest.assertEquals((String)"changeit", (String)new String(password));
    }

    public void testGetPasswordCharsEncrypted() {
        SSLConfiguration config = new SSLConfiguration();
        char[] password = (char[])ReflectionUtils.invokeHidden((Object)config, (String)"getPasswordChars", (Object[])new Object[]{"cae3c55508eaa369d5c8870398c90a64", "true"});
        SSLConfigurationTest.assertEquals((String)"changeit", (String)new String(password));
    }

    public void testLocateKeystoreJreCacertsAndCustomHostnameVerifier() {
        this.printTestName();
        TestHostnameVerifier hostnameVerifier = new TestHostnameVerifier();
        SSLProperties properties = new SSLProperties("TLSv1", "#jre-cacerts#", "changeit", hostnameVerifier);
        SSLConfiguration config = new SSLConfiguration();
        config.configure((ISSLPropertiesExtension)properties);
        SSLConfigurationTest.assertTrue((boolean)config.isConfigured());
        SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"protocol"), (Object)"TLSv1");
        SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"keystore"), (Object)"#jre-cacerts#");
        SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"password"), (Object)"changeit");
        SSLConfigurationTest.assertEquals((Object)ReflectionUtils.getHidden((Object)config, (String)"hostnameVerifier"), (Object)hostnameVerifier);
    }

    public void testLocateKeystoreFile() {
        this.printTestName();
        String jreDir = System.getProperty("java.home");
        File cacertFile = new File(new File(new File(new File(jreDir), "lib"), "security"), "cacerts");
        SSLProperties properties = new SSLProperties("TLSv1", cacertFile.toString(), "changeit");
        SSLConfiguration config = new SSLConfiguration();
        config.configure((ISSLPropertiesExtension)properties);
        SSLConfigurationTest.assertTrue((boolean)config.isConfigured());
    }

    public void testLocateKeystoreResource() {
        this.printTestName();
        SSLProperties properties = new SSLProperties("TLSv1", "/org/eclipse/riena/communication/core/ssl/cacerts", "changeit");
        SSLConfiguration config = new SSLConfiguration();
        config.configure((ISSLPropertiesExtension)properties);
        SSLConfigurationTest.assertTrue((boolean)config.isConfigured());
    }

    public void testLocateKeystoreEntry() {
        this.printTestName();
        SSLProperties properties = new SSLProperties("TLSv1", "/keystore/cacerts", "changeit");
        SSLConfiguration config = new SSLConfiguration();
        config.configure((ISSLPropertiesExtension)properties);
        SSLConfigurationTest.assertTrue((boolean)config.isConfigured());
    }

    public void testLocateKeystoreUrl() throws IOException {
        this.printTestName();
        String jreDir = System.getProperty("java.home");
        File cacertDir = new File(new File(new File(jreDir), "lib"), "security");
        TestServer nano = new TestServer(8888, cacertDir);
        SSLProperties properties = new SSLProperties("TLSv1", "http://localhost:8888/cacerts", "changeit");
        SSLConfiguration config = new SSLConfiguration();
        config.configure((ISSLPropertiesExtension)properties);
        SSLConfigurationTest.assertTrue((boolean)config.isConfigured());
        nano.stop();
    }

    private static class SSLProperties
    implements ISSLPropertiesExtension {
        private final String protocol;
        private final String keystore;
        private final String password;
        private final String encrypt;
        private final HostnameVerifier hostnameVerifier;

        public SSLProperties(String protocol, String keystore, String password) {
            this(protocol, keystore, password, null, null);
        }

        public SSLProperties(String protocol, String keystore, String password, HostnameVerifier hostnameVerifier) {
            this(protocol, keystore, password, null, hostnameVerifier);
        }

        public SSLProperties(String protocol, String keystore, String password, String encrypt) {
            this(protocol, keystore, password, encrypt, null);
        }

        public SSLProperties(String protocol, String keystore, String password, String encrypt, HostnameVerifier hostnameVerifier) {
            this.protocol = protocol;
            this.keystore = keystore;
            this.password = password;
            this.encrypt = encrypt;
            this.hostnameVerifier = hostnameVerifier;
        }

        public String getKeystore() {
            return this.keystore;
        }

        public String getPassword() {
            return this.password;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public HostnameVerifier createHostnameVerifier() {
            return this.hostnameVerifier;
        }

        public Bundle getContributingBundle() {
            return Activator.getDefault().getBundle();
        }

        public String getEncrypt() {
            return this.encrypt;
        }
    }
}

