/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.beans.common.StringPojo;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTableListRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.FTActionListener;
import org.eclipse.riena.internal.ui.ridgets.swt.FTClickListener;
import org.eclipse.riena.internal.ui.ridgets.swt.ListRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TestSelectionListener;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IListRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.listener.ClickEvent;
import org.eclipse.riena.ui.ridgets.listener.IClickListener;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class ListRidgetTest
extends AbstractTableListRidgetTest {
    protected org.eclipse.swt.widgets.List createWidget(Composite parent) {
        return new org.eclipse.swt.widgets.List(parent, 2);
    }

    protected IListRidget createRidget() {
        return new ListRidget();
    }

    protected org.eclipse.swt.widgets.List getWidget() {
        return (org.eclipse.swt.widgets.List)super.getWidget();
    }

    protected IListRidget getRidget() {
        return (IListRidget)super.getRidget();
    }

    @Override
    protected void bindRidgetToModel() {
        this.getRidget().bindToModel((Object)this.manager, "persons", Person.class, "firstname");
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        ListRidgetTest.assertSame(ListRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testUpdateFromModel() {
        org.eclipse.swt.widgets.List control = this.getWidget();
        IListRidget ridget = this.getRidget();
        int oldCount = this.manager.getPersons().size();
        ListRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        ListRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        this.manager.getPersons().remove(this.person1);
        int newCount = oldCount - 1;
        ListRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        ListRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        ListRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        ridget.updateFromModel();
        ListRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        ListRidgetTest.assertEquals((int)newCount, (int)ridget.getObservableList().size());
        ListRidgetTest.assertEquals((int)newCount, (int)control.getItemCount());
    }

    public void testUpdateFromModelPreservesSelection() {
        IListRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        ListRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person1);
        ridget.updateFromModel();
        ListRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
    }

    public void testContainsOption() {
        IListRidget ridget = this.getRidget();
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person1));
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person2));
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
        ListRidgetTest.assertFalse((boolean)ridget.containsOption(null));
        ListRidgetTest.assertFalse((boolean)ridget.containsOption((Object)new Person("", "")));
        List<Person> persons = Arrays.asList(this.person3);
        PersonManager manager = new PersonManager(persons);
        ridget.bindToModel((Object)manager, "persons", Person.class, new String[]{"firstname"}, new String[]{""});
        ridget.updateFromModel();
        ListRidgetTest.assertFalse((boolean)ridget.containsOption((Object)this.person1));
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
    }

    public void testSetSelectionType() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ListRidgetTest.assertEquals((Object)ISelectableRidget.SelectionType.SINGLE, (Object)ridget.getSelectionType());
        ListRidgetTest.assertTrue(((control.getStyle() & 2) != 0 ? 1 : 0) != 0);
        int[] nArray = new int[2];
        nArray[1] = 1;
        ridget.setSelection(nArray);
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelectionIndices().length);
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        ridget.setSelection(nArray2);
        ListRidgetTest.assertEquals((int)2, (int)ridget.getSelectionIndices().length);
        ListRidgetTest.assertEquals((int)2, (int)control.getSelectionCount());
    }

    @Override
    public void testAddClickListener() {
        IListRidget ridget = this.getRidget();
        ridget.updateFromModel();
        org.eclipse.swt.widgets.List control = this.getWidget();
        try {
            ridget.addClickListener(null);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTClickListener listener1 = new FTClickListener();
        ridget.addClickListener((IClickListener)listener1);
        FTClickListener listener2 = new FTClickListener();
        ridget.addClickListener((IClickListener)listener2);
        ridget.addClickListener((IClickListener)listener2);
        control.setSelection(2);
        Event mdEvent = new Event();
        mdEvent.widget = control;
        mdEvent.button = 2;
        mdEvent.type = 3;
        control.notifyListeners(3, mdEvent);
        mdEvent.type = 4;
        control.notifyListeners(4, mdEvent);
        ListRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        ListRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ClickEvent event = listener2.getEvent();
        ListRidgetTest.assertEquals((Object)this.getRidget(), (Object)event.getSource());
        ListRidgetTest.assertEquals((int)2, (int)event.getButton());
        ListRidgetTest.assertEquals((int)0, (int)event.getColumnIndex());
        ListRidgetTest.assertSame((Object)this.person3, (Object)event.getRow());
        ridget.removeClickListener((IClickListener)listener1);
        mdEvent.type = 3;
        control.notifyListeners(3, mdEvent);
        mdEvent.type = 4;
        control.notifyListeners(4, mdEvent);
        ListRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        ListRidgetTest.assertEquals((int)2, (int)listener2.getCount());
        control.deselectAll();
        mdEvent.type = 3;
        control.notifyListeners(3, mdEvent);
        mdEvent.type = 4;
        control.notifyListeners(4, mdEvent);
        event = listener2.getEvent();
        ListRidgetTest.assertEquals((int)3, (int)listener2.getCount());
        ListRidgetTest.assertEquals((int)2, (int)event.getButton());
        ListRidgetTest.assertEquals((int)0, (int)event.getColumnIndex());
        ListRidgetTest.assertEquals(null, (Object)event.getRow());
    }

    public void testAddDoubleClickListener() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        try {
            ridget.addDoubleClickListener(null);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTActionListener listener1 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener1);
        FTActionListener listener2 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener2);
        ridget.addDoubleClickListener((IActionListener)listener2);
        Event doubleClick = new Event();
        doubleClick.widget = control;
        doubleClick.type = 8;
        control.notifyListeners(8, doubleClick);
        ListRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        ListRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ridget.removeDoubleClickListener((IActionListener)listener1);
        control.notifyListeners(8, doubleClick);
        ListRidgetTest.assertEquals((int)1, (int)listener1.getCount());
    }

    public void testSetComparator() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        TypedComparator comparator = new TypedComparator();
        try {
            ridget.setComparator(-1, (Comparator)comparator);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setComparator(1, (Comparator)comparator);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        int lastItemIndex = control.getItemCount() - 1;
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex));
        ridget.setComparator(0, (Comparator)comparator);
        ridget.setSortedColumn(0);
        ListRidgetTest.assertEquals((String)"Frank", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(lastItemIndex));
        ridget.setComparator(0, null);
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex));
    }

    public void testGetSortedColumn() {
        IListRidget ridget = this.getRidget();
        try {
            ridget.setSortedColumn(1);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setSortedColumn(-2);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        ridget.setComparator(0, null);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(-1);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
    }

    public void testIsColumnSortable() {
        IListRidget ridget = this.getRidget();
        try {
            ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(-1));
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(1));
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(0));
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ListRidgetTest.assertTrue((boolean)ridget.isColumnSortable(0));
        ridget.setComparator(0, null);
        ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(0));
    }

    public void testSetColumnSortable() {
        IListRidget ridget = this.getRidget();
        try {
            ridget.setColumnSortable(0, true);
            ListRidgetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.ok();
        }
    }

    public void testSetSortedAscending() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ridget.bindToModel((Object)this.manager, "persons", Person.class, new String[]{"lastname"}, new String[]{""});
        ridget.updateFromModel();
        int lastItemIndex = control.getItemCount() - 1;
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        ridget.setSortedAscending(false);
        ListRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ridget.setSortedColumn(0);
        ListRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        ListRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Doe", (String)control.getItem(lastItemIndex));
        ridget.setSortedAscending(true);
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        ListRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex));
        ridget.setComparator(0, null);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
    }

    public void testSetSortedAscendingFiresEvents() {
        IListRidget ridget = this.getRidget();
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.TRUE, Boolean.FALSE));
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.FALSE, Boolean.TRUE));
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
    }

    public void testSetSortedColumnFiresEvents() {
        IListRidget ridget = this.getRidget();
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", -1, 0));
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", 0, -1));
        ridget.setSortedColumn(-1);
        this.verifyPropertyChangeEvents();
    }

    public void testHasMoveableColumns() {
        IListRidget ridget = this.getRidget();
        ListRidgetTest.assertFalse((boolean)ridget.hasMoveableColumns());
        try {
            ridget.setMoveableColumns(true);
            ListRidgetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.ok();
        }
    }

    public void testOutputSingleSelectionCannotBeChangedFromUI() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)" ");
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)" ");
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testOutputMultipleSelectionCannotBeChangedFromUI() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)" ");
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)" ");
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testTogglingOutputDoesNotChangeSelection() {
        IListRidget ridget = this.getRidget();
        ridget.setSelection(0);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(true);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setSelection(null);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(false);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
    }

    public void testDisabledListIsEmptyFromRidget() {
        if (!MarkerSupport.isHideDisabledRidgetContent()) {
            System.out.println("Skipping ListRidgetTest.testDisabledListIsEmptyFromRidget()");
            return;
        }
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        this.getRidget().bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        ridget.setSelection((Object)this.person1);
        ListRidgetTest.assertEquals((String)this.person1.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(false);
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        ridget.setSelection((Object)this.person2);
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(true);
        ListRidgetTest.assertEquals((String)this.person2.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
    }

    public void testDisabledListIsEmptyFromModel() {
        if (!MarkerSupport.isHideDisabledRidgetContent()) {
            System.out.println("Skipping ListRidgetTest.testDisabledListIsEmptyFromModel()");
            return;
        }
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        this.getRidget().bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        this.manager.setSelectedPerson(this.person1);
        ridget.updateSingleSelectionFromModel();
        ListRidgetTest.assertEquals((String)this.person1.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(false);
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        this.manager.setSelectedPerson(this.person2);
        ridget.updateSingleSelectionFromModel();
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(true);
        ListRidgetTest.assertEquals((String)this.person2.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
    }

    public void testDisabledDoesNotFireSelection() {
        IListRidget ridget = this.getRidget();
        FTPropertyChangeListener listener = new FTPropertyChangeListener();
        ridget.addPropertyChangeListener("selection", (PropertyChangeListener)listener);
        ridget.setSelection((Object)this.person1);
        int count = listener.getCount();
        ridget.setEnabled(false);
        ListRidgetTest.assertEquals((int)count, (int)listener.getCount());
        ridget.setSelection((Object)this.person2);
        count = listener.getCount();
        ridget.setEnabled(true);
        ListRidgetTest.assertTrue((count < listener.getCount() ? 1 : 0) != 0);
    }

    public void testDisableWithoutBoundModel() {
        ListRidget ridget = (ListRidget)this.createRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ridget.setUIControl((Object)control);
        ListRidgetTest.assertNull((Object)ridget.getObservableList());
        ridget.setEnabled(false);
        ListRidgetTest.assertFalse((boolean)ridget.isEnabled());
        ListRidgetTest.assertFalse((boolean)control.isEnabled());
        ridget.setEnabled(true);
        ListRidgetTest.assertTrue((boolean)ridget.isEnabled());
        ListRidgetTest.assertTrue((boolean)control.isEnabled());
    }

    public void testDisableAndClearOnBind() {
        if (!MarkerSupport.isHideDisabledRidgetContent()) {
            System.out.println("Skipping ListRidgetTest.testDisableAndClearOnBind()");
            return;
        }
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        this.getRidget().bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        ridget.setUIControl(null);
        ridget.setEnabled(false);
        this.manager.setSelectedPerson(this.person1);
        ridget.updateSingleSelectionFromModel();
        ridget.setUIControl((Object)control);
        ListRidgetTest.assertFalse((boolean)control.isEnabled());
        ListRidgetTest.assertEquals((String)"", (String)control.getItem(0));
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ridget.setEnabled(true);
        ListRidgetTest.assertTrue((boolean)control.isEnabled());
        ListRidgetTest.assertTrue((control.getItem(0).length() > 0 ? 1 : 0) != 0);
        ListRidgetTest.assertTrue((control.getSelectionIndex() > -1 ? 1 : 0) != 0);
        ListRidgetTest.assertEquals((int)this.manager.getPersons().size(), (int)control.getItemCount());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
    }

    public void testAddSelectionListener() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        try {
            ridget.addSelectionListener(null);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        TestSelectionListener selectionListener = new TestSelectionListener();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelection((Object)this.person1);
        ListRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelection((Object)this.person2);
        ListRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        ridget.clearSelection();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        ListRidgetTest.assertEquals((int)2, (int)selectionListener.getCount());
        SelectionEvent selectionEvent = selectionListener.getSelectionEvent();
        ListRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        ListRidgetTest.assertTrue((boolean)selectionEvent.getOldSelection().isEmpty());
        ListRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)selectionEvent.getNewSelection());
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        ListRidgetTest.assertEquals((int)3, (int)selectionListener.getCount());
        SelectionEvent selectionEvent2 = selectionListener.getSelectionEvent();
        ListRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        ListRidgetTest.assertEquals((Object)selectionEvent.getNewSelection(), (Object)selectionEvent2.getOldSelection());
        ListRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)selectionEvent2.getNewSelection());
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
    }

    public void testSimplifiedBinding() {
        org.eclipse.swt.widgets.List control = new org.eclipse.swt.widgets.List((Composite)this.getShell(), 0);
        IListRidget ridget = this.createRidget();
        ridget.setUIControl((Object)control);
        SimplifiedModel model = new SimplifiedModel();
        ridget.bindToModel((Object)model, "values");
        ListRidgetTest.assertEquals(null, (Object)ridget.getObservableList());
        ridget.updateFromModel();
        ListRidgetTest.assertEquals((int)3, (int)ridget.getObservableList().size());
        ListRidgetTest.assertEquals((int)model.getValues().size(), (int)control.getItemCount());
        ListRidgetTest.assertEquals((String)"Janet", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Jermaine", (String)control.getItem(1));
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(2));
    }

    public void testRebindToSimpleModel() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ListRidgetTest.assertTrue((boolean)(ridget.getObservableList().get(0) instanceof Person));
        SimplifiedModel model = new SimplifiedModel();
        ridget.bindToModel((Object)model, "values");
        ridget.updateFromModel();
        ListRidgetTest.assertTrue((boolean)(ridget.getObservableList().get(0) instanceof String));
        ListRidgetTest.assertEquals((String)"Janet", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Jermaine", (String)control.getItem(1));
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(2));
    }

    public void testRefreshNull() {
        IListRidget ridget = this.createRidget();
        org.eclipse.swt.widgets.List control = this.createWidget((Composite)this.getShell());
        ridget.setUIControl((Object)control);
        StringPojo word1 = new StringPojo("eclipse");
        StringPojo word2 = new StringPojo("riena");
        WritableList values = new WritableList(Arrays.asList(word1, word2), StringPojo.class);
        String[] columns = new String[]{"value"};
        ridget.bindToModel((IObservableList)values, StringPojo.class, columns, null);
        ridget.updateFromModel();
        ListRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"riena", (String)control.getItem(1));
        word1.setValue("alpha");
        word2.setValue("beta");
        ListRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"riena", (String)control.getItem(1));
        ridget.refresh(null);
        ListRidgetTest.assertEquals((String)"alpha", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"beta", (String)control.getItem(1));
    }

    public void testRefresh() {
        IListRidget ridget = this.createRidget();
        org.eclipse.swt.widgets.List control = this.createWidget((Composite)this.getShell());
        ridget.setUIControl((Object)control);
        StringPojo word1 = new StringPojo("eclipse");
        StringPojo word2 = new StringPojo("riena");
        WritableList values = new WritableList(Arrays.asList(word1, word2), StringPojo.class);
        String[] columns = new String[]{"value"};
        ridget.bindToModel((IObservableList)values, StringPojo.class, columns, null);
        ridget.updateFromModel();
        ListRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"riena", (String)control.getItem(1));
        word1.setValue("alpha");
        word2.setValue("beta");
        ListRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"riena", (String)control.getItem(1));
        ridget.refresh((Object)word1);
        ListRidgetTest.assertEquals((String)"alpha", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"riena", (String)control.getItem(1));
    }

    public void testGetOptionWithSorting() {
        IListRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.manager, "persons", Person.class, "lastname");
        ridget.updateFromModel();
        ListRidgetTest.assertEquals((int)0, (int)ridget.indexOfOption((Object)this.person1));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)ridget.getOption(0));
        ridget.setComparator(0, (Comparator)new StringComparator());
        ridget.setSortedColumn(0);
        ridget.setSortedAscending(false);
        int last = ridget.getOptionCount() - 1;
        ListRidgetTest.assertEquals((int)last, (int)ridget.indexOfOption((Object)this.person1));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)ridget.getOption(last));
        ridget.setSortedAscending(true);
        ListRidgetTest.assertEquals((int)0, (int)ridget.indexOfOption((Object)this.person1));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)ridget.getOption(0));
    }

    public void testSetSelectionWithSorting() {
        IListRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.manager, "persons", Person.class, "lastname");
        ridget.updateFromModel();
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        ListRidgetTest.assertTrue((boolean)ridget.getSelection().isEmpty());
        ridget.setSelection(0);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ridget.setComparator(0, (Comparator)new StringComparator());
        ridget.setSortedColumn(0);
        ridget.setSortedAscending(false);
        int last = ridget.getOptionCount() - 1;
        ListRidgetTest.assertEquals((int)last, (int)ridget.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ridget.setSortedAscending(true);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
    }

    @Override
    protected void clearUIControlRowSelection() {
        this.getWidget().deselectAll();
        this.fireSelectionEvent();
    }

    @Override
    protected int getUIControlSelectedRowCount() {
        return this.getWidget().getSelectionCount();
    }

    @Override
    protected int getUIControlSelectedRow() {
        return this.getWidget().getSelectionIndex();
    }

    @Override
    protected Object getRowValue(int i) {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        return rowObservables.get(i);
    }

    @Override
    protected int[] getSelectedRows() {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        Object[] elements = this.getRidget().getMultiSelectionObservable().toArray();
        int[] result = new int[elements.length];
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            result[i] = rowObservables.indexOf(element);
            ++i;
        }
        return result;
    }

    @Override
    protected int[] getUIControlSelectedRows() {
        return this.getWidget().getSelectionIndices();
    }

    @Override
    protected void setUIControlRowSelection(int[] indices) {
        this.getWidget().setSelection(indices);
        this.fireSelectionEvent();
    }

    @Override
    protected void setUIControlRowSelectionInterval(int start, int end) {
        this.getWidget().setSelection(start, end);
        this.fireSelectionEvent();
    }

    @Override
    protected boolean supportsMulti() {
        return true;
    }

    private static final class FTPropertyChangeListener
    implements PropertyChangeListener {
        private int count;

        private FTPropertyChangeListener() {
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
        }
    }

    private static final class SimplifiedModel {
        private final List<String> values = Arrays.asList("Janet", "Jermaine", "John");
        private static final String NAME_ONE = "Janet";
        private static final String NAME_TWO = "Jermaine";
        private static final String NAME_THREE = "John";

        public List<String> getValues() {
            return this.values;
        }
    }

    private static final class StringComparator
    implements Comparator<Object> {
        private StringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    }
}

