/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.monitor.client.Range;

@NonUITestCase
public class RangeTest
extends TestCase {
    public void testEmptyRange() {
        Range range = new Range("");
        RangeTest.assertFalse((boolean)range.matches(1));
        RangeTest.assertFalse((boolean)range.matches(2));
        RangeTest.assertFalse((boolean)range.matches(3));
    }

    public void testAllRange() {
        Range range = new Range("*");
        RangeTest.assertTrue((boolean)range.matches(-3));
        RangeTest.assertTrue((boolean)range.matches(-2));
        RangeTest.assertTrue((boolean)range.matches(-1));
        RangeTest.assertTrue((boolean)range.matches(0));
        RangeTest.assertTrue((boolean)range.matches(1));
        RangeTest.assertTrue((boolean)range.matches(2));
        RangeTest.assertTrue((boolean)range.matches(3));
    }

    public void testSingleValue() {
        Range range = new Range("2");
        RangeTest.assertFalse((boolean)range.matches(1));
        RangeTest.assertTrue((boolean)range.matches(2));
        RangeTest.assertFalse((boolean)range.matches(3));
    }

    public void testDoubleValue() {
        Range range = new Range("2, 9");
        RangeTest.assertFalse((boolean)range.matches(1));
        RangeTest.assertTrue((boolean)range.matches(2));
        RangeTest.assertFalse((boolean)range.matches(3));
        RangeTest.assertTrue((boolean)range.matches(9));
    }

    public void testSingleRangeInterval() {
        Range range = new Range("1..3");
        RangeTest.assertTrue((boolean)range.matches(1));
        RangeTest.assertTrue((boolean)range.matches(2));
        RangeTest.assertTrue((boolean)range.matches(3));
    }

    public void testRangeIntervalPlusValue() {
        Range range = new Range("1..3,5");
        RangeTest.assertTrue((boolean)range.matches(1));
        RangeTest.assertTrue((boolean)range.matches(2));
        RangeTest.assertTrue((boolean)range.matches(3));
        RangeTest.assertFalse((boolean)range.matches(4));
        RangeTest.assertTrue((boolean)range.matches(5));
    }

    public void testValuePlusRangeIntervalPlusValue() {
        Range range = new Range("-2, 1..3 , 5");
        RangeTest.assertTrue((boolean)range.matches(-2));
        RangeTest.assertFalse((boolean)range.matches(-1));
        RangeTest.assertFalse((boolean)range.matches(0));
        RangeTest.assertTrue((boolean)range.matches(1));
        RangeTest.assertTrue((boolean)range.matches(2));
        RangeTest.assertTrue((boolean)range.matches(3));
        RangeTest.assertFalse((boolean)range.matches(4));
        RangeTest.assertTrue((boolean)range.matches(5));
    }

    public void testSingleRangeOpenOpenPlusRangeCloseClose() {
        Range range = new Range("-2..0, 10..12");
        RangeTest.assertFalse((boolean)range.matches(-3));
        RangeTest.assertTrue((boolean)range.matches(-2));
        RangeTest.assertTrue((boolean)range.matches(-1));
        RangeTest.assertTrue((boolean)range.matches(0));
        RangeTest.assertFalse((boolean)range.matches(1));
        RangeTest.assertFalse((boolean)range.matches(9));
        RangeTest.assertTrue((boolean)range.matches(10));
        RangeTest.assertTrue((boolean)range.matches(11));
        RangeTest.assertTrue((boolean)range.matches(12));
        RangeTest.assertFalse((boolean)range.matches(13));
    }

    public void testSingleValueError() {
        try {
            new Range("n");
            RangeTest.fail();
        }
        catch (IllegalArgumentException t) {
            System.out.println("Expected error: " + t);
        }
    }

    public void testIncompleteInterval() {
        try {
            new Range("1..");
            RangeTest.fail();
        }
        catch (IllegalArgumentException t) {
            System.out.println("Expected error: " + t);
        }
    }
}

