/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IJumpTargetListener;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SimpleNavigationNodeAdapter;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.NavigationNodeController;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.IRidget;

@NonUITestCase
public class NavigationProcessorTest
extends RienaTestCase {
    private static final String TARGET_MODULE_GROUP = "org.eclipse.riena.navigation.model.test.moduleGroup.2";
    private NavigationProcessor navigationProcessor;
    private IApplicationNode applicationNode;
    private ISubApplicationNode subApplication;
    private IModuleGroupNode moduleGroup;
    private IModuleNode module;
    private ISubModuleNode subModule1;
    private ISubModuleNode subModule2;
    private ISubModuleNode subModule3;
    private TestSubModuleNode subModule4;
    private ModuleGroupNode moduleGroup2;
    private ModuleNode module2;

    protected void setUp() throws Exception {
        super.setUp();
        this.initializeNavigationStructure();
    }

    private void initializeNavigationStructure() {
        this.applicationNode = new ApplicationNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.application"));
        this.navigationProcessor = new NavigationProcessor();
        this.applicationNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        this.subApplication = new SubApplicationNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subApplication"));
        this.applicationNode.addChild((INavigationNode)this.subApplication);
        this.moduleGroup = new ModuleGroupNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.moduleGroup"));
        this.subApplication.addChild((INavigationNode)this.moduleGroup);
        this.moduleGroup2 = new ModuleGroupNode(new NavigationNodeId(TARGET_MODULE_GROUP));
        this.subApplication.addChild((INavigationNode)this.moduleGroup2);
        this.module = new ModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.module"));
        this.moduleGroup.addChild((INavigationNode)this.module);
        this.module2 = new ModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.module.2"));
        this.moduleGroup.addChild((INavigationNode)this.module2);
        this.subModule1 = new SubModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule"));
        this.module.addChild((INavigationNode)this.subModule1);
        this.subModule2 = new SubModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule2"));
        this.module.addChild((INavigationNode)this.subModule2);
        this.subModule3 = new SubModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule3"));
        this.module.addChild((INavigationNode)this.subModule3);
        this.subModule4 = new TestSubModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule4"));
        this.module2.addChild((INavigationNode)this.subModule4);
    }

    protected void tearDown() throws Exception {
        this.applicationNode = null;
        super.tearDown();
    }

    public void testNavigateToRidget() throws Exception {
        final IRidget ridgetStubWithoutFocus = (IRidget)EasyMock.createStrictMock(IRidget.class);
        EasyMock.expect((Object)ridgetStubWithoutFocus.hasFocus()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{ridgetStubWithoutFocus});
        final IRidget ridgetStub = (IRidget)EasyMock.createStrictMock(IRidget.class);
        ridgetStub.requestFocus();
        EasyMock.expect((Object)ridgetStub.hasFocus()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{ridgetStub});
        NavigationNodeController<ISubModuleNode> nodeControllerStub = new NavigationNodeController<ISubModuleNode>(){

            public void configureRidgets() {
            }

            public IRidget getRidget(String id) {
                return "myRidget".equals(id) ? ridgetStub : ridgetStubWithoutFocus;
            }
        };
        this.subModule1.setNavigationNodeController((INavigationNodeController)nodeControllerStub);
        this.navigationProcessor.activate((INavigationNode)this.subApplication);
        this.navigationProcessor.navigate((INavigationNode)this.subApplication, new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule"), new NavigationArgument(null, "myRidget"));
    }

    public void testIsSelectable() {
        NavigationNodeId id = new NavigationNodeId("4711");
        TestSubModuleNode node = new TestSubModuleNode(id);
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"isSelectable", (Object[])new Object[]{node});
        NavigationProcessorTest.assertTrue((boolean)ret);
        node.setSelectable(false);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"isSelectable", (Object[])new Object[]{node});
        NavigationProcessorTest.assertFalse((boolean)ret);
        node.setSelectable(true);
        node.setEnabled(false);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"isSelectable", (Object[])new Object[]{node});
        NavigationProcessorTest.assertFalse((boolean)ret);
        node.setEnabled(true);
        node.setVisible(false);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"isSelectable", (Object[])new Object[]{node});
        NavigationProcessorTest.assertFalse((boolean)ret);
        node.setVisible(true);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"isSelectable", (Object[])new Object[]{node});
        NavigationProcessorTest.assertTrue((boolean)ret);
        HiddenMarker marker = new HiddenMarker(false);
        node.addMarker((IMarker)marker);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"isSelectable", (Object[])new Object[]{node});
        NavigationProcessorTest.assertFalse((boolean)ret);
        node.removeMarker((IMarker)marker);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"isSelectable", (Object[])new Object[]{node});
        NavigationProcessorTest.assertTrue((boolean)ret);
        marker = new DisabledMarker(false);
        node.addMarker((IMarker)marker);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"isSelectable", (Object[])new Object[]{node});
        NavigationProcessorTest.assertFalse((boolean)ret);
        node.removeMarker((IMarker)marker);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"isSelectable", (Object[])new Object[]{node});
        NavigationProcessorTest.assertTrue((boolean)ret);
    }

    public void testGetSelectableChild() {
        ModuleGroupNode mg1 = new ModuleGroupNode(new NavigationNodeId("mg1"));
        ModuleNode m1 = new ModuleNode(new NavigationNodeId("m1"));
        SubModuleNode sm1 = new SubModuleNode(new NavigationNodeId("sm1"));
        SubModuleNode sm11 = new SubModuleNode(new NavigationNodeId("sm11"));
        SubModuleNode sm12 = new SubModuleNode(new NavigationNodeId("sm12"));
        mg1.addChild((INavigationNode)m1);
        m1.addChild((INavigationNode)sm1);
        sm1.addChild((INavigationNode)sm11);
        sm1.addChild((INavigationNode)sm12);
        INavigationNode ret = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getSelectableChild", (Object[])new Object[]{mg1});
        NavigationProcessorTest.assertSame((Object)m1, (Object)ret);
        ret = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getSelectableChild", (Object[])new Object[]{m1});
        NavigationProcessorTest.assertSame((Object)sm1, (Object)ret);
        ret = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getSelectableChild", (Object[])new Object[]{sm1});
        NavigationProcessorTest.assertSame((Object)sm11, (Object)ret);
        sm11.setSelectable(false);
        ret = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getSelectableChild", (Object[])new Object[]{sm1});
        NavigationProcessorTest.assertSame((Object)sm12, (Object)ret);
        sm1.setSelectable(false);
        ret = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getSelectableChild", (Object[])new Object[]{m1});
        NavigationProcessorTest.assertSame((Object)sm12, (Object)ret);
    }

    public void testActivateChildren() throws Exception {
        NavigationProcessorTest.assertFalse((boolean)this.subApplication.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.moduleGroup.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.module.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.subModule1.isActivated());
        this.navigationProcessor.activate((INavigationNode)this.subApplication);
        NavigationProcessorTest.assertTrue((boolean)this.subApplication.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.moduleGroup.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.module.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.subModule1.isActivated());
        this.subApplication.deactivate(null);
        this.moduleGroup.deactivate(null);
        this.module.deactivate(null);
        this.subModule1.deactivate(null);
        this.subApplication.setEnabled(false);
        this.navigationProcessor.activate((INavigationNode)this.subApplication);
        NavigationProcessorTest.assertFalse((boolean)this.subApplication.isActivated());
        this.subApplication.setEnabled(true);
        this.subApplication.setVisible(false);
        this.navigationProcessor.activate((INavigationNode)this.subApplication);
        NavigationProcessorTest.assertFalse((boolean)this.subApplication.isActivated());
    }

    public void testCheckActiveNodes() {
        this.navigationProcessor.activate((INavigationNode)this.subApplication);
        NavigationProcessorTest.assertTrue((boolean)this.subApplication.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.moduleGroup.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.moduleGroup2.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.module.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.module2.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.subModule1.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.subModule2.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.subModule3.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.subModule4.isActivated());
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"checkActiveNodes", (Object[])new Object[]{this.module});
        NavigationProcessorTest.assertTrue((boolean)ret);
        ReflectionUtils.invokeHidden((Object)((Object)this.subModule4), (String)"setState", (Object[])new Object[]{INavigationNode.State.ACTIVATED});
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"checkActiveNodes", (Object[])new Object[]{this.module});
        NavigationProcessorTest.assertFalse((boolean)ret);
        ReflectionUtils.invokeHidden((Object)this.moduleGroup2, (String)"setState", (Object[])new Object[]{INavigationNode.State.ACTIVATED});
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"checkActiveNodes", (Object[])new Object[]{this.module});
        NavigationProcessorTest.assertFalse((boolean)ret);
        ReflectionUtils.invokeHidden((Object)this.subModule1, (String)"setState", (Object[])new Object[]{INavigationNode.State.DEACTIVATED});
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"checkActiveNodes", (Object[])new Object[]{this.module});
        NavigationProcessorTest.assertFalse((boolean)ret);
        ReflectionUtils.invokeHidden((Object)this.moduleGroup, (String)"setState", (Object[])new Object[]{INavigationNode.State.DEACTIVATED});
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"checkActiveNodes", (Object[])new Object[]{this.module});
        NavigationProcessorTest.assertTrue((boolean)ret);
    }

    public void testDefaultJump() throws Exception {
        DummyJumpTargetListener listener = new DummyJumpTargetListener();
        this.subModule1.activate();
        this.subModule2.addJumpTargetListener((IJumpTargetListener)listener);
        this.subModule1.jump(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule2"));
        NavigationProcessorTest.assertSame((Object)this.subModule2, (Object)listener.node);
        NavigationProcessorTest.assertSame((Object)IJumpTargetListener.JumpTargetState.ENABLED, (Object)listener.jumpTargetState);
        listener.reset();
        NavigationProcessorTest.assertTrue((boolean)this.subModule2.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.subModule2.isJumpTarget());
        this.subModule2.jumpBack();
        NavigationProcessorTest.assertSame((Object)this.subModule2, (Object)listener.node);
        NavigationProcessorTest.assertSame((Object)IJumpTargetListener.JumpTargetState.DISABLED, (Object)listener.jumpTargetState);
        NavigationProcessorTest.assertFalse((boolean)this.subModule2.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)this.subModule1.isActivated());
        this.subModule1.jump(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule2"));
        this.subModule2.jump(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule3"));
        NavigationProcessorTest.assertTrue((boolean)this.subModule3.isActivated());
        this.subModule2.dispose();
        this.subModule3.jumpBack();
        NavigationProcessorTest.assertTrue((boolean)this.subModule3.isActivated());
        this.subModule2 = new SubModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule2"));
        this.module.addChild((INavigationNode)this.subModule2);
        this.subModule1.activate();
        this.subModule1.jump(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule2"));
        this.subModule2.navigate(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule3"));
        this.subModule3.jump(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule2"));
        this.subModule2.jumpBack();
        NavigationProcessorTest.assertTrue((boolean)this.subModule3.isActivated());
    }

    public void testDeepJump() throws Exception {
        this.subModule1.activate();
        this.subModule1.jump(new NavigationNodeId("org.eclipse.riena.navigation.model.test.module.2"));
        NavigationProcessorTest.assertTrue((boolean)this.module2.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)this.subModule4.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)this.subModule4.isActivated());
        this.subModule4.jumpBack();
        NavigationProcessorTest.assertTrue((boolean)this.subModule1.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.subModule4.isJumpTarget());
        NavigationProcessorTest.assertFalse((boolean)this.module2.isJumpTarget());
    }

    public void testGetActivatableNodes() {
        NavigationNodeId id = new NavigationNodeId("4711");
        SubModuleNode node = new SubModuleNode(id);
        node.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        id = new NavigationNodeId("0815");
        SubModuleNode node2 = new SubModuleNode(id);
        node2.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        id = new NavigationNodeId("node3");
        SubModuleNode node3 = new SubModuleNode(id);
        node3.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        id = new NavigationNodeId("node4");
        SubModuleNode node4 = new SubModuleNode(id);
        node4.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        ArrayList<SubModuleNode> nodes = new ArrayList<SubModuleNode>();
        nodes.add(node);
        nodes.add(node2);
        nodes.add(node3);
        nodes.add(node4);
        List activateableNodes = (List)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActivatableNodes", (Object[])new Object[]{nodes});
        NavigationProcessorTest.assertTrue((activateableNodes.size() == 4 ? 1 : 0) != 0);
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node));
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node2));
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node3));
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node4));
        node2.addMarker((IMarker)new DisabledMarker());
        node3.addMarker((IMarker)new HiddenMarker());
        node3.addMarker((IMarker)new OutputMarker());
        activateableNodes = (List)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActivatableNodes", (Object[])new Object[]{nodes});
        NavigationProcessorTest.assertTrue((activateableNodes.size() == 2 ? 1 : 0) != 0);
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node));
        NavigationProcessorTest.assertFalse((boolean)activateableNodes.contains(node2));
        NavigationProcessorTest.assertFalse((boolean)activateableNodes.contains(node3));
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node4));
    }

    public void testGetNodesToActivateOnDispose() {
        ModuleGroupNode mg1 = new ModuleGroupNode(new NavigationNodeId("mg1"));
        ModuleNode m1 = new ModuleNode(new NavigationNodeId("m1"));
        SubModuleNode sm1 = new SubModuleNode(new NavigationNodeId("sm1"));
        SubModuleNode sm11 = new SubModuleNode(new NavigationNodeId("sm11"));
        SubModuleNode sm12 = new SubModuleNode(new NavigationNodeId("sm12"));
        mg1.addChild((INavigationNode)m1);
        m1.addChild((INavigationNode)sm1);
        sm1.addChild((INavigationNode)sm11);
        sm1.addChild((INavigationNode)sm12);
        List nodes = (List)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodesToActivateOnDispose", (Object[])new Object[]{sm12});
        NavigationProcessorTest.assertEquals((int)0, (int)nodes.size());
        sm12.activate();
        nodes = (List)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodesToActivateOnDispose", (Object[])new Object[]{sm12});
        NavigationProcessorTest.assertNotNull((Object)nodes);
        NavigationProcessorTest.assertEquals((int)1, (int)nodes.size());
        NavigationProcessorTest.assertSame((Object)sm11, nodes.get(0));
        sm11.activate();
        nodes = (List)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodesToActivateOnDispose", (Object[])new Object[]{sm11});
        NavigationProcessorTest.assertNotNull((Object)nodes);
        NavigationProcessorTest.assertEquals((int)1, (int)nodes.size());
        NavigationProcessorTest.assertSame((Object)sm12, nodes.get(0));
        sm1.removeChild((INavigationNode)sm12);
        nodes = (List)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodesToActivateOnDispose", (Object[])new Object[]{sm11});
        NavigationProcessorTest.assertNotNull((Object)nodes);
        NavigationProcessorTest.assertEquals((int)1, (int)nodes.size());
        NavigationProcessorTest.assertSame((Object)sm1, nodes.get(0));
    }

    public void testGetChildToActivate() {
        NavigationNodeId id = new NavigationNodeId("4711");
        SubModuleNode node = new SubModuleNode(id);
        INavigationNode toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{node});
        NavigationProcessorTest.assertNull((Object)toActivate);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertNull((Object)toActivate);
        moduleNode.addChild((INavigationNode)node);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)node, (Object)toActivate);
        id = new NavigationNodeId("sm2");
        SubModuleNode node2 = new SubModuleNode(id);
        moduleNode.addChild((INavigationNode)node2);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)node, (Object)toActivate);
        node2.setSelected(true);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)node2, (Object)toActivate);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertSame((Object)moduleNode, (Object)toActivate);
        DisabledMarker disabledMarker = new DisabledMarker();
        moduleNode.addMarker((IMarker)disabledMarker);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertNull((Object)toActivate);
        moduleNode.removeAllMarkers();
        moduleNode.addMarker((IMarker)new OutputMarker());
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertSame((Object)moduleNode, (Object)toActivate);
        moduleNode.addMarker((IMarker)new HiddenMarker());
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertNull((Object)toActivate);
    }

    public void testDispose() {
        NavigationNodeId id = new NavigationNodeId("4711");
        TestSubModuleNode node = new TestSubModuleNode(id);
        id = new NavigationNodeId("0815");
        TestSubModuleNode node2 = new TestSubModuleNode(id);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        moduleNode.addChild((INavigationNode)node2);
        id = new NavigationNodeId("m2");
        ModuleNode moduleNode2 = new ModuleNode(id);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        moduleGroupNode.addChild((INavigationNode)moduleNode2);
        this.navigationProcessor.activate((INavigationNode)node2);
        node2.setAllowsDeactivate(false);
        this.navigationProcessor.dispose((INavigationNode)node2);
        NavigationProcessorTest.assertFalse((boolean)node2.isDisposed());
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node2.setAllowsDeactivate(true);
        node2.setAllowsDispose(false);
        this.navigationProcessor.dispose((INavigationNode)node2);
        NavigationProcessorTest.assertFalse((boolean)node2.isDisposed());
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node2.setAllowsDispose(true);
        node.setAllowsActivate(false);
        this.navigationProcessor.dispose((INavigationNode)node2);
        NavigationProcessorTest.assertFalse((boolean)node2.isDisposed());
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node.setAllowsActivate(true);
        this.navigationProcessor.dispose((INavigationNode)node2);
        NavigationProcessorTest.assertTrue((boolean)node2.isDisposed());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        this.navigationProcessor.dispose((INavigationNode)node2);
        NavigationProcessorTest.assertTrue((boolean)node2.isDisposed());
        this.navigationProcessor.dispose((INavigationNode)moduleNode2);
        NavigationProcessorTest.assertTrue((boolean)moduleNode2.isDisposed());
        NavigationProcessorTest.assertFalse((boolean)moduleGroupNode.isDisposed());
        this.navigationProcessor.dispose((INavigationNode)moduleNode);
        NavigationProcessorTest.assertTrue((boolean)moduleNode.isDisposed());
        NavigationProcessorTest.assertTrue((boolean)moduleGroupNode.isDisposed());
    }

    public void testDisposeWithNavigateAfterDispose() {
        this.navigationProcessor.activate((INavigationNode)this.subModule3);
        NavigationProcessorTest.assertTrue((boolean)this.subModule3.isActivated());
        this.navigationProcessor.dispose((INavigationNode)this.subModule3);
        NavigationProcessorTest.assertTrue((boolean)this.subModule1.isActivated());
        this.navigationProcessor.activate((INavigationNode)this.subModule2);
        NavigationProcessorTest.assertTrue((boolean)this.subModule2.isActivated());
        this.subModule2.setContext("riena.navigation.navigateAfterDispose", (Object)this.subModule4.getNodeId());
        this.navigationProcessor.dispose((INavigationNode)this.subModule2);
        NavigationProcessorTest.assertTrue((boolean)this.subModule4.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.subModule2.isActivated());
    }

    public void testGetNodeToDispose() {
        NavigationNodeId id = new NavigationNodeId("4711");
        SubModuleNode node = new SubModuleNode(id);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        id = new NavigationNodeId("m2");
        ModuleNode moduleNode2 = new ModuleNode(id);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        moduleGroupNode.addChild((INavigationNode)moduleNode2);
        INavigationNode toDispose = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodeToDispose", (Object[])new Object[]{node});
        NavigationProcessorTest.assertSame((Object)node, (Object)toDispose);
        toDispose = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodeToDispose", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)toDispose);
        toDispose = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodeToDispose", (Object[])new Object[]{moduleNode2});
        NavigationProcessorTest.assertSame((Object)moduleNode2, (Object)toDispose);
        toDispose = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodeToDispose", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)toDispose);
    }

    public void testAddMarker() {
        DisabledMarker disabledMarker = new DisabledMarker();
        HiddenMarker hiddenMarker = new HiddenMarker();
        ErrorMarker errorMarker = new ErrorMarker();
        this.navigationProcessor.addMarker(null, (IMarker)disabledMarker);
        NavigationNodeId id = new NavigationNodeId("4711");
        TestSubModuleNode node = new TestSubModuleNode(id);
        id = new NavigationNodeId("0815");
        TestSubModuleNode node2 = new TestSubModuleNode(id);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        moduleNode.addChild((INavigationNode)node2);
        moduleNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        this.navigationProcessor.addMarker((INavigationNode)node, (IMarker)disabledMarker);
        NavigationProcessorTest.assertFalse((boolean)node.isEnabled());
        NavigationProcessorTest.assertTrue((boolean)node.isVisible());
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertTrue((boolean)node2.isEnabled());
        NavigationProcessorTest.assertFalse((boolean)node2.isVisible());
        node.removeAllMarkers();
        node2.removeAllMarkers();
        node.setSelected(true);
        this.navigationProcessor.addMarker((INavigationNode)node, (IMarker)disabledMarker);
        NavigationProcessorTest.assertFalse((boolean)node.isEnabled());
        NavigationProcessorTest.assertFalse((boolean)node.isSelected());
        node.setSelected(true);
        this.navigationProcessor.addMarker((INavigationNode)node, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertFalse((boolean)node.isVisible());
        NavigationProcessorTest.assertFalse((boolean)node.isSelected());
        node.setSelected(true);
        this.navigationProcessor.addMarker((INavigationNode)node, (IMarker)errorMarker);
        NavigationProcessorTest.assertTrue((boolean)node.isSelected());
        node.removeAllMarkers();
        node2.removeAllMarkers();
        node2.activate();
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)errorMarker);
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node2.removeAllMarkers();
        node2.activate();
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)disabledMarker);
        NavigationProcessorTest.assertFalse((boolean)node2.isActivated());
        NavigationProcessorTest.assertFalse((boolean)node2.isEnabled());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        node2.removeAllMarkers();
        node2.activate();
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertFalse((boolean)node2.isActivated());
        NavigationProcessorTest.assertFalse((boolean)node2.isVisible());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        node2.removeAllMarkers();
        node2.activate();
        node2.setAllowsDeactivate(false);
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertTrue((boolean)node2.isVisible());
        NavigationProcessorTest.assertFalse((boolean)node.isActivated());
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node2.removeAllMarkers();
        node2.activate();
        node2.setAllowsDeactivate(true);
        node.setAllowsActivate(false);
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertTrue((boolean)node2.isVisible());
        NavigationProcessorTest.assertFalse((boolean)node.isActivated());
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node2.removeAllMarkers();
        node2.activate();
        node.setAllowsActivate(true);
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertFalse((boolean)node2.isVisible());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        NavigationProcessorTest.assertFalse((boolean)node2.isActivated());
    }

    public void testGetTopParent() {
        NavigationNodeId id = new NavigationNodeId("4711");
        TestSubModuleNode node = new TestSubModuleNode(id);
        id = new NavigationNodeId("0815");
        TestSubModuleNode node2 = new TestSubModuleNode(id);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        moduleNode.addChild((INavigationNode)node2);
        id = new NavigationNodeId("m2");
        ModuleNode moduleNode2 = new ModuleNode(id);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        INavigationNode top = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getTopParent", (Object[])new Object[]{node});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)top);
        top = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getTopParent", (Object[])new Object[]{node2});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)top);
        top = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getTopParent", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)top);
        top = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getTopParent", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)top);
        top = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getTopParent", (Object[])new Object[]{moduleNode2});
        NavigationProcessorTest.assertSame((Object)moduleNode2, (Object)top);
    }

    public void testGetNextActiveParent() {
        NavigationNodeId id = new NavigationNodeId("4711");
        TestSubModuleNode node = new TestSubModuleNode(id);
        id = new NavigationNodeId("0815");
        TestSubModuleNode node2 = new TestSubModuleNode(id);
        node.addChild((INavigationNode)node2);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        id = new NavigationNodeId("m2");
        ModuleNode moduleNode2 = new ModuleNode(id);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        moduleGroupNode.addChild((INavigationNode)moduleNode2);
        moduleGroupNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        INavigationNode parent = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNextActiveParent", (Object[])new Object[]{node2});
        NavigationProcessorTest.assertNull((Object)parent);
        node.activate();
        parent = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNextActiveParent", (Object[])new Object[]{node2});
        NavigationProcessorTest.assertSame((Object)moduleNode, (Object)parent);
        node.deactivate(null);
        parent = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNextActiveParent", (Object[])new Object[]{node2});
        NavigationProcessorTest.assertSame((Object)moduleNode, (Object)parent);
        moduleNode.deactivate(null);
        parent = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNextActiveParent", (Object[])new Object[]{node2});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)parent);
    }

    public void testGetActiveChild() {
        NavigationNodeId id = new NavigationNodeId("4711");
        TestSubModuleNode node = new TestSubModuleNode(id);
        id = new NavigationNodeId("0815");
        TestSubModuleNode node2 = new TestSubModuleNode(id);
        node.addChild((INavigationNode)node2);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        id = new NavigationNodeId("m2");
        ModuleNode moduleNode2 = new ModuleNode(id);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        moduleGroupNode.addChild((INavigationNode)moduleNode2);
        moduleGroupNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        INavigationNode child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{node});
        NavigationProcessorTest.assertNull((Object)child);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertNull((Object)child);
        node.setSelected(true);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{node});
        NavigationProcessorTest.assertNull((Object)child);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertNull((Object)child);
        node.activate();
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{node});
        NavigationProcessorTest.assertNull((Object)child);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)((Object)node), (Object)child);
        node2.setSelected(true);
        node2.activate();
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{node});
        NavigationProcessorTest.assertNull((Object)child);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)((Object)node2), (Object)child);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertSame((Object)moduleNode, (Object)child);
    }

    public void testMove() throws Exception {
        INavigationNode<?> targetModuleGroup = this.createTargetModuleGroup();
        NavigationProcessorTest.assertEquals((Object)this.module2, (Object)this.moduleGroup.getChild(1));
        NavigationProcessorTest.assertEquals((int)2, (int)this.moduleGroup.getChildren().size());
        NavigationProcessorTest.assertEquals((int)0, (int)this.moduleGroup2.getChildren().size());
        this.module2.moveTo(new NavigationNodeId(TARGET_MODULE_GROUP));
        NavigationProcessorTest.assertEquals((int)1, (int)this.moduleGroup.getChildren().size());
        NavigationProcessorTest.assertEquals((int)1, (int)this.moduleGroup2.getChildren().size());
        NavigationProcessorTest.assertEquals((Object)this.module2, (Object)targetModuleGroup.getChild(0));
    }

    public void testMoveBlocked() throws Exception {
        INavigationNode<?> targetModuleGroup = this.createTargetModuleGroup();
        this.module2.setBlocked(true);
        this.module2.moveTo(new NavigationNodeId(TARGET_MODULE_GROUP));
        NavigationProcessorTest.assertEquals((Object)this.module2, (Object)targetModuleGroup.getChild(0));
        NavigationProcessorTest.assertTrue((boolean)this.module2.isBlocked());
        NavigationProcessorTest.assertFalse((boolean)this.moduleGroup2.isBlocked());
    }

    public void testMoveEnabled() throws Exception {
        INavigationNode<?> targetModuleGroup = this.createTargetModuleGroup();
        this.module2.setEnabled(true);
        this.module2.moveTo(new NavigationNodeId(TARGET_MODULE_GROUP));
        NavigationProcessorTest.assertEquals((Object)this.module2, (Object)targetModuleGroup.getChild(0));
        NavigationProcessorTest.assertTrue((boolean)this.module2.isEnabled());
    }

    public void testMoveVisible() throws Exception {
        INavigationNode<?> targetModuleGroup = this.createTargetModuleGroup();
        this.module2.setVisible(true);
        this.module2.moveTo(new NavigationNodeId(TARGET_MODULE_GROUP));
        NavigationProcessorTest.assertEquals((Object)this.module2, (Object)targetModuleGroup.getChild(0));
        NavigationProcessorTest.assertTrue((boolean)this.module2.isVisible());
    }

    public void testPrepare() {
        TestSubModuleNode node = new TestSubModuleNode(new NavigationNodeId("4711"));
        this.navigationProcessor.prepare((INavigationNode)node);
        INavigationContext context = node.getNaviContext();
        NavigationProcessorTest.assertNotNull((Object)context);
        NavigationProcessorTest.assertNotNull((Object)context.getToPrepare());
        NavigationProcessorTest.assertEquals((int)1, (int)context.getToPrepare().size());
        NavigationProcessorTest.assertTrue((boolean)context.getToActivate().isEmpty());
        NavigationProcessorTest.assertTrue((boolean)context.getToDeactivate().isEmpty());
        NavigationProcessorTest.assertSame((Object)((Object)node), context.getToPrepare().get(0));
    }

    public void testHistoryBack() {
        TestSubModuleNode node = new TestSubModuleNode(new NavigationNodeId("4711"));
        this.module.addChild((INavigationNode)node);
        this.subModule1.activate();
        node.activate();
        NavigationProcessorTest.assertFalse((boolean)this.subModule1.isActivated());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        NavigationProcessorTest.assertEquals((int)0, (int)this.navigationProcessor.getHistoryForwardSize());
        NavigationProcessorTest.assertEquals((int)1, (int)this.navigationProcessor.getHistoryBackSize());
        this.navigationProcessor.historyBack();
        NavigationProcessorTest.assertTrue((boolean)this.subModule1.isActivated());
        NavigationProcessorTest.assertFalse((boolean)node.isActivated());
        NavigationProcessorTest.assertEquals((int)1, (int)this.navigationProcessor.getHistoryForwardSize());
        NavigationProcessorTest.assertEquals((int)0, (int)this.navigationProcessor.getHistoryBackSize());
        this.navigationProcessor.historyBack();
        NavigationProcessorTest.assertTrue((boolean)this.subModule1.isActivated());
        NavigationProcessorTest.assertFalse((boolean)node.isActivated());
        NavigationProcessorTest.assertEquals((int)1, (int)this.navigationProcessor.getHistoryForwardSize());
        NavigationProcessorTest.assertEquals((int)0, (int)this.navigationProcessor.getHistoryBackSize());
    }

    public void testHistoryForeward() {
        TestSubModuleNode node = new TestSubModuleNode(new NavigationNodeId("4711"));
        this.module.addChild((INavigationNode)node);
        this.subModule1.activate();
        node.activate();
        NavigationProcessorTest.assertFalse((boolean)this.subModule1.isActivated());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        NavigationProcessorTest.assertEquals((int)0, (int)this.navigationProcessor.getHistoryForwardSize());
        NavigationProcessorTest.assertEquals((int)1, (int)this.navigationProcessor.getHistoryBackSize());
        this.navigationProcessor.historyBack();
        NavigationProcessorTest.assertTrue((boolean)this.subModule1.isActivated());
        NavigationProcessorTest.assertFalse((boolean)node.isActivated());
        NavigationProcessorTest.assertEquals((int)1, (int)this.navigationProcessor.getHistoryForwardSize());
        NavigationProcessorTest.assertEquals((int)0, (int)this.navigationProcessor.getHistoryBackSize());
        this.navigationProcessor.historyForward();
        NavigationProcessorTest.assertFalse((boolean)this.subModule1.isActivated());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        NavigationProcessorTest.assertEquals((int)0, (int)this.navigationProcessor.getHistoryForwardSize());
        NavigationProcessorTest.assertEquals((int)1, (int)this.navigationProcessor.getHistoryBackSize());
        this.navigationProcessor.historyForward();
        NavigationProcessorTest.assertFalse((boolean)this.subModule1.isActivated());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        NavigationProcessorTest.assertEquals((int)0, (int)this.navigationProcessor.getHistoryForwardSize());
        NavigationProcessorTest.assertEquals((int)1, (int)this.navigationProcessor.getHistoryBackSize());
    }

    public void testGetHistory() {
        TestSubModuleNode node = new TestSubModuleNode(new NavigationNodeId("4711"));
        this.module.addChild((INavigationNode)node);
        this.subModule1.activate();
        node.activate();
        NavigationProcessorTest.assertFalse((boolean)this.subModule1.isActivated());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        NavigationProcessorTest.assertEquals((int)0, (int)this.navigationProcessor.getHistoryForwardSize());
        NavigationProcessorTest.assertEquals((int)1, (int)this.navigationProcessor.getHistoryBackSize());
        NavigationProcessorTest.assertEquals((int)2, (int)this.navigationProcessor.getHistory().size());
        NavigationProcessorTest.assertEquals((Object)this.subModule1, this.navigationProcessor.getHistory().get(0));
        NavigationProcessorTest.assertEquals((Object)((Object)node), this.navigationProcessor.getHistory().get(1));
        node = new TestSubModuleNode(new NavigationNodeId("0815"));
        try {
            this.navigationProcessor.getHistory().add(node);
            NavigationProcessorTest.fail();
        }
        catch (UnsupportedOperationException e) {
            NavigationProcessorTest.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
        try {
            this.navigationProcessor.getHistory().remove(this.subModule1);
            NavigationProcessorTest.fail();
        }
        catch (UnsupportedOperationException e) {
            NavigationProcessorTest.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
    }

    public void testFindSelectableChildNode() {
        ISubModuleNode selectableChild = (ISubModuleNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"findSelectableChildNode", (Object[])new Object[]{this.subModule1});
        NavigationProcessorTest.assertSame((Object)this.subModule1, (Object)selectableChild);
        this.subModule1.setSelectable(false);
        selectableChild = (ISubModuleNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"findSelectableChildNode", (Object[])new Object[]{this.subModule1});
        NavigationProcessorTest.assertNull((Object)selectableChild);
        TestSubModuleNode node = new TestSubModuleNode(new NavigationNodeId("4711"));
        this.subModule1.addChild((INavigationNode)node);
        selectableChild = (ISubModuleNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"findSelectableChildNode", (Object[])new Object[]{this.subModule1});
        NavigationProcessorTest.assertSame((Object)((Object)node), (Object)selectableChild);
    }

    public void testJump() throws Exception {
        ApplicationNode app = new ApplicationNode();
        SubApplicationNode subApp = new SubApplicationNode();
        app.addChild((INavigationNode)subApp);
        ModuleGroupNode mg = new ModuleGroupNode();
        subApp.addChild((INavigationNode)mg);
        ModuleNode m1 = new ModuleNode(new NavigationNodeId("m1"));
        mg.addChild((INavigationNode)m1);
        ModuleNode m2 = new ModuleNode(new NavigationNodeId("m2"));
        mg.addChild((INavigationNode)m2);
        SubModuleNode m1s1 = new SubModuleNode(new NavigationNodeId("m1s1"));
        m1.addChild((INavigationNode)m1s1);
        final SubModuleNode m1s2 = new SubModuleNode(new NavigationNodeId("m1s2"));
        m1.addChild((INavigationNode)m1s2);
        SubModuleNode m1s1s1 = new SubModuleNode(new NavigationNodeId("m1s1s1"));
        m1s1.addChild((INavigationNode)m1s1s1);
        SubModuleNode m2s1 = new SubModuleNode(new NavigationNodeId("m2s1"));
        m2.addChild((INavigationNode)m2s1);
        SubModuleNode m2s2 = new SubModuleNode(new NavigationNodeId("m2s2"));
        m2.addChild((INavigationNode)m2s2);
        app.activate();
        IJumpTargetListener listenerMock = (IJumpTargetListener)EasyMock.createMock(IJumpTargetListener.class);
        listenerMock.jumpTargetStateChanged((INavigationNode)m1, IJumpTargetListener.JumpTargetState.ENABLED);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{listenerMock});
        m1.addJumpTargetListener(listenerMock);
        m1s2.jump(new NavigationNodeId("m1s1s1"));
        NavigationProcessorTest.assertTrue((boolean)m1s1s1.isActivated());
        NavigationProcessorTest.assertTrue((boolean)m1s1s1.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)m1.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)m2.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)m2s1.isJumpTarget());
        NavigationProcessorTest.assertFalse((boolean)subApp.isJumpTarget());
        EasyMock.verify((Object[])new Object[]{listenerMock});
        EasyMock.reset((Object[])new Object[]{listenerMock});
        listenerMock.jumpTargetStateChanged((INavigationNode)m1, IJumpTargetListener.JumpTargetState.DISABLED);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{listenerMock});
        m1s2.addSimpleListener((ISimpleNavigationNodeListener)new SimpleNavigationNodeAdapter(){

            public void activated(INavigationNode<?> source) {
                m1s2.isJumpTarget();
            }
        });
        m2s1.jumpBack();
        EasyMock.verify((Object[])new Object[]{listenerMock});
        EasyMock.reset((Object[])new Object[]{listenerMock});
        NavigationProcessorTest.assertTrue((boolean)m1s2.isActivated());
        m1s2.jump(new NavigationNodeId("m1s1"));
        NavigationProcessorTest.assertTrue((boolean)m1s1.isActivated());
        m1s1.jump(new NavigationNodeId("m2s1"));
        NavigationProcessorTest.assertTrue((boolean)m2s1.isActivated());
        m2s1.jumpBack();
        NavigationProcessorTest.assertTrue((boolean)m1s1.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)m1.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)m2.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)m2s1.isJumpTarget());
        NavigationProcessorTest.assertFalse((boolean)subApp.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)m1s1.isActivated());
        m1.jumpBack();
        NavigationProcessorTest.assertTrue((boolean)m1s2.isActivated());
        m1.jumpBack();
        m1.jump(new NavigationNodeId("m2s1"));
        EasyMock.reset((Object[])new Object[]{listenerMock});
        listenerMock.jumpTargetStateChanged((INavigationNode)m1, IJumpTargetListener.JumpTargetState.DISABLED);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{listenerMock});
        m2s1.dispose();
        EasyMock.verify((Object[])new Object[]{listenerMock});
        EasyMock.reset((Object[])new Object[]{listenerMock});
        NavigationProcessorTest.assertFalse((boolean)m1s1.isJumpTarget());
        NavigationProcessorTest.assertFalse((boolean)m1.isJumpTarget());
        NavigationProcessorTest.assertFalse((boolean)m2.isJumpTarget());
        m1s1.jump(new NavigationNodeId("m2s2"));
        EasyMock.reset((Object[])new Object[]{listenerMock});
        listenerMock.jumpTargetStateChanged((INavigationNode)m1, IJumpTargetListener.JumpTargetState.DISABLED);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{listenerMock});
        NavigationProcessorTest.assertTrue((boolean)m2s2.isActivated());
        NavigationProcessorTest.assertTrue((boolean)m1s1.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)m1.isJumpTarget());
        NavigationProcessorTest.assertTrue((boolean)m2.isJumpTarget());
        m1s1.dispose();
        EasyMock.verify((Object[])new Object[]{listenerMock});
        EasyMock.reset((Object[])new Object[]{listenerMock});
        NavigationProcessorTest.assertFalse((boolean)m1s1.isJumpTarget());
        NavigationProcessorTest.assertFalse((boolean)m1.isJumpTarget());
        NavigationProcessorTest.assertFalse((boolean)m2.isJumpTarget());
    }

    private INavigationNode<?> createTargetModuleGroup() {
        INavigationNode targetModuleGroup = this.navigationProcessor.create((INavigationNode)this.subApplication, new NavigationNodeId(TARGET_MODULE_GROUP), null);
        return targetModuleGroup;
    }

    class DummyJumpTargetListener
    implements IJumpTargetListener {
        private IJumpTargetListener.JumpTargetState jumpTargetState;
        private INavigationNode<?> node;

        DummyJumpTargetListener() {
            this.reset();
        }

        public void jumpTargetStateChanged(INavigationNode<?> node, IJumpTargetListener.JumpTargetState jumpTargetState) {
            this.jumpTargetState = jumpTargetState;
            this.node = node;
        }

        void reset() {
            this.jumpTargetState = null;
            this.node = null;
        }
    }

    public static class TestSubModuleNode
    extends SubModuleNode {
        private boolean allowsActivate = true;
        private boolean allowsDeactivate = true;
        private boolean allowsDispose = true;
        private INavigationContext naviContext;

        public TestSubModuleNode(NavigationNodeId nodeId) {
            super(nodeId);
        }

        public boolean allowsActivate(INavigationContext context) {
            return this.allowsActivate;
        }

        public boolean allowsDeactivate(INavigationContext context) {
            return this.allowsDeactivate;
        }

        public boolean allowsDispose(INavigationContext context) {
            return this.allowsDispose;
        }

        public void setAllowsActivate(boolean allowsActivate) {
            this.allowsActivate = allowsActivate;
        }

        public void setAllowsDeactivate(boolean allowsDeactivate) {
            this.allowsDeactivate = allowsDeactivate;
        }

        public void setAllowsDispose(boolean allowsDispose) {
            this.allowsDispose = allowsDispose;
        }

        public void prepare(INavigationContext context) {
            super.prepare(context);
            this.naviContext = context;
        }

        public INavigationContext getNaviContext() {
            return this.naviContext;
        }
    }
}

