/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ToolItemRidget;
import org.eclipse.riena.navigation.ui.swt.component.IEntriesProvider;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.navigation.ui.swt.views.RienaMenuHelper;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractRidgetController;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class RienaMenuHelperTest
extends TestCase {
    private Shell shell;
    private RienaMenuHelper rienaMenuHelper;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        locator.setBindingProperty((Object)this.shell, "applicationWindow");
        this.rienaMenuHelper = new RienaMenuHelper();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testGetCoolBars() throws Exception {
        Composite comp1 = new Composite((Composite)this.shell, 0);
        List coolBars = (List)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getCoolBars", (Object[])new Object[]{this.shell});
        RienaMenuHelperTest.assertNotNull((Object)coolBars);
        RienaMenuHelperTest.assertTrue((boolean)coolBars.isEmpty());
        IEntriesProvider entriesProvider = new IEntriesProvider(){

            public IContributionItem[] getTopLevelEntries() {
                return new IContributionItem[0];
            }
        };
        new MenuCoolBarComposite(comp1, 0, entriesProvider);
        coolBars = (List)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getCoolBars", (Object[])new Object[]{this.shell});
        RienaMenuHelperTest.assertNotNull((Object)coolBars);
        RienaMenuHelperTest.assertTrue((boolean)coolBars.isEmpty());
        CoolBar coolBar = new CoolBar(comp1, 0);
        coolBars = (List)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getCoolBars", (Object[])new Object[]{this.shell});
        RienaMenuHelperTest.assertNotNull((Object)coolBars);
        RienaMenuHelperTest.assertFalse((boolean)coolBars.isEmpty());
        RienaMenuHelperTest.assertEquals((int)1, (int)coolBars.size());
        RienaMenuHelperTest.assertSame((Object)coolBar, coolBars.get(0));
    }

    public void testGetToolBars() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        List toolBars = (List)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getToolBars", (Object[])new Object[]{coolBar});
        RienaMenuHelperTest.assertNotNull((Object)toolBars);
        RienaMenuHelperTest.assertTrue((boolean)toolBars.isEmpty());
        ToolBar toolBar = new ToolBar((Composite)coolBar, 0);
        ToolBar toolBar2 = new ToolBar((Composite)coolBar, 0);
        toolBars = (List)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getToolBars", (Object[])new Object[]{coolBar});
        RienaMenuHelperTest.assertNotNull((Object)toolBars);
        RienaMenuHelperTest.assertFalse((boolean)toolBars.isEmpty());
        RienaMenuHelperTest.assertEquals((int)2, (int)toolBars.size());
        RienaMenuHelperTest.assertSame((Object)toolBar, toolBars.get(0));
        RienaMenuHelperTest.assertSame((Object)toolBar2, toolBars.get(1));
    }

    public void testGetAllToolItems() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        ToolBar toolBar = new ToolBar((Composite)coolBar, 0);
        ToolBar toolBar2 = new ToolBar((Composite)coolBar, 0);
        List items = (List)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getAllToolItems", (Object[])new Object[]{this.shell});
        RienaMenuHelperTest.assertNotNull((Object)items);
        RienaMenuHelperTest.assertTrue((boolean)items.isEmpty());
        ToolItem item = new ToolItem(toolBar, 0);
        ToolItem item2 = new ToolItem(toolBar2, 0);
        items = (List)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getAllToolItems", (Object[])new Object[]{this.shell});
        RienaMenuHelperTest.assertNotNull((Object)items);
        RienaMenuHelperTest.assertFalse((boolean)items.isEmpty());
        RienaMenuHelperTest.assertEquals((int)2, (int)items.size());
        RienaMenuHelperTest.assertSame((Object)item, items.get(0));
        RienaMenuHelperTest.assertSame((Object)item2, items.get(1));
        new IEntriesProvider(){

            public IContributionItem[] getTopLevelEntries() {
                return new IContributionItem[0];
            }
        };
    }

    public void testCreateRidgetItem() {
        Controller controller = new Controller();
        Menu menu = new Menu((Control)this.shell);
        MenuItem menuItem = new MenuItem(menu, 0);
        MyContributionItem contributionItem = new MyContributionItem();
        contributionItem.setId("4711");
        menuItem.setData((Object)contributionItem);
        ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"createRidget", (Object[])new Object[]{controller, menuItem});
        RienaMenuHelperTest.assertFalse((boolean)controller.getRidgets().isEmpty());
        RienaMenuHelperTest.assertEquals((int)1, (int)controller.getRidgets().size());
        IRidget ridget = controller.getRidget("menuAction.4711");
        RienaMenuHelperTest.assertNotNull((Object)ridget);
        RienaMenuHelperTest.assertTrue((boolean)(ridget instanceof MenuItemRidget));
        RienaMenuHelperTest.assertEquals((String)"menuAction.4711", (String)SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)menuItem));
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        ToolBar toolBar = new ToolBar((Composite)coolBar, 0);
        ToolItem toolItem = new ToolItem(toolBar, 0);
        contributionItem = new MyContributionItem();
        contributionItem.setId("0815");
        toolItem.setData((Object)contributionItem);
        ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"createRidget", (Object[])new Object[]{controller, toolItem});
        RienaMenuHelperTest.assertFalse((boolean)controller.getRidgets().isEmpty());
        RienaMenuHelperTest.assertEquals((int)2, (int)controller.getRidgets().size());
        ridget = controller.getRidget("toolbarAction.0815");
        RienaMenuHelperTest.assertNotNull((Object)ridget);
        RienaMenuHelperTest.assertTrue((boolean)(ridget instanceof ToolItemRidget));
        RienaMenuHelperTest.assertEquals((String)"toolbarAction.0815", (String)SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)toolItem));
    }

    public void testCreateRidgetMenu() {
        Controller controller = new Controller();
        Menu menu = new Menu((Control)this.shell);
        MenuItem item = new MenuItem(menu, 0);
        MyContributionItem contributionItem = new MyContributionItem();
        contributionItem.setId("4711");
        item.setData((Object)contributionItem);
        ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"createRidget", (Object[])new Object[]{controller, menu});
        RienaMenuHelperTest.assertFalse((boolean)controller.getRidgets().isEmpty());
        RienaMenuHelperTest.assertEquals((int)1, (int)controller.getRidgets().size());
        IRidget ridget = controller.getRidget("menuAction.4711");
        RienaMenuHelperTest.assertNotNull((Object)ridget);
        RienaMenuHelperTest.assertTrue((boolean)(ridget instanceof MenuItemRidget));
        RienaMenuHelperTest.assertEquals((String)"menuAction.4711", (String)SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)item));
    }

    public void testGetItemId() {
        Menu menu = new Menu((Control)this.shell);
        MenuItem item = new MenuItem(menu, 0);
        String id = (String)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getItemId", (Object[])new Object[]{item});
        RienaMenuHelperTest.assertNotNull((Object)id);
        RienaMenuHelperTest.assertEquals((String)"1", (String)id);
        id = (String)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getItemId", (Object[])new Object[]{item});
        RienaMenuHelperTest.assertNotNull((Object)id);
        RienaMenuHelperTest.assertEquals((String)"2", (String)id);
        MyContributionItem contributionItem = new MyContributionItem();
        contributionItem.setId("4711");
        item.setData((Object)contributionItem);
        id = (String)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getItemId", (Object[])new Object[]{item});
        RienaMenuHelperTest.assertNotNull((Object)id);
        RienaMenuHelperTest.assertEquals((String)"menuAction.4711", (String)id);
        MenuItem item2 = new MenuItem(menu, 0);
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        locator.setBindingProperty((Object)item2, "0815");
        id = (String)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getItemId", (Object[])new Object[]{item2});
        RienaMenuHelperTest.assertNotNull((Object)id);
        RienaMenuHelperTest.assertEquals((String)"menuAction.0815", (String)id);
    }

    public void testGetMenuCoolBarComposites() {
        Composite comp1 = new Composite((Composite)this.shell, 0);
        List composites = (List)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getMenuCoolBarComposites", (Object[])new Object[]{this.shell});
        RienaMenuHelperTest.assertNotNull((Object)composites);
        RienaMenuHelperTest.assertTrue((boolean)composites.isEmpty());
        IEntriesProvider entriesProvider = new IEntriesProvider(){

            public IContributionItem[] getTopLevelEntries() {
                return new IContributionItem[0];
            }
        };
        MenuCoolBarComposite menuComposite = new MenuCoolBarComposite(comp1, 0, entriesProvider);
        composites = (List)ReflectionUtils.invokeHidden((Object)this.rienaMenuHelper, (String)"getMenuCoolBarComposites", (Object[])new Object[]{this.shell});
        RienaMenuHelperTest.assertNotNull((Object)composites);
        RienaMenuHelperTest.assertFalse((boolean)composites.isEmpty());
        RienaMenuHelperTest.assertEquals((int)1, (int)composites.size());
        RienaMenuHelperTest.assertSame((Object)menuComposite, composites.get(0));
    }

    private static class Controller
    extends AbstractRidgetController {
        private Controller() {
        }

        public void configureRidgets() {
        }
    }

    private static class MyContributionItem
    extends ContributionItem {
        private MyContributionItem() {
        }
    }
}

