/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.core.uiprocess.IUISynchronizer;
import org.eclipse.riena.ui.core.uiprocess.ProgressProviderBridge;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;
import org.eclipse.riena.ui.swt.uiprocess.SwtUISynchronizer;

@NonUITestCase
public class ProgressProviderBridgeTest
extends TestCase {
    public void testGetRunningUIProcesses() throws Exception {
        ProgressProviderBridge bridge = new ProgressProviderBridge(){

            protected void registerJobChangeListener() {
            }
        };
        SingletonProvider singletonProvider = (SingletonProvider)ReflectionUtils.getHidden(ProgressProviderBridge.class, (String)"PPB");
        ReflectionUtils.setHidden((Object)singletonProvider, (String)"singleton", (Object)bridge);
        Job.getJobManager().setProgressProvider((ProgressProvider)bridge);
        UIProcess p1 = new UIProcess("p1", (IUISynchronizer)new SwtUISynchronizer(), true, new Object());
        p1.start();
        List runningUIProcesses = bridge.getRegisteredUIProcesses();
        ProgressProviderBridgeTest.assertEquals((int)1, (int)runningUIProcesses.size());
        ProgressProviderBridgeTest.assertEquals((Object)p1, runningUIProcesses.get(0));
        bridge.unregisterMapping((Job)ReflectionUtils.invokeHidden((Object)p1, (String)"getJob", (Object[])new Object[0]));
        ProgressProviderBridgeTest.assertEquals((int)0, (int)bridge.getRegisteredUIProcesses().size());
    }
}

