/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractItemRidget;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractItemProperties {
    private final AbstractItemRidget ridget;
    private final int style;
    private final Object data;
    private final String id;
    private final String text;
    private final Image image;
    private final Listener[] selectionListeners;

    public AbstractItemProperties(AbstractItemRidget ridget) {
        Item item = ridget.getUIControl();
        this.style = item.getStyle();
        this.data = item.getData();
        this.id = ridget.getID();
        this.text = item.getText();
        this.image = item.getImage();
        this.selectionListeners = item.getListeners(13);
        this.ridget = ridget;
    }

    protected void setAllProperties(Item item, boolean addListeners) {
        item.setData(this.data);
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        locator.setBindingProperty((Object)item, this.id);
        item.setText(this.text);
        if (this.image == null || !this.image.isDisposed()) {
            item.setImage(this.image);
        }
        if (addListeners) {
            Listener[] listenerArray = this.selectionListeners;
            int n = this.selectionListeners.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                item.addListener(13, listener);
                ++n2;
            }
        }
    }

    protected int getStyle() {
        return this.style;
    }

    protected AbstractItemRidget getRidget() {
        return this.ridget;
    }

    protected IContributionItem getContributionItem() {
        if (this.data instanceof IContributionItem) {
            return (IContributionItem)this.data;
        }
        return null;
    }

    abstract Item createItem();
}

