/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.ui.ridgets.IMenuItemRidget;
import org.eclipse.swt.widgets.MenuItem;

public class ContextMenuDelegate {
    private final List<IMenuItemRidget> menuItems = new LinkedList<IMenuItemRidget>();

    public List<IMenuItemRidget> getMenuItems() {
        return this.menuItems;
    }

    public IMenuItemRidget addMenuItem(String menuText, String iconName) {
        IMenuItemRidget mi = this.getMenuRidget(menuText);
        return this.addMenuItem(mi, menuText, iconName);
    }

    private IMenuItemRidget addMenuItem(IMenuItemRidget menuItemRidget, String menuText, String iconName) {
        menuItemRidget.setText(menuText);
        if (iconName != null) {
            menuItemRidget.setIcon(iconName);
        }
        if (this.isNotInList(menuText)) {
            this.menuItems.add(menuItemRidget);
        }
        return menuItemRidget;
    }

    public void removeMenuItem(String menuItemText) {
        this.removeMenuItem(this.getMenuRidget(menuItemText));
    }

    public void removeMenuItem(IMenuItemRidget menuItemRidget) {
        if (!this.menuItems.isEmpty() && menuItemRidget != null) {
            if (menuItemRidget.getUIControl() != null) {
                ((MenuItem)menuItemRidget.getUIControl()).dispose();
            }
            this.menuItems.remove(menuItemRidget);
        }
    }

    private boolean isNotInList(String id) {
        for (IMenuItemRidget menuItemRidget : this.menuItems) {
            if (!menuItemRidget.getText().equals(id)) continue;
            return false;
        }
        return true;
    }

    private IMenuItemRidget getMenuRidget(String id) {
        for (IMenuItemRidget menuItemRidget : this.menuItems) {
            if (!menuItemRidget.getText().equals(id)) continue;
            return menuItemRidget;
        }
        IMenuItemRidget ridget = null;
        try {
            ridget = (IMenuItemRidget)MenuItemRidget.class.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return ridget;
    }

    public IMenuItemRidget getMenuItem(int index) {
        if (this.menuItems == null || this.menuItems.isEmpty()) {
            throw new IllegalStateException("No menu items in context menu.");
        }
        if (index >= this.menuItems.size() || index < 0) {
            throw new IllegalArgumentException("No menu item at index " + index + " found");
        }
        return this.menuItems.get(index);
    }

    public int getMenuItemCount() {
        return this.menuItems.size();
    }
}

