/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractItemProperties;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class MenuItemProperties
extends AbstractItemProperties {
    private final Menu parent;
    private List<String> prevSiblingIds;

    public MenuItemProperties(MenuItemRidget ridget) {
        super(ridget);
        MenuItem item = ridget.getUIControl();
        this.parent = item.getParent();
        this.storePreviousSiblings(item);
    }

    private void storePreviousSiblings(MenuItem item) {
        int index = this.parent.indexOf(item);
        MenuItem[] siblings = this.parent.getItems();
        this.prevSiblingIds = new ArrayList<String>();
        int i = 0;
        while (i < index) {
            this.prevSiblingIds.add(SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)siblings[i]));
            ++i;
        }
    }

    protected int getIndex() {
        MenuItem[] siblings;
        int index = 0;
        if (SwtUtilities.isDisposed((Widget)this.parent)) {
            return index;
        }
        MenuItem[] menuItemArray = siblings = this.parent.getItems();
        int n = siblings.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem sibling = menuItemArray[n2];
            String id = SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)sibling);
            if (this.prevSiblingIds.contains(id)) {
                ++index;
            }
            ++n2;
        }
        return index;
    }

    protected MenuItem createItem() {
        return this.createItem(this.getParent());
    }

    @Override
    protected MenuItemRidget getRidget() {
        return (MenuItemRidget)super.getRidget();
    }

    protected MenuItem createItem(Menu parent) {
        MenuItem menuItem;
        IContributionItem contributionItem = this.getContributionItem();
        if (contributionItem != null) {
            int index = this.getIndex();
            contributionItem.fill(parent, index);
            menuItem = parent.getItem(index);
            this.setAllProperties((Item)menuItem, false);
            contributionItem.update();
        } else {
            menuItem = new MenuItem(parent, this.getStyle(), this.getIndex());
            this.setAllProperties((Item)menuItem, true);
        }
        this.getRidget().setUIControl(menuItem);
        return menuItem;
    }

    protected Menu getParent() {
        return this.parent;
    }
}

