/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTraverseRidget;
import org.eclipse.riena.ui.ridgets.ISpinnerRidget;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerRidget
extends AbstractTraverseRidget
implements ISpinnerRidget {
    public static final int LIMIT = Spinner.LIMIT - 1;
    private int textLimit = Integer.MIN_VALUE;
    private int digits = Integer.MIN_VALUE;

    @Override
    public void checkUIControl(Object uiControl) {
        this.checkType(uiControl, Spinner.class);
    }

    public int getDigits() {
        return this.digits;
    }

    public int getTextLimit() {
        return this.textLimit;
    }

    public Spinner getUIControl() {
        return (Spinner)super.getUIControl();
    }

    public void setDigits(int digits) {
        this.checkDigits(digits);
        digits = this.preSetDigits(digits);
        Integer oldValue = this.digits;
        this.digits = digits;
        this.updateUIDigits();
        this.updateToolTip();
        this.firePropertyChange("digits", oldValue, this.digits);
    }

    public void setTextLimit(int textLimit) {
        this.checkTextLimit(textLimit);
        textLimit = this.preSetTextLimit(textLimit);
        Integer oldValue = this.textLimit;
        this.textLimit = textLimit;
        this.updateUITextLimit();
        this.firePropertyChange("textLimit", oldValue, this.textLimit);
    }

    @Override
    protected void addSelectionListener(Control control, SelectionListener listener) {
        ((Spinner)control).addSelectionListener(listener);
    }

    @Override
    protected int getValue(Control control) {
        return this.getUIControl().getSelection();
    }

    @Override
    protected void initAdditionalsFromUIControl() {
        Spinner spinner = this.getUIControl();
        if (spinner != null) {
            if (this.getTextLimit() == Integer.MIN_VALUE) {
                this.setTextLimit(spinner.getTextLimit());
            }
            if (this.getDigits() == Integer.MIN_VALUE) {
                this.setDigits(spinner.getDigits());
            }
        }
    }

    protected int preSetDigits(int digits) {
        if (digits < 0) {
            digits = 0;
        }
        return digits;
    }

    protected int preSetTextLimit(int textLimit) {
        if (textLimit > LIMIT) {
            textLimit = LIMIT;
        }
        if (this.digits > textLimit) {
            this.setDigits(textLimit);
        }
        return textLimit;
    }

    @Override
    protected void removeSelectionListener(Control control, SelectionListener listener) {
        ((Spinner)control).removeSelectionListener(listener);
    }

    @Override
    protected String replaceToolTipPattern(String toolTipTemplate) {
        if (this.getDigits() > 0) {
            int intSelection = this.getValue();
            double value = (double)intSelection / Math.pow(10.0, this.getDigits());
            return toolTipTemplate.replace("[VALUE]", Double.toString(value));
        }
        return super.replaceToolTipPattern(toolTipTemplate);
    }

    @Override
    protected void updateUIControl() {
        super.updateUIControl();
        this.updateUITextLimit();
        this.updateUIDigits();
    }

    protected void updateUIDigits() {
        Spinner control = this.getUIControl();
        if (control != null && control.getDigits() != this.getDigits()) {
            control.setDigits(this.getDigits());
        }
    }

    @Override
    protected void updateUIIncrement() {
        Spinner control = this.getUIControl();
        if (control != null) {
            control.setIncrement(this.getIncrement());
        }
    }

    @Override
    protected void updateUIMaximum() {
        Spinner control = this.getUIControl();
        if (control != null) {
            control.setMaximum(this.getMaximum());
        }
    }

    @Override
    protected void updateUIMinimum() {
        Spinner control = this.getUIControl();
        if (control != null) {
            control.setMinimum(this.getMinimum());
        }
    }

    @Override
    protected void updateUIPageIncrement() {
        Spinner control = this.getUIControl();
        if (control != null) {
            control.setPageIncrement(this.getPageIncrement());
        }
    }

    protected void updateUITextLimit() {
        Spinner control = this.getUIControl();
        if (control != null) {
            control.setTextLimit(this.getTextLimit());
        }
    }

    @Override
    protected void updateUIValue() {
        Spinner control = this.getUIControl();
        if (control != null) {
            control.setSelection(this.getValue());
        }
    }

    private void checkDigits(int digits) {
        if (digits > this.getTextLimit()) {
            new Message("The digit value of %d must be lower or equal than the textlimit value of %d", digits, this.getTextLimit()).push();
        }
    }

    private void checkTextLimit(int textLimit) {
        if (textLimit <= 0) {
            new Message("The textLimit value of %d must be greater than zero", textLimit).push();
        }
    }

    @Override
    protected int getUIControlIncrement() {
        return this.getUIControl().getIncrement();
    }

    @Override
    protected int getUIControlMaximum() {
        return this.getUIControl().getMaximum();
    }

    @Override
    protected int getUIControlMinimum() {
        return this.getUIControl().getMinimum();
    }

    @Override
    protected int getUIControlPageIncrement() {
        return this.getUIControl().getPageIncrement();
    }

    @Override
    protected int getUIControlSelection() {
        return this.getUIControl().getSelection();
    }

    protected static class Message
    extends AbstractTraverseRidget.Message {
        public static final String TEXTLIMIT_LE_ZERO = "The textLimit value of %d must be greater than zero";
        public static final String DIGITS_GT_TEXTLIMIT = "The digit value of %d must be lower or equal than the textlimit value of %d";

        public Message(String msgConstant, Object ... attributes) {
            super(msgConstant, attributes);
        }
    }
}

