/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidget;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Point;

public class TableRidgetTableViewer
extends CheckboxTableViewer {
    private static final Logger LOGGER = Log4r.getLogger(TableRidgetTableViewer.class);
    private final TableRidget tableRidget;
    private boolean allowRefresh = true;
    private TableRidgetCheckStateListener checkStateListener = null;

    public TableRidgetTableViewer(TableRidget tableRidget) {
        super(tableRidget.getUIControl());
        this.tableRidget = tableRidget;
        if (tableRidget.isCheckBoxInFirstColumn((AbstractTableViewer)this)) {
            this.checkStateListener = new TableRidgetCheckStateListener(tableRidget);
            this.addCheckStateListener(this.checkStateListener);
        }
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        if (this.checkStateListener != null) {
            this.removeCheckStateListener(this.checkStateListener);
            this.checkStateListener = null;
        }
    }

    public ViewerRow getViewerRow(Point point) {
        return super.getViewerRow(point);
    }

    public TableRidget getTableRidget() {
        return this.tableRidget;
    }

    public void setAllowRefresh(boolean allowRefresh) {
        this.allowRefresh = allowRefresh;
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        super.refresh();
    }

    protected boolean allowRefresh() {
        return this.allowRefresh;
    }

    private static final class TableRidgetCheckStateListener
    implements ICheckStateListener {
        private final TableRidget tableRidget;

        public TableRidgetCheckStateListener(TableRidget tableRidget) {
            this.tableRidget = tableRidget;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            PropertyDescriptor propertyDescriptor = this.tableRidget.getPropertyDescriptor(0);
            if (propertyDescriptor.getPropertyType() == Boolean.TYPE) {
                if (!this.tableRidget.isOutputOnly()) {
                    String propertyName = propertyDescriptor.getName();
                    IObservableValue observableValue = PojoObservables.observeValue((Object)event.getElement(), (String)propertyName);
                    observableValue.setValue((Object)event.getChecked());
                }
            } else {
                LOGGER.log(2, "Unexpected property type of first column!");
            }
            this.tableRidget.updateFromModel();
        }
    }
}

