/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;

public class MarkerUtil {
    public static List<IMarker> getRidgetMarkers(IRidgetContainer ridgetContainer) {
        ArrayList<IMarker> combinedMarkers = new ArrayList<IMarker>();
        MarkerUtil.addRidgetMarkers(ridgetContainer, combinedMarkers);
        return combinedMarkers;
    }

    private static void addRidgetMarkers(IRidget ridget, List<IMarker> combinedMarkers) {
        if (ridget instanceof IBasicMarkableRidget && ((IBasicMarkableRidget)ridget).isVisible() && ((IBasicMarkableRidget)ridget).isEnabled()) {
            MarkerUtil.addRidgetMarkers((IBasicMarkableRidget)ridget, combinedMarkers);
        } else if (ridget instanceof IRidgetContainer) {
            MarkerUtil.addRidgetMarkers((IRidgetContainer)((Object)ridget), combinedMarkers);
        }
    }

    private static void addRidgetMarkers(IBasicMarkableRidget ridget, List<IMarker> combinedMarkers) {
        combinedMarkers.addAll(MarkerUtil.getNotHiddenMarkers(ridget));
    }

    private static List<? extends IMarker> getNotHiddenMarkers(IBasicMarkableRidget ridget) {
        Collection markers = ridget.getMarkers();
        ArrayList notHiddenMarkers = new ArrayList(markers);
        Set<Class<IMarker>> hiddenTypes = ridget.getHiddenMarkerTypes();
        for (Class<IMarker> hiddenType : hiddenTypes) {
            for (IMarker marker : markers) {
                if (!hiddenType.isAssignableFrom(marker.getClass())) continue;
                notHiddenMarkers.remove(marker);
            }
        }
        return notHiddenMarkers;
    }

    private static void addRidgetMarkers(IRidgetContainer ridgetContainer, List<IMarker> combinedMarkers) {
        for (IRidget iRidget : ridgetContainer.getRidgets()) {
            MarkerUtil.addRidgetMarkers(iRidget, combinedMarkers);
        }
    }
}

