/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.tree2;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode2;

public class TreeNode
extends AbstractBean
implements ITreeNode,
ITreeNode2 {
    private final ITreeNode parent;
    private Object value;
    private List<ITreeNode> children;
    private boolean isEnabled;
    private boolean isVisible;

    private static void addToParent(ITreeNode parent, ITreeNode child) {
        Assert.isNotNull((Object)child);
        List<ITreeNode> pChildren = parent.getChildren();
        pChildren.add(child);
        parent.setChildren(pChildren);
    }

    public TreeNode(ITreeNode parent, Object value) {
        this.parent = parent;
        this.value = value;
        this.isEnabled = true;
        this.isVisible = true;
        if (parent != null) {
            TreeNode.addToParent(parent, this);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            this.firePropertyChanged("enabled", this.isEnabled, this.isEnabled);
        }
    }

    public void setVisible(boolean visible) {
        if (this.isVisible != visible) {
            this.isVisible = visible;
            this.firePropertyChanged("visible", this.isVisible, this.isVisible);
        }
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }

    public TreeNode(Object value) {
        this(null, value);
    }

    @Override
    public List<ITreeNode> getChildren() {
        return this.children != null ? new ArrayList<ITreeNode>(this.children) : new ArrayList();
    }

    @Override
    public ITreeNode getParent() {
        return this.parent;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setChildren(List<ITreeNode> children) {
        if (this.children != children) {
            ArrayList<ITreeNode> newValue = children != null ? new ArrayList<ITreeNode>(children) : null;
            this.children = newValue;
            this.firePropertyChanged("children", this.children, this.children);
        }
    }

    @Override
    public void setValue(Object value) {
        if (this.value != value) {
            Object oldValue = this.value;
            this.value = value;
            this.firePropertyChanged("value", oldValue, this.value);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }
}

