/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.Set;
import java.util.SortedSet;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class ListFromValuePossibleValuesService
extends PossibleValuesService {
    private PossibleValuesService base;
    private Listener listener;
    private boolean refreshing;

    @Override
    protected void initPossibleValuesService() {
        ListProperty listProperty = this.context(ListProperty.class);
        ValueProperty listMemberValueProperty = (ValueProperty)listProperty.getType().properties().first();
        this.base = listMemberValueProperty.service(PossibleValuesService.class);
        this.listener = new Listener(){

            @Override
            public void handle(Event event) {
                if (!ListFromValuePossibleValuesService.this.refreshing) {
                    try {
                        ListFromValuePossibleValuesService.this.refreshing = true;
                        ListFromValuePossibleValuesService.this.refresh();
                    }
                    finally {
                        ListFromValuePossibleValuesService.this.refreshing = false;
                    }
                }
            }
        };
        this.base.attach(this.listener);
    }

    @Override
    protected void compute(Set<String> values) {
        values.addAll(this.base.values());
    }

    @Override
    public Status problem(Value<?> value) {
        return this.base.problem(value);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.base.detach(this.listener);
            this.listener = null;
        }
        this.base = null;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            PropertyDef memberProperty;
            ElementType memberType;
            SortedSet<PropertyDef> properties;
            Property property = context.find(Property.class);
            return property != null && property.definition() instanceof ListProperty && property.service(PossibleTypesService.class).types().size() == 1 && (properties = (memberType = property.definition().getType()).properties()).size() == 1 && (memberProperty = properties.first()) instanceof ValueProperty && memberProperty.service(PossibleValuesService.class) != null;
        }
    }
}

