/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.PossibleTypesServiceData;

public final class StandardPossibleTypesService
extends PossibleTypesService {
    private Set<ElementType> possible;

    @Override
    protected void initPossibleTypesService() {
        PropertyDef property = this.context(PropertyDef.class);
        ArrayList<Class> possible = new ArrayList<Class>();
        Type typeAnnotation = property.getAnnotation(Type.class);
        if (property instanceof ElementProperty || property instanceof ListProperty) {
            if (typeAnnotation != null) {
                if (typeAnnotation.possible().length == 0) {
                    possible.add(typeAnnotation.base());
                } else {
                    Class<?>[] classArray = typeAnnotation.possible();
                    int n = classArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class cl = classArray[n2];
                        possible.add(cl);
                        ++n2;
                    }
                }
            }
            if (possible.size() == 1) {
                this.possible = Collections.singleton(ElementType.read((Class)possible.get(0)));
            } else {
                this.possible = new HashSet<ElementType>();
                for (Class cl : possible) {
                    this.possible.add(ElementType.read(cl));
                }
            }
        }
    }

    @Override
    protected PossibleTypesServiceData compute() {
        return new PossibleTypesServiceData(this.possible);
    }
}

