/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sapphire.Filter;

public final class ListFactory<E> {
    private Filter<E> filter;
    private E firstElement = null;
    private ArrayList<E> list = null;
    private boolean exported = false;

    private ListFactory() {
    }

    public static <E> List<E> empty() {
        return Collections.emptyList();
    }

    public static <E> List<E> singleton(E element) {
        return Collections.singletonList(element);
    }

    public static <E> List<E> unmodifiable(E ... elements) {
        return ListFactory.start().add(elements).result();
    }

    public static <E> List<E> unmodifiable(Collection<E> elements) {
        return ListFactory.start().add(elements).result();
    }

    public static <E> ListFactory<E> start() {
        return new ListFactory<E>();
    }

    public ListFactory<E> filter(Filter<E> filter) {
        if (this.exported) {
            throw new IllegalStateException();
        }
        this.filter = filter;
        if (this.filter != null) {
            if (this.list != null) {
                Iterator<E> itr = this.list.iterator();
                while (itr.hasNext()) {
                    if (this.filter.allows(itr.next())) continue;
                    itr.remove();
                }
                int size = this.list.size();
                if (size == 1) {
                    this.firstElement = this.list.get(0);
                    this.list = null;
                } else if (size == 0) {
                    this.list = null;
                }
            } else if (this.firstElement != null && !this.filter.allows(this.firstElement)) {
                this.firstElement = null;
            }
        }
        return this;
    }

    public ListFactory<E> add(E element) {
        if (this.exported) {
            throw new IllegalStateException();
        }
        if (element != null && (this.filter == null || this.filter.allows(element))) {
            if (this.list != null) {
                this.list.add(element);
            } else if (this.firstElement != null) {
                this.list = new ArrayList();
                this.list.add(this.firstElement);
                this.list.add(element);
                this.firstElement = null;
            } else {
                this.firstElement = element;
            }
        }
        return this;
    }

    public ListFactory<E> add(E ... elements) {
        if (elements != null) {
            E[] EArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                E element = EArray[n2];
                this.add(element);
                ++n2;
            }
        }
        return this;
    }

    public ListFactory<E> add(Collection<E> elements) {
        if (elements != null) {
            for (E element : elements) {
                this.add(element);
            }
        }
        return this;
    }

    public E remove(int index) {
        E removed;
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IllegalArgumentException();
        }
        if (this.list != null) {
            if (size == 2) {
                removed = this.list.get(index);
                this.firstElement = this.list.get(index == 0 ? 1 : 0);
                this.list = null;
            } else {
                removed = this.list.remove(index);
            }
        } else if (this.firstElement != null) {
            removed = this.firstElement;
            this.firstElement = null;
        } else {
            throw new IllegalStateException();
        }
        return removed;
    }

    public E get(int index) {
        E element;
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException();
        }
        if (this.list != null) {
            element = this.list.get(index);
        } else if (this.firstElement != null) {
            element = this.firstElement;
        } else {
            throw new IllegalStateException();
        }
        return element;
    }

    public boolean contains(E element) {
        boolean contains = false;
        if (this.list != null) {
            contains = this.list.contains(element);
        } else if (this.firstElement != null && this.firstElement.equals(element)) {
            contains = true;
        }
        return contains;
    }

    public int size() {
        int size = this.list != null ? this.list.size() : (this.firstElement != null ? 1 : 0);
        return size;
    }

    public List<E> result() {
        if (this.exported) {
            throw new IllegalStateException();
        }
        this.exported = true;
        if (this.list != null) {
            this.list.trimToSize();
            return Collections.unmodifiableList(this.list);
        }
        if (this.firstElement != null) {
            return Collections.singletonList(this.firstElement);
        }
        return Collections.emptyList();
    }
}

