/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.holders;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class HolderUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(HolderUtility.class);

    private HolderUtility() {
    }

    public static boolean containEqualValues(IHolder a, IHolder b) {
        Object va = a.getValue();
        Object vb = b.getValue();
        return CompareUtility.equals(va, vb);
    }

    public static <T> void setAndCastValue(IHolder<T> h, Object value) {
        if (h != null) {
            h.setValue(TypeCastUtility.castValue(value, h.getHolderType()));
        }
    }

    public static <T> IHolder<T> createSerializableHolder(IHolder<T> h) {
        if (h == null) {
            return null;
        }
        return new Holder<T>(h.getHolderType(), h.getValue());
    }
}

