/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.parsers;

import java.util.ArrayList;
import org.eclipse.scout.commons.parsers.token.FunctionInputToken;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueInputToken;
import org.eclipse.scout.commons.parsers.token.ValueOutputToken;

public class BindModel {
    private IToken[] m_allTokens;
    private IToken[] m_ioTokens;

    public BindModel(IToken[] tokens) {
        this.m_allTokens = tokens;
        ArrayList<IToken> ioList = new ArrayList<IToken>();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i] instanceof ValueInputToken) {
                ioList.add(tokens[i]);
            } else if (tokens[i] instanceof FunctionInputToken) {
                ioList.add(tokens[i]);
            } else if (tokens[i] instanceof ValueOutputToken) {
                ioList.add(tokens[i]);
            }
            ++i;
        }
        this.m_ioTokens = ioList.toArray(new IToken[ioList.size()]);
    }

    public IToken[] getAllTokens() {
        return this.m_allTokens;
    }

    public IToken[] getIOTokens() {
        return this.m_ioTokens;
    }

    public String getFilteredStatement() {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.m_allTokens.length) {
            if (this.m_allTokens[i] instanceof ValueInputToken) {
                ValueInputToken valueInputToken = (ValueInputToken)this.m_allTokens[i];
                if (valueInputToken.getParsedAttribute() != null) {
                    b.append(valueInputToken.getParsedAttribute());
                    b.append(" ");
                }
                if (valueInputToken.getParsedOp() != null) {
                    b.append(valueInputToken.getParsedOp());
                    b.append(" ");
                }
            }
            b.append(this.m_allTokens[i].getReplaceToken());
            ++i;
        }
        return b.toString();
    }
}

